/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.applications;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Image;
import com.intellij.docker.agent.ApiTaskBase;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.ApiTasksKt;
import com.intellij.docker.agent.AuthConfigEx;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.PushImageResultCallbackImpl;
import com.intellij.docker.agent.applications.DockerAgentApplicationBase;
import com.intellij.docker.agent.settings.DockerSystemInfo;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/intellij/docker/agent/applications/DockerAgentImageImpl;", "Lcom/intellij/docker/agent/applications/DockerAgentApplicationBase;", "Lcom/intellij/docker/agent/DockerAgentImage;", "agentContext", "Lcom/intellij/docker/agent/DockerAgentContext;", "image", "Lcom/github/dockerjava/api/model/Image;", "(Lcom/intellij/docker/agent/DockerAgentContext;Lcom/github/dockerjava/api/model/Image;)V", "getImage", "()Lcom/github/dockerjava/api/model/Image;", "imageId", "", "getImageId", "()Ljava/lang/String;", "imageRepoTags", "", "getImageRepoTags", "()[Ljava/lang/String;", "callDockerJavaInspection", "", "deleteImage", "", "getPresentableName", "getUniqueName", "loadImageUser", "loadSystemInfo", "Lcom/intellij/docker/agent/settings/DockerSystemInfo;", "pushImage", "Lcom/intellij/docker/agent/OngoingProcess;", "repositoryConfig", "Lcom/intellij/docker/agent/DockerAgentRepositoryConfig;", "progressCallback", "Lcom/intellij/docker/agent/DockerAgentProgressCallback;", "intellij.clouds.docker.agent.impl"})
public final class DockerAgentImageImpl
extends DockerAgentApplicationBase
implements DockerAgentImage {
    @NotNull
    private final Image image;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public String getPresentableName() {
        String string;
        String[] repoTags;
        String[] stringArray = this.getImage().getRepoTags();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = repoTags = stringArray;
        boolean bl = false;
        String[] stringArray3 = stringArray2;
        int n = 0;
        if (!(stringArray3.length == 0)) {
            boolean bl2;
            block4: {
                String[] $this$none$iv = repoTags;
                boolean $i$f$none = false;
                stringArray3 = $this$none$iv;
                n = stringArray3.length;
                for (int j = 0; j < n; ++j) {
                    String element$iv;
                    String it = element$iv = stringArray3[j];
                    boolean bl3 = false;
                    String string2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
                    if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"<none>", (boolean)false, (int)2, null)) continue;
                    bl2 = false;
                    break block4;
                }
                bl2 = true;
            }
            if (bl2) {
                string = DockerAgentApplicationBase.Companion.joinForPresentableName$intellij_clouds_docker_agent_impl(repoTags);
                return string;
            }
        }
        string = DockerUtil.shortedId(this.getImage().getId());
        return string;
    }

    @Override
    @NotNull
    public String getUniqueName() {
        return this.getImageId();
    }

    @Override
    @NotNull
    public String getImageId() {
        String string = this.getImage().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"image.id");
        return string;
    }

    @Override
    @NotNull
    public String[] getImageRepoTags() {
        String[] stringArray = this.getImage().getRepoTags();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @Override
    @NotNull
    protected Object callDockerJavaInspection() throws NotFoundException {
        InspectImageResponse inspectImageResponse = this.getClient().inspectImageCmd(this.getImageId()).exec();
        Intrinsics.checkNotNullExpressionValue((Object)inspectImageResponse, (String)"client.inspectImageCmd(imageId).exec()");
        return inspectImageResponse;
    }

    @Override
    @Nullable
    public OngoingProcess pushImage(@NotNull DockerAgentRepositoryConfig repositoryConfig, @NotNull DockerAgentProgressCallback progressCallback) {
        Intrinsics.checkNotNullParameter((Object)repositoryConfig, (String)"repositoryConfig");
        Intrinsics.checkNotNullParameter((Object)progressCallback, (String)"progressCallback");
        return (OngoingProcess)new ApiTaskBase<OngoingProcess>(this, repositoryConfig, progressCallback, this.getErrorHandler()){
            final /* synthetic */ DockerAgentImageImpl this$0;
            final /* synthetic */ DockerAgentRepositoryConfig $repositoryConfig;
            final /* synthetic */ DockerAgentProgressCallback $progressCallback;

            @NotNull
            protected OngoingProcess doPerform() throws IOException, ApiTaskException {
                String string = this.$repositoryConfig.getQualifiedRepository();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repositoryConfig.qualifiedRepository");
                String repository = string;
                String tag2 = this.$repositoryConfig.getTag();
                if (!this.hasImageTag()) {
                    TagImageCmd tagImageCmd = this.this$0.getClient().tagImageCmd(this.this$0.getImageId(), repository, tag2);
                    tagImageCmd.exec();
                }
                PushImageCmd pushImageCmd = this.this$0.getClient().pushImageCmd(repository);
                DockerAuthConfig customAuthConfig = this.$repositoryConfig.getAuthConfig();
                if (customAuthConfig != null) {
                    pushImageCmd.withAuthConfig((AuthConfig)new AuthConfigEx(customAuthConfig));
                }
                if (tag2 != null) {
                    pushImageCmd.withTag(tag2);
                }
                ResultCallback resultCallback = pushImageCmd.exec((ResultCallback)new PushImageResultCallbackImpl(this.$progressCallback, this.this$0.getLogger(), this.$repositoryConfig.getQualifiedTag()));
                Intrinsics.checkNotNullExpressionValue((Object)resultCallback, (String)"pushImageCmd.exec(PushIm\u2026toryConfig.qualifiedTag))");
                return (OngoingProcess)resultCallback;
            }

            private final boolean hasImageTag() {
                Object[] objectArray = this.this$0.getImageRepoTags();
                String string = this.$repositoryConfig.getQualifiedTag();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repositoryConfig.qualifiedTag");
                return ArraysKt.contains((Object[])objectArray, (Object)string);
            }
            {
                this.this$0 = this$0;
                this.$repositoryConfig = $captured_local_variable$1;
                this.$progressCallback = $captured_local_variable$2;
                super($super_call_param$3);
            }
        }.perform();
    }

    @Override
    public void deleteImage() {
        ApiTasksKt.launchApiTask(this.getErrorHandler(), (Function0)new Function0<Void>(this){
            final /* synthetic */ DockerAgentImageImpl this$0;

            public final Void invoke() {
                return this.this$0.getClient().removeImageCmd(this.this$0.getImageId()).withForce(Boolean.valueOf(true)).exec();
            }
            {
                this.this$0 = dockerAgentImageImpl;
                super(0);
            }
        });
    }

    @Override
    @Nullable
    public DockerSystemInfo loadSystemInfo() {
        return (DockerSystemInfo)ApiTasksKt.launchApiTask(this.getErrorHandler(), (Function0)new Function0<DockerSystemInfo.Impl>(this){
            final /* synthetic */ DockerAgentImageImpl this$0;

            @NotNull
            public final DockerSystemInfo.Impl invoke() {
                InspectImageResponse inspect2;
                InspectImageResponse inspectImageResponse = inspect2 = this.this$0.getClient().inspectImageCmd(this.this$0.getImageId()).exec();
                Intrinsics.checkNotNullExpressionValue((Object)inspectImageResponse, (String)"inspect");
                return new DockerSystemInfo.Impl(inspectImageResponse.getOs(), inspect2.getOsVersion(), inspect2.getArch());
            }
            {
                this.this$0 = dockerAgentImageImpl;
                super(0);
            }
        });
    }

    @Override
    @Nullable
    public String loadImageUser() {
        return (String)ApiTasksKt.launchApiTask(this.getErrorHandler(), (Function0)new Function0<String>(this){
            final /* synthetic */ DockerAgentImageImpl this$0;

            @Nullable
            public final String invoke() {
                InspectImageResponse inspect2 = this.this$0.getClient().inspectImageCmd(this.this$0.getImageId()).exec();
                InspectImageResponse inspectImageResponse = inspect2;
                return inspectImageResponse != null && (inspectImageResponse = inspectImageResponse.getConfig()) != null ? inspectImageResponse.getUser() : null;
            }
            {
                this.this$0 = dockerAgentImageImpl;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public Image getImage() {
        return this.image;
    }

    public DockerAgentImageImpl(@NotNull DockerAgentContext agentContext, @NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)agentContext, (String)"agentContext");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        super(agentContext);
        this.image = image;
    }
}

