/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.applications;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.TopContainerResponse;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.ApiTasksKt;
import com.intellij.docker.agent.ContainerExposedPortsKt;
import com.intellij.docker.agent.ContainerUpdateResultImpl;
import com.intellij.docker.agent.CreateContainerCmdConfig;
import com.intellij.docker.agent.CreateContainerCmdInspection;
import com.intellij.docker.agent.CreateContainerCmdValueTransfers;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.DockerAgentContainerConfigImpl;
import com.intellij.docker.agent.DockerAgentContainerInspectionImpl;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.applications.DockerAgentApplicationBase;
import com.intellij.docker.agent.applications.DockerAgentContainerImpl;
import com.intellij.docker.agent.applications.DockerAgentContainerImpl$captureExecOutput$;
import com.intellij.docker.agent.pipe.DockerAttachPipe;
import com.intellij.docker.agent.pipe.DockerExecPipe;
import com.intellij.docker.agent.pipe.DockerLogPipe;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerAgentContainerInspection;
import com.intellij.docker.agent.terminal.pipe.DockerConsoleLogPipe;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.agent.util.DockerLogUtilsKt;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 P2\u00020\u00012\u00020\u0002:\u0001PB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0014J)\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\u0006\u0010$\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010%J\n\u0010&\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\rH\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\rH\u0016J#\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\u001e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\u0017H\u0002\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u00020+H\u0016J\b\u00102\u001a\u00020+H\u0016J\u001e\u00103\u001a\b\u0012\u0004\u0012\u0002040\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u00105\u001a\u00020\u001eH\u0002J)\u00106\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010%J\b\u00107\u001a\u00020\rH\u0016J\b\u00108\u001a\u00020\rH\u0016J\n\u00109\u001a\u0004\u0018\u00010:H\u0016J\u0012\u0010;\u001a\u00020+2\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J \u0010>\u001a\u00020+2\b\b\u0002\u0010?\u001a\u00020=2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020+0AH\u0002J\b\u0010B\u001a\u00020+H\u0016J\b\u0010C\u001a\u00020+H\u0016J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u0002040\u001b2\u0006\u00105\u001a\u00020\u001eH\u0016J\b\u0010E\u001a\u00020+H\u0016J\b\u0010F\u001a\u00020+H\u0016J\u0012\u0010G\u001a\u00020+2\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J\b\u0010H\u001a\u00020+H\u0016J\u0012\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010K\u001a\u00020LH\u0016J\b\u0010M\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020N2\u0006\u0010<\u001a\u00020=H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006Q"}, d2={"Lcom/intellij/docker/agent/applications/DockerAgentContainerImpl;", "Lcom/intellij/docker/agent/applications/DockerAgentApplicationBase;", "Lcom/intellij/docker/agent/DockerAgentContainer;", "context", "Lcom/intellij/docker/agent/DockerAgentContext;", "container", "Lcom/github/dockerjava/api/model/Container;", "(Lcom/intellij/docker/agent/DockerAgentContext;Lcom/github/dockerjava/api/model/Container;)V", "getContainer", "()Lcom/github/dockerjava/api/model/Container;", "setContainer", "(Lcom/github/dockerjava/api/model/Container;)V", "containerId", "", "getContainerId", "()Ljava/lang/String;", "containerLabels", "", "getContainerLabels", "()Ljava/util/Map;", "containerName", "getContainerName", "containerNames", "", "getContainerNames", "()[Ljava/lang/String;", "attach", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe;", "allowSystemPrint", "", "callDockerJavaInspection", "Lcom/github/dockerjava/api/command/InspectContainerResponse;", "captureExecOutput", "", "command", "includeErr", "([Ljava/lang/String;Z)Ljava/util/concurrent/CompletableFuture;", "computeProcessesJson", "copyArchiveFromContainer", "Ljava/io/InputStream;", "sourceDirPath", "copyArchiveToContainer", "", "remoteDirPath", "localDirPath", "createExec", "withStdIn", "(Z[Ljava/lang/String;)Ljava/lang/String;", "deleteContainer", "deleteContainerWithVolumes", "doShowLog", "Lcom/intellij/docker/agent/terminal/pipe/DockerConsoleLogPipe;", "withTimestamps", "exec", "getPresentableName", "getUniqueName", "inspect", "Lcom/intellij/docker/agent/settings/DockerAgentContainerInspection;", "killContainer", "errorHandler", "Lcom/intellij/remoteServer/agent/util/CloudAgentErrorHandler;", "launchStateChange", "overriddenErrorHandler", "op", "Lkotlin/Function0;", "pauseContainer", "restartContainer", "showLog", "startContainer", "stopContainer", "stopContainerImmediate", "unpauseContainer", "updateContainer", "Lcom/intellij/docker/agent/DockerAgentApplication$ContainerUpdateResult;", "config", "Lcom/intellij/docker/agent/settings/DockerAgentContainerConfig;", "waitForExit", "", "waitForExitImmediate", "Companion", "intellij.clouds.docker.agent.impl"})
public final class DockerAgentContainerImpl
extends DockerAgentApplicationBase
implements DockerAgentContainer {
    @NotNull
    private Container container;
    private static final Companion.ourContainerLastMessageTimestampMap.1 ourContainerLastMessageTimestampMap;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public String getContainerId() {
        String string = this.getContainer().getId();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return DockerAgentApplicationBase.Companion.joinForPresentableName$intellij_clouds_docker_agent_impl(this.getContainer().getNames());
    }

    @Override
    @NotNull
    public String getUniqueName() {
        return this.getContainerId();
    }

    @Override
    @Nullable
    public String getContainerName() {
        Object[] objectArray = this.getContainer().getNames();
        return objectArray != null ? (String)ArraysKt.firstOrNull((Object[])objectArray) : null;
    }

    @Override
    @NotNull
    public Map<String, String> getContainerLabels() {
        Map map2 = this.getContainer().getLabels();
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    @Override
    @NotNull
    public String[] getContainerNames() {
        String[] stringArray = this.getContainer().getNames();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @Override
    public void startContainer() {
        DockerAgentContainerImpl.launchStateChange$default(this, null, (Function0)new Function0<Unit>(this){
            final /* synthetic */ DockerAgentContainerImpl this$0;

            public final void invoke() {
                String id = this.this$0.getContainerId();
                ((Map)DockerAgentContainerImpl.access$getOurContainerLastMessageTimestampMap$cp()).put(id, DockerLogUtilsKt.lastMessageTimestamp(this.this$0.getClient(), id));
                this.this$0.getClient().startContainerCmd(id).exec();
            }
            {
                this.this$0 = dockerAgentContainerImpl;
                super(0);
            }
        }, 1, null);
    }

    @Override
    public void stopContainer() {
        this.stopContainerImmediate(this.getErrorHandler());
    }

    @Override
    public void stopContainerImmediate(@Nullable CloudAgentErrorHandler errorHandler) {
        DockerAgentContainerImpl.launchStateChange$default(this, null, (Function0)new Function0<Unit>(this){
            final /* synthetic */ DockerAgentContainerImpl this$0;

            public final void invoke() {
                this.this$0.getClient().stopContainerCmd(this.this$0.getContainerId()).exec();
            }
            {
                this.this$0 = dockerAgentContainerImpl;
                super(0);
            }
        }, 1, null);
    }

    @Override
    public void pauseContainer() {
        DockerAgentContainerImpl.launchStateChange$default(this, null, (Function0)new Function0<Unit>(this){
            final /* synthetic */ DockerAgentContainerImpl this$0;

            public final void invoke() {
                this.this$0.getClient().pauseContainerCmd(this.this$0.getContainerId()).exec();
            }
            {
                this.this$0 = dockerAgentContainerImpl;
                super(0);
            }
        }, 1, null);
    }

    @Override
    public void unpauseContainer() {
        DockerAgentContainerImpl.launchStateChange$default(this, null, (Function0)new Function0<Unit>(this){
            final /* synthetic */ DockerAgentContainerImpl this$0;

            public final void invoke() {
                this.this$0.getClient().unpauseContainerCmd(this.this$0.getContainerId()).exec();
            }
            {
                this.this$0 = dockerAgentContainerImpl;
                super(0);
            }
        }, 1, null);
    }

    @Override
    public void restartContainer() {
        DockerAgentContainerImpl.launchStateChange$default(this, null, (Function0)new Function0<Unit>(this){
            final /* synthetic */ DockerAgentContainerImpl this$0;

            public final void invoke() {
                String id = this.this$0.getContainerId();
                this.this$0.getClient().stopContainerCmd(id).exec();
                ((Map)DockerAgentContainerImpl.access$getOurContainerLastMessageTimestampMap$cp()).put(id, DockerLogUtilsKt.lastMessageTimestamp(this.this$0.getClient(), id));
                this.this$0.getClient().restartContainerCmd(id).exec();
            }
            {
                this.this$0 = dockerAgentContainerImpl;
                super(0);
            }
        }, 1, null);
    }

    @Override
    public void killContainer(@Nullable CloudAgentErrorHandler errorHandler) {
        DockerAgentContainerImpl.launchStateChange$default(this, null, (Function0)new Function0<Unit>(this){
            final /* synthetic */ DockerAgentContainerImpl this$0;

            public final void invoke() {
                this.this$0.getClient().killContainerCmd(this.this$0.getContainerId()).exec();
            }
            {
                this.this$0 = dockerAgentContainerImpl;
                super(0);
            }
        }, 1, null);
    }

    @Override
    public void deleteContainer() {
        ApiTasksKt.launchApiTask(this.getErrorHandler(), (Function0)new Function0<Void>(this){
            final /* synthetic */ DockerAgentContainerImpl this$0;

            public final Void invoke() {
                return this.this$0.getClient().removeContainerCmd(this.this$0.getContainerId()).withForce(Boolean.valueOf(true)).exec();
            }
            {
                this.this$0 = dockerAgentContainerImpl;
                super(0);
            }
        });
    }

    @Override
    public void deleteContainerWithVolumes() {
        ApiTasksKt.launchApiTask(this.getErrorHandler(), (Function0)new Function0<Void>(this){
            final /* synthetic */ DockerAgentContainerImpl this$0;

            public final Void invoke() {
                return this.this$0.getClient().removeContainerCmd(this.this$0.getContainerId()).withForce(Boolean.valueOf(true)).withRemoveVolumes(Boolean.valueOf(true)).exec();
            }
            {
                this.this$0 = dockerAgentContainerImpl;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public CompletableFuture<DockerConsoleLogPipe> showLog(boolean withTimestamps) {
        return ApiTasksKt.promiseApiTask((Function0)new Function0<CompletableFuture<DockerConsoleLogPipe>>(this, withTimestamps){
            final /* synthetic */ DockerAgentContainerImpl this$0;
            final /* synthetic */ boolean $withTimestamps;

            @NotNull
            public final CompletableFuture<DockerConsoleLogPipe> invoke() {
                return DockerAgentContainerImpl.access$doShowLog(this.this$0, this.this$0.getContainerId(), this.$withTimestamps);
            }
            {
                this.this$0 = dockerAgentContainerImpl;
                this.$withTimestamps = bl;
                super(0);
            }
        });
    }

    private final CompletableFuture<DockerConsoleLogPipe> doShowLog(String containerId, boolean withTimestamps) throws IOException, ApiTaskException {
        CompletableFuture<DockerConsoleLogPipe> completableFuture;
        if (!this.getAgent().isConnected()) {
            CompletableFuture<DockerConsoleLogPipe> completableFuture2 = CompletableFuture.failedFuture(new ApiTaskException("Not connected"));
            completableFuture = completableFuture2;
            Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"CompletableFuture.failed\u2026ception(\"Not connected\"))");
        } else {
            completableFuture = new DockerLogPipe((ZonedDateTime)ourContainerLastMessageTimestampMap.get((Object)containerId), this.getContext(), containerId, withTimestamps).invoke();
        }
        return completableFuture;
    }

    @NotNull
    protected InspectContainerResponse callDockerJavaInspection() throws NotFoundException {
        try {
            InspectContainerResponse inspectContainerResponse = this.getClient().inspectContainerCmd(this.getContainerId()).exec();
            Intrinsics.checkNotNullExpressionValue((Object)inspectContainerResponse, (String)"client.inspectContainerCmd(containerId).exec()");
            return inspectContainerResponse;
        }
        catch (NotFoundException e) {
            CharSequence charSequence = e.getMessage();
            boolean bl = false;
            boolean bl2 = false;
            throw charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? (Throwable)new ApiTaskException("Cannot inspect container " + DockerUtil.shortedId(this.getContainerId()) + " - not found") : (Throwable)e;
        }
    }

    @Override
    @Nullable
    public InputStream copyArchiveFromContainer(@NotNull String sourceDirPath) {
        Intrinsics.checkNotNullParameter((Object)sourceDirPath, (String)"sourceDirPath");
        return (InputStream)ApiTasksKt.launchApiTask(this.getErrorHandler(), (Function0)new Function0<InputStream>(this, sourceDirPath){
            final /* synthetic */ DockerAgentContainerImpl this$0;
            final /* synthetic */ String $sourceDirPath;

            public final InputStream invoke() {
                return this.this$0.getClient().copyArchiveFromContainerCmd(this.this$0.getContainerId(), this.$sourceDirPath).exec();
            }
            {
                this.this$0 = dockerAgentContainerImpl;
                this.$sourceDirPath = string;
                super(0);
            }
        });
    }

    @Override
    public void copyArchiveToContainer(@NotNull String remoteDirPath, @NotNull String localDirPath) {
        Intrinsics.checkNotNullParameter((Object)remoteDirPath, (String)"remoteDirPath");
        Intrinsics.checkNotNullParameter((Object)localDirPath, (String)"localDirPath");
        ApiTasksKt.launchApiTask(this.getErrorHandler(), (Function0)new Function0<Void>(this, localDirPath, remoteDirPath){
            final /* synthetic */ DockerAgentContainerImpl this$0;
            final /* synthetic */ String $localDirPath;
            final /* synthetic */ String $remoteDirPath;

            public final Void invoke() {
                return this.this$0.getClient().copyArchiveToContainerCmd(this.this$0.getContainerId()).withHostResource(this.$localDirPath).withRemotePath(this.$remoteDirPath).exec();
            }
            {
                this.this$0 = dockerAgentContainerImpl;
                this.$localDirPath = string;
                this.$remoteDirPath = string2;
                super(0);
            }
        });
    }

    @Override
    public int waitForExit() {
        return this.waitForExitImmediate(this.getErrorHandler());
    }

    @Override
    public int waitForExitImmediate(@NotNull CloudAgentErrorHandler errorHandler) {
        Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
        int UNKNOWN = -1;
        Integer n = (Integer)ApiTasksKt.launchApiTask(errorHandler, (Function0)new Function0<Integer>(this, UNKNOWN){
            final /* synthetic */ DockerAgentContainerImpl this$0;
            final /* synthetic */ int $UNKNOWN;

            public final Integer invoke() {
                Integer n;
                try {
                    n = ((WaitContainerResultCallback)this.this$0.getClient().waitContainerCmd(this.this$0.getContainerId()).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
                }
                catch (NotFoundException e) {
                    n = this.$UNKNOWN;
                }
                return n;
            }
            {
                this.this$0 = dockerAgentContainerImpl;
                this.$UNKNOWN = n;
                super(0);
            }
        });
        return n != null ? n : UNKNOWN;
    }

    @Override
    @Nullable
    public DockerAgentContainerInspection inspect() {
        return (DockerAgentContainerInspection)ApiTasksKt.launchApiTask(this.getErrorHandler(), (Function0)new Function0<DockerAgentContainerInspectionImpl>(this){
            final /* synthetic */ DockerAgentContainerImpl this$0;

            @NotNull
            public final DockerAgentContainerInspectionImpl invoke() {
                InspectContainerResponse inspectResponse = this.this$0.getClient().inspectContainerCmd(this.this$0.getContainerId()).exec();
                CreateContainerCmdInspection inspection = new CreateContainerCmdInspection(inspectResponse);
                CreateContainerCmdConfig cmdConfig = new CreateContainerCmdConfig();
                InspectContainerResponse inspectContainerResponse = inspectResponse;
                Intrinsics.checkNotNullExpressionValue((Object)inspectContainerResponse, (String)"inspectResponse");
                String containerName2 = inspectContainerResponse.getName();
                if (containerName2 != null) {
                    cmdConfig.withName(containerName2);
                }
                CreateContainerCmdValueTransfers.createContainerCmdValueTransfer(inspect.1.INSTANCE).transferFromTo(inspection, (CreateContainerCmd)cmdConfig);
                return new DockerAgentContainerInspectionImpl((CreateContainerCmd)cmdConfig, inspectResponse.getState());
            }
            {
                this.this$0 = dockerAgentContainerImpl;
                super(0);
            }
        });
    }

    @Override
    @Nullable
    public String computeProcessesJson() {
        return (String)ApiTasksKt.launchApiTask(this.getErrorHandler(), (Function0)new Function0<String>(this){
            final /* synthetic */ DockerAgentContainerImpl this$0;

            public final String invoke() {
                TopContainerResponse response = this.this$0.getClient().topContainerCmd(this.this$0.getContainerId()).exec();
                ObjectMapper objectMapper2 = this.this$0.getObjectMapper();
                return objectMapper2.writerWithDefaultPrettyPrinter().writeValueAsString((Object)response);
            }
            {
                this.this$0 = dockerAgentContainerImpl;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public CompletableFuture<DockerTerminalPipe> attach(boolean allowSystemPrint) {
        return ApiTasksKt.promiseApiTask((Function0)new Function0<CompletableFuture<DockerTerminalPipe>>(this, allowSystemPrint){
            final /* synthetic */ DockerAgentContainerImpl this$0;
            final /* synthetic */ boolean $allowSystemPrint;

            @NotNull
            public final CompletableFuture<DockerTerminalPipe> invoke() {
                return new DockerAttachPipe(this.$allowSystemPrint, this.this$0.getContainerId(), this.this$0.getContext()).start();
            }
            {
                this.this$0 = dockerAgentContainerImpl;
                this.$allowSystemPrint = bl;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public CompletableFuture<DockerTerminalPipe> exec(@NotNull String[] command, boolean allowSystemPrint) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return ApiTasksKt.promiseApiTask((Function0)new Function0<CompletableFuture<DockerTerminalPipe>>(this, command, allowSystemPrint){
            final /* synthetic */ DockerAgentContainerImpl this$0;
            final /* synthetic */ String[] $command;
            final /* synthetic */ boolean $allowSystemPrint;

            @NotNull
            public final CompletableFuture<DockerTerminalPipe> invoke() {
                String execId = DockerAgentContainerImpl.access$createExec(this.this$0, true, this.$command);
                return new DockerExecPipe(this.$allowSystemPrint, execId, this.this$0.getContext()).start();
            }
            {
                this.this$0 = dockerAgentContainerImpl;
                this.$command = stringArray;
                this.$allowSystemPrint = bl;
                super(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<byte[]> captureExecOutput(@NotNull String[] command, boolean includeErr) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        String newExecId = this.createExec(false, command);
        CompletableFuture<byte[]> promise = new CompletableFuture<byte[]>();
        try {
            Closeable closeable = (Closeable)this.getClient().execStartCmd(newExecId);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ExecStartCmd execStartCmd = (ExecStartCmd)closeable;
                boolean bl3 = false;
                ByteArrayOutputStream capturedOut = new ByteArrayOutputStream();
                ByteArrayOutputStream capturedErr = includeErr ? capturedOut : new ByteArrayOutputStream();
                captureExecOutput$$inlined$use$lambda$1 var8_10 = execStartCmd.withDetach(Boolean.valueOf(false)).exec((ResultCallback)new ExecStartResultCallback(capturedOut, capturedErr, capturedOut, capturedErr, includeErr, promise){
                    final /* synthetic */ ByteArrayOutputStream $capturedOut;
                    final /* synthetic */ ByteArrayOutputStream $capturedErr;
                    final /* synthetic */ boolean $includeErr$inlined;
                    final /* synthetic */ CompletableFuture $promise$inlined;
                    {
                        this.$capturedOut = $captured_local_variable$1;
                        this.$capturedErr = $captured_local_variable$2;
                        this.$includeErr$inlined = bl;
                        this.$promise$inlined = completableFuture;
                        super($super_call_param$3, $super_call_param$4);
                    }

                    public void onError(@NotNull Throwable throwable) {
                        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                        this.$promise$inlined.completeExceptionally(throwable);
                        super.onError(throwable);
                    }

                    public void onComplete() {
                        if (!this.$promise$inlined.isDone()) {
                            this.$promise$inlined.complete(this.$capturedOut.toByteArray());
                        }
                        super.onComplete();
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (DockerException e) {
            promise.completeExceptionally(e);
        }
        return promise;
    }

    @Override
    @Nullable
    public DockerAgentApplication.ContainerUpdateResult updateContainer(@NotNull DockerAgentContainerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return (DockerAgentApplication.ContainerUpdateResult)ApiTasksKt.launchApiTask(this.getErrorHandler(), (Function0)new Function0<ContainerUpdateResultImpl>(this, config){
            final /* synthetic */ DockerAgentContainerImpl this$0;
            final /* synthetic */ DockerAgentContainerConfig $config;

            @NotNull
            public final ContainerUpdateResultImpl invoke() {
                CreateContainerResponse createContainerResponse;
                InspectContainerResponse inspectResponse = this.this$0.getClient().inspectContainerCmd(this.this$0.getContainerId()).exec();
                ContainerUpdateResultImpl result2 = new ContainerUpdateResultImpl(this.this$0.getImageId());
                String oldContainerId = this.this$0.getContainerId();
                String oldContainerStatus = this.this$0.getContainer().getStatus();
                result2.setRemovedContainerId(oldContainerId);
                this.this$0.getClient().removeContainerCmd(oldContainerId).withForce(Boolean.TRUE).exec();
                CreateContainerCmdInspection inspection = new CreateContainerCmdInspection(inspectResponse);
                CreateContainerCmd createContainerCmd = this.this$0.getClient().createContainerCmd(this.this$0.getImageId());
                InspectContainerResponse inspectContainerResponse = inspectResponse;
                Intrinsics.checkNotNullExpressionValue((Object)inspectContainerResponse, (String)"inspectResponse");
                String containerName2 = inspectContainerResponse.getName();
                if (containerName2 != null) {
                    createContainerCmd.withName(containerName2);
                }
                CreateContainerCmdValueTransfers.createMergeForUpdate(updateContainer.1.INSTANCE).mergeWithPriority(new DockerAgentContainerConfigImpl(this.$config), inspection, createContainerCmd);
                CreateContainerCmd createContainerCmd2 = createContainerCmd;
                Intrinsics.checkNotNullExpressionValue((Object)createContainerCmd2, (String)"createContainerCmd");
                ContainerExposedPortsKt.withAllBoundPortsExposed(createContainerCmd2);
                ContainerExposedPortsKt.withoutUnboundExposedPorts(createContainerCmd);
                CreateContainerResponse createContainerResponse2 = createContainerResponse = createContainerCmd.exec();
                Intrinsics.checkNotNullExpressionValue((Object)createContainerResponse2, (String)"createContainerResponse");
                String containerId = createContainerResponse2.getId();
                DockerAgentContainer newContainer = this.this$0.getAgent().findContainer(createContainerResponse.getId());
                if (newContainer != null) {
                    result2.setNewAgentContainer(newContainer);
                    this.this$0.setContainer(newContainer.getContainer());
                }
                if (!DockerUtil.isStoppedStatus(oldContainerStatus)) {
                    this.this$0.getClient().startContainerCmd(containerId).exec();
                }
                return result2;
            }
            {
                this.this$0 = dockerAgentContainerImpl;
                this.$config = dockerAgentContainerConfig;
                super(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String createExec(boolean withStdIn, String[] command) {
        Closeable closeable = (Closeable)this.getClient().execCreateCmd(this.getContainerId());
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ExecCreateCmd execCreateCmd = (ExecCreateCmd)closeable;
            boolean bl3 = false;
            execCreateCmd.withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(withStdIn)).withTty(Boolean.valueOf(withStdIn)).withCmd(Arrays.copyOf(command, command.length));
            Object object = execCreateCmd.exec();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"execCreateCmd.exec()");
            String string = ((ExecCreateCmdResponse)object).getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"execCreateCmd.exec().id");
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void launchStateChange(CloudAgentErrorHandler overriddenErrorHandler, Function0<Unit> op) {
        ApiTasksKt.launchStateChange(overriddenErrorHandler, op);
    }

    static /* synthetic */ void launchStateChange$default(DockerAgentContainerImpl dockerAgentContainerImpl, CloudAgentErrorHandler cloudAgentErrorHandler, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            cloudAgentErrorHandler = dockerAgentContainerImpl.getErrorHandler();
        }
        dockerAgentContainerImpl.launchStateChange(cloudAgentErrorHandler, (Function0<Unit>)function0);
    }

    @Override
    @NotNull
    public Container getContainer() {
        return this.container;
    }

    public void setContainer(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"<set-?>");
        this.container = container;
    }

    public DockerAgentContainerImpl(@NotNull DockerAgentContext context, @NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        super(context);
        this.container = container;
    }

    static {
        Companion = new Companion(null);
        ourContainerLastMessageTimestampMap = new LinkedHashMap<String, ZonedDateTime>(10, 0.75f, true){

            protected boolean removeEldestEntry(@NotNull Map.Entry<String, ZonedDateTime> eldest) {
                Intrinsics.checkNotNullParameter(eldest, (String)"eldest");
                return this.size() > 10;
            }
        };
    }

    @Override
    @NotNull
    public CompletableFuture<DockerTerminalPipe> attach() {
        return DockerAgentContainer.DefaultImpls.attach(this);
    }

    @Override
    @NotNull
    public CompletableFuture<DockerTerminalPipe> exec(@NotNull String[] command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return DockerAgentContainer.DefaultImpls.exec(this, command);
    }

    @Override
    @NotNull
    public String getImageId() {
        return DockerAgentContainer.DefaultImpls.getImageId(this);
    }

    @Override
    @NotNull
    public String getImageName() {
        return DockerAgentContainer.DefaultImpls.getImageName(this);
    }

    public static final /* synthetic */ Companion.ourContainerLastMessageTimestampMap.1 access$getOurContainerLastMessageTimestampMap$cp() {
        return ourContainerLastMessageTimestampMap;
    }

    public static final /* synthetic */ CompletableFuture access$doShowLog(DockerAgentContainerImpl $this, String containerId, boolean withTimestamps) {
        return $this.doShowLog(containerId, withTimestamps);
    }

    public static final /* synthetic */ String access$createExec(DockerAgentContainerImpl $this, boolean withStdIn, String[] command) {
        return $this.createExec(withStdIn, command);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0013\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/agent/applications/DockerAgentContainerImpl$Companion;", "", "()V", "ourContainerLastMessageTimestampMap", "com/intellij/docker/agent/applications/DockerAgentContainerImpl$Companion$ourContainerLastMessageTimestampMap$1", "Lcom/intellij/docker/agent/applications/DockerAgentContainerImpl$Companion$ourContainerLastMessageTimestampMap$1;", "intellij.clouds.docker.agent.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

