/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.async.ResultCallback;
import com.intellij.docker.agent.util.PipedInputStream;
import com.intellij.docker.agent.util.PipedOutputStream;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import java.io.Closeable;
import java.io.IOException;

public abstract class StreamCallbackBase<T>
implements ResultCallback<T> {
    private final CloudAgentLogger myLogger;
    private final PipedInputStream myInputStream;
    private final PipedOutputStream myReverseOfInputStream;
    private Closeable myChannelCloseable;
    private boolean myChannelCloseRequested;
    private final Object CLOSE_REQUEST_LOCK = new Object();

    public StreamCallbackBase(CloudAgentLogger logger2) throws IOException {
        this.myLogger = logger2;
        this.myInputStream = new PipedInputStream();
        this.myReverseOfInputStream = new PipedOutputStream(this.myInputStream);
    }

    public PipedInputStream getInputStream() {
        return this.myInputStream;
    }

    protected PipedOutputStream getReverseOfInputStream() {
        return this.myReverseOfInputStream;
    }

    public void close() throws IOException {
        this.myReverseOfInputStream.close();
    }

    private void safeClose() {
        try {
            this.close();
        }
        catch (IOException e) {
            this.myLogger.debugEx((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart(Closeable closeable) {
        boolean closeImmediately;
        Object object = this.CLOSE_REQUEST_LOCK;
        synchronized (object) {
            this.myChannelCloseable = closeable;
            closeImmediately = closeable != null && this.myChannelCloseRequested;
        }
        if (closeImmediately) {
            this.requestCloseChannel();
        }
    }

    public void onNext(T packet) {
        try {
            this.onNextWrite(packet);
        }
        catch (IOException e) {
            this.myLogger.debugEx((Exception)e);
        }
    }

    public void onError(Throwable throwable) {
        this.myLogger.debugEx(new Exception(throwable));
        this.safeClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        Object object = this.CLOSE_REQUEST_LOCK;
        synchronized (object) {
            this.myChannelCloseable = null;
            this.myChannelCloseRequested = false;
        }
        this.safeClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestCloseChannel() {
        Object object = this.CLOSE_REQUEST_LOCK;
        synchronized (object) {
            if (this.myChannelCloseable == null) {
                this.myChannelCloseRequested = true;
                return false;
            }
            try {
                this.myChannelCloseable.close();
            }
            catch (IOException e) {
                this.myLogger.debugEx((Exception)e);
            }
            this.myChannelCloseable = null;
            this.myChannelCloseRequested = false;
        }
        try {
            this.myReverseOfInputStream.close();
        }
        catch (IOException e) {
            this.myLogger.debugEx((Exception)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean hasChannelCloseable() {
        Object object = this.CLOSE_REQUEST_LOCK;
        synchronized (object) {
            return this.myChannelCloseable != null;
        }
    }

    protected abstract void onNextWrite(T var1) throws IOException;
}

