/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.intellij.docker.agent.DockerAgentLogProvider;
import com.intellij.docker.agent.terminal.communicator.TerminalCommunicator;
import com.intellij.docker.agent.terminal.pipe.DockerBasePipe;
import com.intellij.docker.agent.util.PipedInputStream;
import com.intellij.docker.agent.util.PipedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public abstract class SimpleTerminalPipe
implements DockerBasePipe<TerminalCommunicator> {
    @NotNull
    protected final DockerAgentLogProvider ourLogProvider;
    private volatile boolean myIsClosed;
    private final MyPipedInputStream myInputStream;
    private final PipedOutputStream myReversedInputStream;
    private final OutputStream myOutputStream;
    private final PipedInputStream myReversedOutputStream;
    private final MyPipedInputStream myStderrStream;
    private final PipedOutputStream myReversedStderrStream;

    public SimpleTerminalPipe(@NotNull String debugId, @NotNull DockerAgentLogProvider logger2) throws IOException {
        if (debugId == null) {
            SimpleTerminalPipe.$$$reportNull$$$0(0);
        }
        if (logger2 == null) {
            SimpleTerminalPipe.$$$reportNull$$$0(1);
        }
        this.ourLogProvider = logger2;
        this.myInputStream = new MyPipedInputStream(debugId + ":writeToT");
        this.myReversedInputStream = new MyPipedOutputStream(this.myInputStream);
        this.myReversedOutputStream = new MyPipedInputStream(":readFromT");
        this.myOutputStream = new MyPipedOutputStream(this.myReversedOutputStream);
        this.myStderrStream = new MyPipedInputStream(":writeErrToT");
        this.myReversedStderrStream = new MyPipedOutputStream(this.myStderrStream);
        this.myIsClosed = false;
    }

    public InputStream getTerminalOutput() {
        return this.myInputStream;
    }

    public OutputStream getTerminalInput() {
        return this.myOutputStream;
    }

    public InputStream getTerminalErrorOutput() {
        return this.myStderrStream;
    }

    public PipedOutputStream getWriteErrToTerminalStream() {
        return this.myReversedStderrStream;
    }

    public PipedOutputStream getWriteToTerminalStream() {
        return this.myReversedInputStream;
    }

    public PipedInputStream getReadFromTerminalStream() {
        return this.myReversedOutputStream;
    }

    @Override
    public void close() {
        this.myIsClosed = true;
        try {
            this.myOutputStream.close();
            this.myReversedInputStream.close();
            this.myReversedStderrStream.close();
        }
        catch (IOException e) {
            this.ourLogProvider.error(e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.myIsClosed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "debugId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "logger";
                break;
            }
        }
        objectArray[1] = "com/intellij/docker/agent/SimpleTerminalPipe";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyPipedOutputStream
    extends PipedOutputStream {
        public MyPipedOutputStream(PipedInputStream snk) throws IOException {
            super(snk);
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            this.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.flush();
        }

        @Override
        public void write(byte @NotNull [] b) throws IOException {
            if (b == null) {
                MyPipedOutputStream.$$$reportNull$$$0(0);
            }
            this.write(b, 0, b.length);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/docker/agent/SimpleTerminalPipe$MyPipedOutputStream", "write"));
        }
    }

    public static class MyPipedInputStream
    extends PipedInputStream {
        private static final String WITHOUT_ID = "<unnamed>";
        private final String myDebugId;

        public MyPipedInputStream() {
            this(WITHOUT_ID);
        }

        public MyPipedInputStream(String debugId) {
            this.myDebugId = debugId;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            try {
                int n = super.read(b, off, len);
                return n;
            }
            catch (IOException e) {
                throw this.appendIdToPipeException(e);
            }
            finally {
                this.notifyAll();
            }
        }

        @NotNull
        private IOException appendIdToPipeException(@NotNull IOException exception) {
            if (exception == null) {
                MyPipedInputStream.$$$reportNull$$$0(0);
            }
            if (WITHOUT_ID.equals(this.myDebugId)) {
                IOException iOException = exception;
                if (iOException == null) {
                    MyPipedInputStream.$$$reportNull$$$0(1);
                }
                return iOException;
            }
            if (exception.getMessage() == null || !exception.getMessage().contains("Pipe")) {
                IOException iOException = exception;
                if (iOException == null) {
                    MyPipedInputStream.$$$reportNull$$$0(2);
                }
                return iOException;
            }
            return new IOException(exception.getMessage() + ", pipe id: `" + this.myDebugId + "`", exception);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exception";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/agent/SimpleTerminalPipe$MyPipedInputStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/agent/SimpleTerminalPipe$MyPipedInputStream";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendIdToPipeException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "appendIdToPipeException";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

