/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.async.ResultCallbackTemplate;
import com.intellij.docker.agent.ApiTaskBase;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.OngoingProcessBase;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public abstract class OngoingProcessResultCallbackBase<RR>
extends ResultCallbackTemplate<OngoingProcessResultCallbackBase<RR>, RR>
implements OngoingProcess {
    private final DockerAgentProgressCallback myAgentCallback;
    private final AtomicBoolean myCallbackNotified;
    @Deprecated
    private final OngoingProcess myOngoingProcessDelegate;
    private final CloudAgentLogger myLogger;
    private volatile String mySuccessMessage;
    private volatile String myErrorMessage;

    public OngoingProcessResultCallbackBase(@NotNull DockerAgentProgressCallback callback, CloudAgentLogger logger2) {
        if (callback == null) {
            OngoingProcessResultCallbackBase.$$$reportNull$$$0(0);
        }
        this.myCallbackNotified = new AtomicBoolean(false);
        this.myAgentCallback = callback;
        this.myOngoingProcessDelegate = new OngoingProcessBase(logger2){

            @Override
            public void cancel() {
                new ApiTaskBase(this.getErrorHandler()){

                    @Override
                    protected Object doPerform() throws IOException {
                        OngoingProcessResultCallbackBase.this.ongoingProcessDelegateCancelled();
                        OngoingProcessResultCallbackBase.this.close();
                        return null;
                    }
                }.perform();
            }

            @Override
            public void await() {
                new ApiTaskBase(this.getErrorHandler()){

                    @Override
                    protected Object doPerform() throws InterruptedException {
                        OngoingProcessResultCallbackBase.this.awaitCompletion();
                        OngoingProcessResultCallbackBase.this.notifyAgentCallback();
                        return null;
                    }
                }.perform();
            }
        };
        this.myLogger = logger2;
    }

    protected final void setSuccessMessage(String successMessage) {
        this.mySuccessMessage = successMessage;
    }

    protected final void setErrorMessage(String errorMessage) {
        this.myErrorMessage = errorMessage;
    }

    public void onError(Throwable throwable) {
        this.setErrorMessage(throwable.toString());
        this.myLogger.debugEx(new Exception(throwable));
        super.onError(throwable);
    }

    @Deprecated
    protected void ongoingProcessDelegateCancelled() {
        this.setSuccessMessage("Operation cancelled");
    }

    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.notifyAgentCallback();
        }
    }

    protected synchronized void notifyAgentCallback() {
        if (!this.myCallbackNotified.compareAndSet(false, true)) {
            return;
        }
        if (this.myErrorMessage != null) {
            this.myAgentCallback.failed(this.myErrorMessage);
        } else {
            this.myAgentCallback.succeeded(this.mySuccessMessage);
        }
    }

    protected final DockerAgentProgressCallback getAgentCallback() {
        return this.myAgentCallback;
    }

    protected final CloudAgentLogger getLogger() {
        return this.myLogger;
    }

    @Override
    public void cancel() {
        this.myOngoingProcessDelegate.cancel();
    }

    @Override
    public void await() {
        this.myOngoingProcessDelegate.await();
    }

    @Override
    public void setErrorHandler(CloudAgentErrorHandler errorHandler) {
        this.myOngoingProcessDelegate.setErrorHandler(errorHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/docker/agent/OngoingProcessResultCallbackBase", "<init>"));
    }
}

