/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import java.lang.reflect.Array;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class DockerUtil {
    private static final Pattern ID_PATTERN = Pattern.compile("[0-9a-f]+");
    private static final int ID_SHORT_LENGTH = 12;
    public static final String ID_PREFIX = "sha256:";

    public static String shortedId(String id) {
        if (id.length() > ID_PREFIX.length() + 12) {
            if (id.startsWith(ID_PREFIX) && ID_PATTERN.matcher(id.substring(ID_PREFIX.length())).matches()) {
                return id.substring(0, 12 + ID_PREFIX.length());
            }
            if (ID_PATTERN.matcher(id).matches()) {
                return id.substring(0, 12);
            }
        }
        return id;
    }

    public static boolean isStartedStatus(String status) {
        return status == null || status.startsWith("Up") && !DockerUtil.isPausedStatus(status);
    }

    public static boolean isPausedStatus(String status) {
        return status != null && status.endsWith("(Paused)");
    }

    public static boolean isStoppedStatus(String status) {
        return status != null && (DockerUtil.isExitedStatus(status) || DockerUtil.isCreatedStatus(status));
    }

    public static boolean isExitedStatus(String status) {
        return status != null && status.startsWith("Exited");
    }

    public static boolean isCreatedStatus(String status) {
        return status != null && status.startsWith("Created");
    }

    public static <Src, Dest> Dest[] mapArray(Src[] input, Class<? extends Dest> destClass, Function<? super Src, ? extends Dest> mapper2) {
        if (input == null) {
            return null;
        }
        return Arrays.stream(input).map(mapper2).filter(Objects::nonNull).toArray(size -> DockerUtil.newArray(destClass, size));
    }

    @NotNull
    public static String formatDuration(long seconds) {
        if (seconds < -1L) {
            return "";
        }
        int DAYS_IN_YEAR = 365;
        int PLURAL_THRESHOLD = 2;
        Duration duration = Duration.ofSeconds(seconds);
        if (duration.toDays() > 730L) {
            String string = duration.toDays() / 365L + " years ago";
            if (string == null) {
                DockerUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (duration.toDays() > 2L) {
            String string = duration.toDays() + " days ago";
            if (string == null) {
                DockerUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (duration.toHours() > 2L) {
            String string = duration.toHours() + " hours ago";
            if (string == null) {
                DockerUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (duration.toMinutes() > 2L) {
            String string = duration.toMinutes() + " minutes ago";
            if (string == null) {
                DockerUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (seconds > 2L) {
            String string = seconds + " seconds ago";
            if (string == null) {
                DockerUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        return "just now";
    }

    private static <T> T[] newArray(Class<? extends T> destClass, int size) {
        return (Object[])Array.newInstance(destClass, size);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/agent/DockerUtil", "formatDuration"));
    }
}

