/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.DeviceRequest;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.InternetProtocol;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Ulimit;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.ValueTransfer;
import com.intellij.docker.agent.cli.CliParserBase;
import com.intellij.docker.agent.cli.DockerRunCliParserBase;
import com.intellij.docker.agent.fix.FixedBindParser;
import com.intellij.docker.agent.settings.DockerDeviceRequest;
import com.intellij.docker.agent.settings.DockerPortSpec;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

public class DockerRunCliParser
extends DockerRunCliParserBase<CreateContainerCmd> {
    public void parse(CreateContainerCmd cmd, String[] optionsLine) throws ApiTaskException {
        try {
            super.doParse(cmd, optionsLine);
        }
        catch (CliParserBase.IllegalOptionException | ParseException e) {
            throw new ApiTaskException((Exception)e);
        }
    }

    @Override
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> hostname(Option option) {
        return new CliParserBase.EachValueHandler<CreateContainerCmd>(option, CreateContainerCmd::withHostName);
    }

    @Override
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> user(Option option) {
        return new CliParserBase.EachValueHandler<CreateContainerCmd>(option, CreateContainerCmd::withUser);
    }

    @Override
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memory(Option option) {
        return new CliParserBase.MemoryOptionHandler<CreateContainerCmd>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withMemory(value));
    }

    @Override
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memorySwap(Option option) {
        return new CliParserBase.MemoryOptionHandler<CreateContainerCmd>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withMemorySwap(value));
    }

    @Override
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memorySwappiness(Option option) {
        return new CliParserBase.MemoryOptionHandler<CreateContainerCmd>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withMemorySwappiness(value));
    }

    @Override
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> shmSize(Option option) {
        return new CliParserBase.MemoryOptionHandler<CreateContainerCmd>(option, (cmd, size) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withShmSize(size));
    }

    @Override
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> kernelMemory(Option option) {
        return new CliParserBase.MemoryOptionHandler<CreateContainerCmd>(option, (cmd, size) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withKernelMemory(size));
    }

    @Override
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memoryReservation(Option option) {
        return new CliParserBase.MemoryOptionHandler<CreateContainerCmd>(option, (cmd, size) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withMemoryReservation(size));
    }

    @Override
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cpusetCpus(Option option) {
        return new CliParserBase.EachValueHandler<CreateContainerCmd>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withCpusetCpus(value));
    }

    @Override
    protected CliParserBase.IntegerOptionHandler<CreateContainerCmd> cpuShares(Option option) {
        return new CliParserBase.IntegerOptionHandler<CreateContainerCmd>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withCpuShares(value));
    }

    @Override
    protected CliParserBase.LongOptionHandler<CreateContainerCmd> cpuPeriod(Option option) {
        return new CliParserBase.LongOptionHandler<CreateContainerCmd>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withCpuPeriod(value));
    }

    @Override
    protected CliParserBase.LongOptionHandler<CreateContainerCmd> cpuQuota(Option option) {
        return new CliParserBase.LongOptionHandler<CreateContainerCmd>(option, (cmd, quota) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withCpuQuota(quota));
    }

    @Override
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cpusetMems(Option option) {
        return new CliParserBase.EachValueHandler<CreateContainerCmd>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withCpusetMems(value));
    }

    @Override
    protected CliParserBase.DoubleOptionHandler<CreateContainerCmd> cpus(Option option) {
        return new CliParserBase.DoubleOptionHandler<CreateContainerCmd>(option, (cmd, ratio) -> {
            double ratioUnboxed = ratio;
            if (ratioUnboxed < 0.0) {
                throw new CliParserBase.IllegalOptionException("'--cpus' value should not be negative");
            }
            int DEFAULT_PERIOD = 100000;
            DockerRunCliParser.findOrCreateHostConfig(cmd).withCpuPeriod(Long.valueOf(100000L)).withCpuQuota(Long.valueOf((int)(ratio * 100000.0)));
        });
    }

    @Override
    protected CliParserBase.IntegerOptionHandler<CreateContainerCmd> blkioWeight(Option option) {
        return new CliParserBase.IntegerOptionHandler<CreateContainerCmd>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withBlkioWeight(value));
    }

    @Override
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> oomKillDisable(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl<CreateContainerCmd>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withOomKillDisable(value));
    }

    @Override
    protected DockerRunCliParserBase.AttachOptionHandler<CreateContainerCmd> attach(Option option) {
        return new DockerRunCliParserBase.AttachOptionHandler<CreateContainerCmd>(option, CreateContainerCmd::withAttachStdin, CreateContainerCmd::withAttachStdout, CreateContainerCmd::withAttachStderr);
    }

    @Override
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> detach(Option option) {
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            @Override
            protected void handleBooleanValue(boolean value) {
                if (value) {
                    ((CreateContainerCmd)this.getCmd()).withAttachStdin(Boolean.FALSE).withAttachStdout(Boolean.FALSE).withAttachStderr(Boolean.FALSE);
                }
            }
        };
    }

    @Override
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> tty(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl<CreateContainerCmd>(option, CreateContainerCmd::withTty);
    }

    @Override
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> interactive(Option option) {
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            @Override
            protected void handleBooleanValue(boolean value) {
                ((CreateContainerCmd)this.getCmd()).withStdinOpen(Boolean.valueOf(value));
                ((CreateContainerCmd)this.getCmd()).withAttachStdin(Boolean.valueOf(value));
            }
        };
    }

    @Override
    protected CliParserBase.ListHandler<CreateContainerCmd> env(Option option) {
        return new CliParserBase.MappedListHandler<CreateContainerCmd, String>(option, String.class, DockerRunCliParser::appendSystemValueIfFound, DockerRunCliParser::appendToCmdEnvironment);
    }

    @Override
    protected DockerRunCliParserBase.EnvFileListHandler envFile(Option option) {
        return new DockerRunCliParserBase.EnvFileListHandler(option){

            @Override
            protected void handleEnvFile(String optionValue, File file2) {
                String[] envVars;
                try {
                    envVars = (String[])Files.lines(file2.toPath()).map(String::trim).filter(text2 -> !text2.isEmpty() && !text2.startsWith("#")).map(x$0 -> DockerRunCliParser.appendSystemValueIfFound(x$0)).toArray(String[]::new);
                }
                catch (IOException e) {
                    throw new CliParserBase.IllegalOptionException("Error reading env-file " + optionValue);
                }
                DockerRunCliParser.appendToCmdEnvironment((CreateContainerCmd)this.getCmd(), envVars);
            }
        };
    }

    private static String appendSystemValueIfFound(String varDeclaration) {
        String localSystemValue;
        if (!((String)varDeclaration).contains("=") && (localSystemValue = System.getProperty((String)varDeclaration)) != null && !localSystemValue.isEmpty()) {
            varDeclaration = (String)varDeclaration + "=" + localSystemValue;
        }
        return varDeclaration;
    }

    private static void appendToCmdEnvironment(CreateContainerCmd cmd, String ... env) {
        new ValueTransfer.CombiningArrayTransfer(String.class, Function.identity(), CreateContainerCmd::getEnv, CreateContainerCmd::withEnv).transferFromTo(env, cmd);
    }

    @Override
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> entrypoint(Option option) {
        return new CliParserBase.EachValueHandler<CreateContainerCmd>(option, (rec$, xva$0) -> ((CreateContainerCmd)rec$).withEntrypoint(new String[]{xva$0}));
    }

    @Override
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> workingDir(Option option) {
        return new CliParserBase.EachValueHandler<CreateContainerCmd>(option, CreateContainerCmd::withWorkingDir);
    }

    @Override
    protected CliParserBase.ListHandler<CreateContainerCmd> expose(Option option) {
        return new ExposeHandler(option);
    }

    @Override
    protected CliParserBase.StringListHandler<CreateContainerCmd> addHost(Option option) {
        return new CliParserBase.StringListHandler<CreateContainerCmd>(option, (cmd, values) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withExtraHosts(values));
    }

    @Override
    protected CliParserBase.LabelListHandler<CreateContainerCmd> label(Option option) {
        return new CliParserBase.LabelListHandlerImpl<CreateContainerCmd>(option, CreateContainerCmd::getLabels, CreateContainerCmd::withLabels);
    }

    @Override
    protected CliParserBase.ListHandler<CreateContainerCmd> securityOpt(Option option) {
        return new CliParserBase.StringListHandler<CreateContainerCmd>(option, (cmd, values) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withSecurityOpts(new ArrayList<String>(Arrays.asList(values))));
    }

    @Override
    protected CliParserBase.ListHandler<CreateContainerCmd> volume(Option option) {
        return new CliParserBase.ListHandler<CreateContainerCmd>(option){

            @Override
            protected void handleValueList(String[] values) {
                ArrayList<Volume> volumes = new ArrayList<Volume>();
                ArrayList<Bind> binds = new ArrayList<Bind>();
                for (String value : values) {
                    if (!value.contains(":")) {
                        volumes.add(new Volume(value));
                        continue;
                    }
                    binds.add(FixedBindParser.parse(value));
                }
                if (!volumes.isEmpty()) {
                    ((CreateContainerCmd)this.getCmd()).withVolumes(volumes);
                }
                if (!binds.isEmpty()) {
                    DockerRunCliParser.findOrCreateHostConfig((CreateContainerCmd)this.getCmd()).withBinds(binds);
                }
            }
        };
    }

    @Override
    protected DockerRunCliParserBase.LinkOptionHandler<CreateContainerCmd, ?> link(Option option) {
        return new DockerRunCliParserBase.LinkOptionHandler<CreateContainerCmd, Link>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withLinks(value)){

            @Override
            protected Link createLink(String name, String alias) {
                return new Link(name, alias);
            }
        };
    }

    @Override
    protected CliParserBase.ListHandler<CreateContainerCmd> lxcConf(Option option) {
        return new CliParserBase.MappedListHandler<CreateContainerCmd, LxcConf>(option, LxcConf.class, source -> {
            String[] parts = source.split("=", 2);
            if (parts.length == 2) {
                return new LxcConf(parts[0].trim(), parts[1].trim());
            }
            throw new CliParserBase.IllegalOptionException(option, (String)source);
        }, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withLxcConf(value));
    }

    @Override
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> logDriver(Option option) {
        return new CliParserBase.SingleValueHandler<CreateContainerCmd>(option){

            @Override
            protected void handleEachValue(String value) {
                for (LogConfig.LoggingType loggingType : LogConfig.LoggingType.values()) {
                    if (!loggingType.getType().equals(value)) continue;
                    DockerRunCliParser.getOrCreateLogConfig((CreateContainerCmd)this.getCmd()).setType(loggingType);
                    return;
                }
                throw new CliParserBase.IllegalOptionException(this.getOption(), value);
            }
        };
    }

    @Override
    protected CliParserBase.ListHandler<CreateContainerCmd> logOpt(Option option) {
        return new CliParserBase.ListHandler<CreateContainerCmd>(option){

            @Override
            protected void handleValueList(String[] values) {
                for (String value : values) {
                    String[] parts;
                    LogConfig logConfig = DockerRunCliParser.getOrCreateLogConfig((CreateContainerCmd)this.getCmd());
                    HashMap<String, String> logOptions = logConfig.getConfig();
                    if (logOptions == null) {
                        logOptions = new HashMap<String, String>();
                        logConfig.setConfig(logOptions);
                    }
                    if ((parts = value.split("=", 2)).length != 2) {
                        throw new CliParserBase.IllegalOptionException(this.getOption(), value);
                    }
                    logOptions.put(parts[0].trim(), parts[1].trim());
                }
            }
        };
    }

    @Override
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> macAddress(Option option) {
        return new CliParserBase.EachValueHandler<CreateContainerCmd>(option, CreateContainerCmd::withMacAddress);
    }

    @Override
    protected DockerRunCliParserBase.PortBindingOptionHandler<CreateContainerCmd> publish(Option option) {
        return new DockerRunCliParserBase.PortBindingOptionHandler<CreateContainerCmd>(option, (cmd, specs) -> {
            Ports ports = new Ports();
            for (DockerPortSpec nextSpec : specs) {
                Map<ExposedPort, Ports.Binding> bindings = nextSpec.toNativeMap(ExposeHandler.newExposedPort, Ports.Binding::new);
                bindings.forEach((port, binding) -> ports.bind(port, binding));
            }
            DockerRunCliParser.findOrCreateHostConfig(cmd).withPortBindings(ports);
        });
    }

    @Override
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> publishAll(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl<CreateContainerCmd>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withPublishAllPorts(value));
    }

    @Override
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> privileged(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl<CreateContainerCmd>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withPrivileged(value));
    }

    @Override
    protected CliParserBase.StringListHandler<CreateContainerCmd> dns(Option option) {
        return new CliParserBase.StringListHandler<CreateContainerCmd>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withDns(value));
    }

    @Override
    protected CliParserBase.StringListHandler<CreateContainerCmd> dnsSearch(Option option) {
        return new CliParserBase.StringListHandler<CreateContainerCmd>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withDnsSearch(value));
    }

    @Override
    protected CliParserBase.MappedListHandler<CreateContainerCmd, ?> volumesFrom(Option option) {
        return new CliParserBase.MappedListHandler<CreateContainerCmd, VolumesFrom>(option, VolumesFrom.class, VolumesFrom::parse, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withVolumesFrom(value));
    }

    @Override
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cidfile(Option option) {
        return new CliParserBase.EachValueHandler<CreateContainerCmd>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withContainerIDFile(value));
    }

    protected CliParserBase.MappedListHandler<CreateContainerCmd, Capability> capAdd(Option option) {
        return new CliParserBase.MappedListHandler<CreateContainerCmd, Capability>(option, Capability.class, Capability::valueOf, (cmd, cap) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withCapAdd(cap));
    }

    protected CliParserBase.MappedListHandler<CreateContainerCmd, ?> capDrop(Option option) {
        return new CliParserBase.MappedListHandler<CreateContainerCmd, Capability>(option, Capability.class, Capability::valueOf, (cmd, cap) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withCapDrop(cap));
    }

    @Override
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> restart(Option option) {
        return new CliParserBase.EachValueHandler<CreateContainerCmd>(option, (cmd, restart) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withRestartPolicy(RestartPolicy.parse((String)restart)));
    }

    @Override
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> network(Option option) {
        return new CliParserBase.SingleValueHandler<CreateContainerCmd>(option){

            @Override
            protected void handleEachValue(String value) {
                if ("none".equalsIgnoreCase(value)) {
                    ((CreateContainerCmd)this.getCmd()).withNetworkDisabled(Boolean.TRUE);
                } else {
                    DockerRunCliParser.findOrCreateHostConfig((CreateContainerCmd)this.getCmd()).withNetworkMode(value);
                }
            }
        };
    }

    @Override
    protected CliParserBase.ListHandler<CreateContainerCmd> networkAlias(Option option) {
        return new CliParserBase.StringListHandler<CreateContainerCmd>(option, CreateContainerCmd::withAliases);
    }

    @Override
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> ip(Option option) {
        return new CliParserBase.EachValueHandler<CreateContainerCmd>(option, CreateContainerCmd::withIpv4Address);
    }

    @Override
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> ip6(Option option) {
        return new CliParserBase.EachValueHandler<CreateContainerCmd>(option, CreateContainerCmd::withIpv6Address);
    }

    protected CliParserBase.MappedListHandler<CreateContainerCmd, Device> device(Option option) {
        return new CliParserBase.MappedListHandler<CreateContainerCmd, Device>(option, Device.class, Device::parse, (cmd, devices) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withDevices(devices));
    }

    @Override
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> runtime(Option option) {
        return new CliParserBase.EachValueHandler<CreateContainerCmd>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withRuntime(value));
    }

    @Override
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> rm(Option option) {
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            @Override
            protected void handleBooleanValue(boolean value) {
                DockerRunCliParser.findOrCreateHostConfig((CreateContainerCmd)this.getCmd()).withAutoRemove(Boolean.valueOf(value));
            }
        };
    }

    @Override
    protected DockerRunCliParserBase.IPCOptionHandler<CreateContainerCmd> ipc(Option option) {
        return new DockerRunCliParserBase.IPCOptionHandler<CreateContainerCmd>(option, (cmd, ipcMode) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withIpcMode(ipcMode));
    }

    @Override
    protected DockerRunCliParserBase.UlimitOptionHandler<CreateContainerCmd> ulimit(Option option) {
        return new DockerRunCliParserBase.UlimitOptionHandler<CreateContainerCmd>(option){

            private Ulimit toApiLimit(DockerRunCliParserBase.UlimitOptionHandler.CliUlimit limit) {
                return new Ulimit(limit.getName(), limit.getSoft(), limit.getHard());
            }

            @Override
            protected void handleUlimits(@NotNull List<DockerRunCliParserBase.UlimitOptionHandler.CliUlimit> limits) {
                if (limits == null) {
                    10.$$$reportNull$$$0(0);
                }
                List apiLimits = limits.stream().map(this::toApiLimit).collect(Collectors.toList());
                DockerRunCliParser.findOrCreateHostConfig((CreateContainerCmd)this.getCmd()).withUlimits(apiLimits);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "limits", "com/intellij/docker/agent/DockerRunCliParser$10", "handleUlimits"));
            }
        };
    }

    @Override
    protected CliParserBase.StringListHandler<CreateContainerCmd> groupAdd(Option option) {
        return new CliParserBase.StringListHandler<CreateContainerCmd>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withGroupAdd(Arrays.asList(value)));
    }

    @Override
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cgroupParent(Option option) {
        return new CliParserBase.EachValueHandler<CreateContainerCmd>(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withCgroupParent(value));
    }

    @Override
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> sysctl(Option option) {
        return new CliParserBase.EachValueHandler<CreateContainerCmd>(option, (cmd, keyValuePair) -> {
            if (keyValuePair == null || keyValuePair.isEmpty()) {
                throw new CliParserBase.IllegalOptionException(option, (String)keyValuePair);
            }
            String[] parts = keyValuePair.split("=", 2);
            if (parts.length != 2) {
                throw new CliParserBase.IllegalOptionException(option, (String)keyValuePair);
            }
            HostConfig hostConfig = DockerRunCliParser.findOrCreateHostConfig(cmd);
            HashMap<String, String> allSysctls = hostConfig.getSysctls();
            if (allSysctls == null) {
                allSysctls = new HashMap<String, String>();
                hostConfig.withSysctls(allSysctls);
            }
            allSysctls.put(parts[0], parts[1]);
        });
    }

    @Override
    protected DockerRunCliParserBase.GpuDeviceRequestHandler<CreateContainerCmd> gpus(Option option) {
        return new DockerRunCliParserBase.GpuDeviceRequestHandler<CreateContainerCmd>(option){

            @Override
            protected void handleDeviceRequest(String value, DockerDeviceRequest dto) {
                HostConfig hostConfig = DockerRunCliParser.findOrCreateHostConfig((CreateContainerCmd)this.getCmd());
                if (hostConfig.getDeviceRequests() == null) {
                    hostConfig.withDeviceRequests(new ArrayList());
                }
                hostConfig.getDeviceRequests().add(new DeviceRequest().withDriver(dto.getDriver()).withCount(Integer.valueOf(dto.getCount())).withCapabilities(dto.getCapabilities()).withOptions(dto.getOptions()).withDeviceIds(dto.getDeviceIds()));
            }
        };
    }

    @Override
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> init(Option option) {
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            @Override
            protected void handleBooleanValue(boolean value) {
                DockerRunCliParser.findOrCreateHostConfig((CreateContainerCmd)this.getCmd()).withInit(Boolean.valueOf(true));
            }
        };
    }

    private static LogConfig getOrCreateLogConfig(CreateContainerCmd cmd) {
        HostConfig hostConfig = DockerRunCliParser.findOrCreateHostConfig(cmd);
        LogConfig result2 = hostConfig.getLogConfig();
        if (result2 == null) {
            result2 = new LogConfig();
            hostConfig.withLogConfig(result2);
        }
        return result2;
    }

    @NotNull
    private static HostConfig findOrCreateHostConfig(CreateContainerCmd cmd) {
        HostConfig result2 = cmd.getHostConfig();
        if (result2 == null) {
            result2 = new HostConfig();
            cmd.withHostConfig(result2);
        }
        HostConfig hostConfig = result2;
        if (hostConfig == null) {
            DockerRunCliParser.$$$reportNull$$$0(0);
        }
        return hostConfig;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/agent/DockerRunCliParser", "findOrCreateHostConfig"));
    }

    private static class ExposeHandler
    extends CliParserBase.MappedListHandler<CreateContainerCmd, ExposedPort[]> {
        static final BiFunction<String, Integer, ExposedPort> newExposedPort = (protocol, port) -> new ExposedPort(port.intValue(), InternetProtocol.valueOf((String)protocol.toUpperCase(Locale.ENGLISH)));

        ExposeHandler(Option option) {
            super(option, ExposedPort[].class, text2 -> ExposeHandler.parseFromString(option, text2), ExposeHandler::applyToCmd);
        }

        private static ExposedPort[] parseFromString(Option option, String text2) {
            try {
                return DockerPortSpec.ContainerPortsSpec.fromString(text2).toNativeList(newExposedPort).toArray(new ExposedPort[0]);
            }
            catch (IllegalArgumentException e) {
                throw new CliParserBase.IllegalOptionException(option, text2);
            }
        }

        private static void applyToCmd(CreateContainerCmd cmd, ExposedPort[][] parsedArray) {
            ExposedPort[] flattenedPorts = (ExposedPort[])Stream.of(parsedArray).flatMap(Stream::of).toArray(ExposedPort[]::new);
            cmd.withExposedPorts(flattenedPorts);
        }
    }
}

