/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.core.LocalDirectorySSLConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.core.util.CertificateUtils;
import com.github.dockerjava.okhttp.OkDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.DockerAgentConfig;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import java.io.IOException;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/DockerClientExtImpl;", "Lcom/intellij/docker/agent/DockerAgentContext$DockerClientExt;", "config", "Lcom/github/dockerjava/core/DockerClientConfig;", "httpClient", "Lcom/github/dockerjava/transport/DockerHttpClient;", "(Lcom/github/dockerjava/core/DockerClientConfig;Lcom/github/dockerjava/transport/DockerHttpClient;)V", "myDockerClient", "Lcom/github/dockerjava/api/DockerClient;", "myObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "close", "", "getDockerClient", "getObjectMapper", "Companion", "intellij.clouds.docker.agent.impl"})
public final class DockerClientExtImpl
implements DockerAgentContext.DockerClientExt {
    private final ObjectMapper myObjectMapper;
    private final DockerClient myDockerClient;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper2 = this.myObjectMapper.copy();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"myObjectMapper.copy()");
        return objectMapper2;
    }

    @Override
    @NotNull
    public DockerClient getDockerClient() {
        return this.myDockerClient;
    }

    @Override
    public void close() throws IOException {
        this.myDockerClient.close();
    }

    public DockerClientExtImpl(@NotNull DockerClientConfig config, @Nullable DockerHttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ObjectMapper objectMapper2 = config.getObjectMapper().copy();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"config.objectMapper.copy()");
        this.myObjectMapper = objectMapper2;
        DockerHttpClient dockerHttpClient = httpClient;
        if (dockerHttpClient == null) {
            dockerHttpClient = DockerClientExtImpl.Companion.createDefaultHttpClient(config);
        }
        DockerHttpClient safeHttpClient = dockerHttpClient;
        DockerClient dockerClient = DockerClientImpl.getInstance((DockerClientConfig)config, (DockerHttpClient)safeHttpClient);
        Intrinsics.checkNotNullExpressionValue((Object)dockerClient, (String)"DockerClientImpl.getInst\u2026e(config, safeHttpClient)");
        this.myDockerClient = dockerClient;
    }

    @JvmStatic
    private static final DockerHttpClient createDefaultHttpClient(DockerClientConfig $this$createDefaultHttpClient) {
        return DockerClientExtImpl.Companion.createDefaultHttpClient($this$createDefaultHttpClient);
    }

    @JvmStatic
    @NotNull
    public static final DefaultDockerClientConfig buildClientConfig(@NotNull DockerAgentConfig $this$buildClientConfig, @NotNull RemoteApiVersion remoteApiVersion) throws ApiTaskException {
        return Companion.buildClientConfig($this$buildClientConfig, remoteApiVersion);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0003J\f\u0010\u000b\u001a\u00020\f*\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/agent/DockerClientExtImpl$Companion;", "", "()V", "buildClientConfig", "Lcom/github/dockerjava/core/DefaultDockerClientConfig;", "Lcom/intellij/docker/agent/DockerAgentConfig;", "remoteApiVersion", "Lcom/github/dockerjava/core/RemoteApiVersion;", "createDefaultHttpClient", "Lcom/github/dockerjava/transport/DockerHttpClient;", "Lcom/github/dockerjava/core/DockerClientConfig;", "validateConfig", "", "intellij.clouds.docker.agent.impl"})
    public static final class Companion {
        @JvmStatic
        private final DockerHttpClient createDefaultHttpClient(DockerClientConfig $this$createDefaultHttpClient) {
            OkDockerHttpClient okDockerHttpClient = new OkDockerHttpClient.Builder().dockerHost($this$createDefaultHttpClient.getDockerHost()).sslConfig((com.github.dockerjava.transport.SSLConfig)$this$createDefaultHttpClient.getSSLConfig()).build();
            Intrinsics.checkNotNullExpressionValue((Object)okDockerHttpClient, (String)"OkDockerHttpClient.Build\u2026lConfig)\n        .build()");
            return (DockerHttpClient)okDockerHttpClient;
        }

        @JvmStatic
        @NotNull
        public final DefaultDockerClientConfig buildClientConfig(@NotNull DockerAgentConfig $this$buildClientConfig, @NotNull RemoteApiVersion remoteApiVersion) throws ApiTaskException {
            DefaultDockerClientConfig.Builder builder;
            Intrinsics.checkNotNullParameter((Object)$this$buildClientConfig, (String)"$this$buildClientConfig");
            Intrinsics.checkNotNullParameter((Object)remoteApiVersion, (String)"remoteApiVersion");
            try {
                DefaultDockerClientConfig.Builder builder2 = DefaultDockerClientConfig.createDefaultConfigBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"DefaultDockerClientConfi\u2026ateDefaultConfigBuilder()");
                builder = builder2;
            }
            catch (NullPointerException e) {
                builder = new DefaultDockerClientConfig.Builder();
            }
            catch (IllegalArgumentException e) {
                builder = new DefaultDockerClientConfig.Builder();
            }
            DefaultDockerClientConfig.Builder builder3 = builder;
            builder = builder3.withDockerHost(DockerAgentConfig.Companion.getDockerHost($this$buildClientConfig)).withDockerTlsVerify(Boolean.valueOf(DockerAgentConfig.Companion.isTlsVerifyEnabled($this$buildClientConfig))).withDockerCertPath($this$buildClientConfig.getCertificatesPath()).withApiVersion(remoteApiVersion).build();
            boolean bl = false;
            boolean bl2 = false;
            DefaultDockerClientConfig.Builder it = builder;
            boolean bl3 = false;
            DefaultDockerClientConfig.Builder builder4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"it");
            Companion.validateConfig((DockerClientConfig)builder4);
            DefaultDockerClientConfig.Builder builder5 = builder;
            Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"builder\n        .withDoc\u2026alidateConfig()\n        }");
            return builder5;
        }

        private final void validateConfig(DockerClientConfig $this$validateConfig) throws ApiTaskException {
            URI uRI = $this$validateConfig.getDockerHost();
            if (uRI == null) {
                throw (Throwable)new ApiTaskException(DockerAgentBundle.Companion.message("DockerAgentImpl.docker.host.is.not.specified", new Object[0]));
            }
            URI targetUri = uRI;
            if (Intrinsics.areEqual((Object)"tcp", (Object)targetUri.getScheme()) && $this$validateConfig.getSSLConfig() instanceof LocalDirectorySSLConfig) {
                SSLConfig sSLConfig = $this$validateConfig.getSSLConfig();
                if (sSLConfig == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.github.dockerjava.core.LocalDirectorySSLConfig");
                }
                LocalDirectorySSLConfig sslConfigImpl = (LocalDirectorySSLConfig)sSLConfig;
                String string = sslConfigImpl.getDockerCertPath();
                if (string == null) {
                    throw (Throwable)new ApiTaskException(DockerAgentBundle.Companion.message("DockerAgentImpl.certificates.path.is.not.specified", new Object[0]));
                }
                String certificatesPath = string;
                if (!CertificateUtils.verifyCertificatesExist((String)certificatesPath)) {
                    throw (Throwable)new ApiTaskException(DockerAgentBundle.Companion.message("DockerAgentImpl.cant.locate.certificate.files", certificatesPath));
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

