/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.async.ResultCallbackTemplate;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthResponse;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Event;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.transport.DockerHttpClient;
import com.intellij.docker.agent.ApiTaskBase;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.AuthConfigEx;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentConfig;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentDeployment;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentImageBuilderImpl;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.DockerClientExtImpl;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.PullImageResultCallbackImpl;
import com.intellij.docker.agent.applications.DockerAgentContainerImpl;
import com.intellij.docker.agent.applications.DockerAgentDeploymentImpl;
import com.intellij.docker.agent.auth.DockerClientConfigWithCustomAuth;
import com.intellij.docker.agent.cli.communicator.DockerCliFacade;
import com.intellij.docker.agent.event.DockerEventImpl;
import com.intellij.docker.agent.events.DockerEvent;
import com.intellij.docker.agent.fix.DockerClientConfigWithFixedObjectMapper;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import com.intellij.docker.agent.progress.PromisingSerializedItemsCallback;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.nio.file.FileSystemException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerAgentImpl
implements DockerAgent {
    private static final String HTTPS_ERROR_MESSAGE = "https protocol is not supported";
    private static final String REGISTRY_AUTH_SUCCESS = "Login Succeeded";
    private static final String HTTPS_ERROR_MESSAGE_HINT = "<br/>Please check if path to certificates folder is specified and correct.<br/>Please also note, you don't need to specify path to certificates folder if use unsecured http connection on Linux.";
    private DockerAgentContext.DockerClientExt myClient;
    private CloudAgentLogger myLogger;
    private DockerCliFacade myCliFacade;
    protected CloudAgentErrorHandler myErrorHandler;
    private volatile boolean myIsConnected;
    private AgentEventsListener myEventsListener;
    private static final RemoteApiVersion MAX_DOCKER_JAVA_SUPPORTED = RemoteApiVersion.VERSION_1_40;

    public DockerAgentImpl() {
        Logger.getLogger(ResultCallbackTemplate.class).setLevel(Level.OFF);
    }

    @Override
    public void connect(final DockerAgentConfig config, final DockerCliFacade cliFacade, CloudAgentLogger logger2, CloudAgentErrorHandler errorHandler) {
        this.myLogger = logger2;
        this.myErrorHandler = errorHandler;
        this.myCliFacade = cliFacade;
        new ApiTaskBase<Void>(errorHandler){

            @Override
            protected Void doPerform() throws ApiTaskException {
                RemoteApiVersion remoteApiVersion = RemoteApiVersion.VERSION_1_24;
                try (DockerAgentContext.DockerClientExt clientExtWithOldVersion = DockerAgentImpl.buildClient(cliFacade, config, remoteApiVersion);){
                    DockerClient realClient = clientExtWithOldVersion.getDockerClient();
                    realClient.pingCmd().exec();
                    Version actualVersion = (Version)realClient.versionCmd().exec();
                    remoteApiVersion = RemoteApiVersion.parseConfig((String)actualVersion.getApiVersion());
                    if (remoteApiVersion.isGreaterOrEqual(MAX_DOCKER_JAVA_SUPPORTED)) {
                        remoteApiVersion = MAX_DOCKER_JAVA_SUPPORTED;
                    }
                }
                catch (ConnectException e) {
                    DockerAgentImpl.this.myLogger.debugEx((Exception)e);
                    throw this.userFriendlyConnectException();
                }
                catch (UncheckedIOException e) {
                    IOException checked = e.getCause();
                    this.rethrowUserFriendlyIfPossible(checked);
                }
                catch (IOException e) {
                    throw new ApiTaskException(e);
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IOException) {
                        this.rethrowUserFriendlyIfPossible((IOException)cause);
                    }
                    throw e;
                }
                DockerAgentContext.DockerClientExt clientExt = DockerAgentImpl.buildClient(cliFacade, config, remoteApiVersion);
                clientExt.getDockerClient().pingCmd().exec();
                DockerAgentImpl.this.myClient = clientExt;
                DockerAgentImpl.this.myIsConnected = true;
                return null;
            }

            @Override
            protected void onError(String error) {
                if (((String)error).contains(DockerAgentImpl.HTTPS_ERROR_MESSAGE)) {
                    error = (String)error + DockerAgentImpl.HTTPS_ERROR_MESSAGE_HINT;
                }
                super.onError((String)error);
            }

            private void rethrowUserFriendlyIfPossible(Exception ex) throws ApiTaskException {
                String message;
                String string = message = ex.getMessage() != null ? ex.getMessage() : "";
                if (ex instanceof FileNotFoundException || ex instanceof FileSystemException || message.contains("native socket() failed") || message.contains("native connect() failed")) {
                    DockerAgentImpl.this.myLogger.debugEx(ex);
                    throw this.userFriendlyConnectException();
                }
                throw new ApiTaskException(ex);
            }

            private ApiTaskException userFriendlyConnectException() {
                return new ApiTaskException(DockerAgentBundle.message("DockerAgentImpl.cannot.connect.to.the.docker", DockerAgentConfig.getDockerHost(config)));
            }
        }.perform();
    }

    @Override
    public void disconnect() {
        this.myIsConnected = false;
        if (this.myEventsListener != null) {
            this.myEventsListener.close();
            this.myEventsListener = null;
        }
        try {
            this.myClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public final DockerClient getDockerClient() {
        return this.myClient.getDockerClient();
    }

    @Override
    public boolean isConnected() {
        return this.myIsConnected;
    }

    @Override
    public void attachEventListener(@NotNull DockerEvent.Listener listener) {
        if (listener == null) {
            DockerAgentImpl.$$$reportNull$$$0(0);
        }
        assert (this.myEventsListener == null);
        this.myEventsListener = new AgentEventsListener(this.myLogger, listener);
        this.getDockerClient().eventsCmd().exec((ResultCallback)this.myEventsListener);
    }

    @Override
    public DockerCliFacade getCliFacade() {
        return this.myCliFacade;
    }

    @Override
    @Nullable
    public DockerAgentContainer findContainer(final @NotNull String containerId) {
        if (containerId == null) {
            DockerAgentImpl.$$$reportNull$$$0(1);
        }
        return (DockerAgentContainer)new ApiTaskBase<DockerAgentContainer>(this.myErrorHandler){

            @Override
            protected DockerAgentContainer doPerform() {
                List containers = (List)DockerAgentImpl.this.getDockerClient().listContainersCmd().withShowAll(Boolean.TRUE).withIdFilter(Collections.singletonList(containerId)).withLimit(Integer.valueOf(1)).exec();
                return containers.isEmpty() ? null : new DockerAgentContainerImpl(new DockerAgentContextImpl(), (Container)containers.get(0));
            }
        }.perform();
    }

    @Override
    public void removeVolume(final String volumeName) {
        new ApiTaskBase<Void>(this.myErrorHandler){

            @Override
            protected Void doPerform() {
                DockerAgentImpl.this.getDockerClient().removeVolumeCmd(volumeName).exec();
                return null;
            }
        }.perform();
    }

    @Override
    public OngoingProcess pullImage(final DockerAgentRepositoryConfig repositoryConfig, final DockerAgentProgressCallback progressCallback) {
        return (OngoingProcess)new ApiTaskBase<PullImageResultCallbackImpl>(this.myErrorHandler){

            @Override
            protected PullImageResultCallbackImpl doPerform() {
                PullImageCmd pullImageCmd = DockerAgentImpl.this.preparePullImageCmd(repositoryConfig);
                return (PullImageResultCallbackImpl)pullImageCmd.exec((ResultCallback)new PullImageResultCallbackImpl(progressCallback, DockerAgentImpl.this.myLogger));
            }
        }.perform();
    }

    @Override
    @NotNull
    public CompletableFuture<BlockingQueue<byte[]>> asyncPullImage(DockerAgentRepositoryConfig repositoryConfig) {
        CompletableFuture<BlockingQueue<byte[]>> result2 = new CompletableFuture<BlockingQueue<byte[]>>();
        try (PullImageCmd pullImageCmd = this.preparePullImageCmd(repositoryConfig);){
            pullImageCmd.exec(new PromisingSerializedItemsCallback(result2));
        }
        catch (Exception e) {
            result2.completeExceptionally(e);
        }
        CompletableFuture<BlockingQueue<byte[]>> completableFuture = result2;
        if (completableFuture == null) {
            DockerAgentImpl.$$$reportNull$$$0(2);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public DockerAgent.DockerImageBuilder createImageBuilder() {
        return new DockerAgentImageBuilderImpl(this.getDockerClient());
    }

    public PullImageCmd preparePullImageCmd(DockerAgentRepositoryConfig repositoryConfig) {
        String tag2;
        PullImageCmd pullImageCmd = this.getDockerClient().pullImageCmd(repositoryConfig.getQualifiedRepository());
        DockerAuthConfig customAuthConfig = repositoryConfig.getAuthConfig();
        if (customAuthConfig != null) {
            pullImageCmd.withAuthConfig((AuthConfig)new AuthConfigEx(customAuthConfig));
        }
        if ((tag2 = repositoryConfig.getTag()) == null) {
            tag2 = "latest";
        }
        pullImageCmd.withTag(tag2);
        return pullImageCmd;
    }

    @Override
    public void imageRegistryAuth(final DockerAuthConfig authConfig) {
        new ApiTaskBase<Void>(this.myErrorHandler){

            @Override
            protected Void doPerform() throws ApiTaskException {
                AuthResponse authResponse = DockerAgentImpl.this.getDockerClient().authCmd().withAuthConfig((AuthConfig)new AuthConfigEx(authConfig)).exec();
                @NonNls String status = authResponse.getStatus();
                if (!DockerAgentImpl.REGISTRY_AUTH_SUCCESS.equals(status)) {
                    throw new ApiTaskException(status);
                }
                return null;
            }
        }.perform();
    }

    @Override
    public DockerAgentDeployment createDeployment(@NotNull DockerAgentDeploymentConfig config, @NotNull DockerAgentPathMapper pathMapper) {
        if (config == null) {
            DockerAgentImpl.$$$reportNull$$$0(3);
        }
        if (pathMapper == null) {
            DockerAgentImpl.$$$reportNull$$$0(4);
        }
        return new DockerAgentDeploymentImpl(new DockerAgentContextImpl(), config, pathMapper);
    }

    private static DockerAgentContext.DockerClientExt buildClient(@NotNull DockerCliFacade cliFacade, @NotNull DockerAgentConfig connectionConfig, @NotNull RemoteApiVersion remoteApiVersion) throws ApiTaskException {
        if (cliFacade == null) {
            DockerAgentImpl.$$$reportNull$$$0(5);
        }
        if (connectionConfig == null) {
            DockerAgentImpl.$$$reportNull$$$0(6);
        }
        if (remoteApiVersion == null) {
            DockerAgentImpl.$$$reportNull$$$0(7);
        }
        DefaultDockerClientConfig clientConfig = DockerClientExtImpl.buildClientConfig(connectionConfig, remoteApiVersion);
        DockerClientConfigWithCustomAuth withCustomAuth = new DockerClientConfigWithCustomAuth(cliFacade, clientConfig);
        DockerClientConfigWithFixedObjectMapper withFixedVolumes = new DockerClientConfigWithFixedObjectMapper(withCustomAuth);
        @Nullable DockerHttpClient httpClient = (DockerHttpClient)connectionConfig.getCustomHttpClient().invoke();
        return new DockerClientExtImpl(withFixedVolumes, httpClient);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/agent/DockerAgentImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cliFacade";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionConfig";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteApiVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/agent/DockerAgentImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncPullImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "attachEventListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findContainer";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDeployment";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildClient";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AgentEventsListener
    implements ResultCallback<Event> {
        private final CloudAgentLogger myLogger;
        private final DockerEvent.Listener myListener;
        private Closeable myCloseable;

        AgentEventsListener(CloudAgentLogger logger2, DockerEvent.Listener realListener) {
            this.myLogger = logger2;
            this.myListener = realListener;
        }

        public void onStart(Closeable closeable) {
            this.myCloseable = closeable;
        }

        public void onNext(Event event) {
            if (event != null) {
                this.myListener.onDockerEvent(new DockerEventImpl(event));
            }
        }

        public void onComplete() {
        }

        public void onError(Throwable throwable) {
            this.myLogger.debugEx(throwable instanceof Exception ? (Exception)throwable : new Exception(throwable));
        }

        public void close() {
            this.closeNettyChannel();
        }

        void closeNettyChannel() {
            if (this.myCloseable != null) {
                try {
                    this.myCloseable.close();
                }
                catch (IOException e) {
                    this.myLogger.debugEx((Exception)e);
                }
            }
            this.myCloseable = null;
        }
    }

    protected final class DockerAgentContextImpl
    implements DockerAgentContext {
        protected DockerAgentContextImpl() {
        }

        @Override
        @NotNull
        public DockerAgent getAgent() {
            DockerAgentImpl dockerAgentImpl = DockerAgentImpl.this;
            if (dockerAgentImpl == null) {
                DockerAgentContextImpl.$$$reportNull$$$0(0);
            }
            return dockerAgentImpl;
        }

        @Override
        @NotNull
        public DockerAgentContext.DockerClientExt getClientExt() {
            DockerAgentContext.DockerClientExt dockerClientExt = DockerAgentImpl.this.myClient;
            if (dockerClientExt == null) {
                DockerAgentContextImpl.$$$reportNull$$$0(1);
            }
            return dockerClientExt;
        }

        @Override
        @NotNull
        public DockerClient getClient() {
            DockerClient dockerClient = DockerAgentImpl.this.myClient.getDockerClient();
            if (dockerClient == null) {
                DockerAgentContextImpl.$$$reportNull$$$0(2);
            }
            return dockerClient;
        }

        @Override
        @NotNull
        public CloudAgentErrorHandler getErrorHandler() {
            CloudAgentErrorHandler cloudAgentErrorHandler = DockerAgentImpl.this.myErrorHandler;
            if (cloudAgentErrorHandler == null) {
                DockerAgentContextImpl.$$$reportNull$$$0(3);
            }
            return cloudAgentErrorHandler;
        }

        @Override
        @NotNull
        public DockerCliFacade getCliFacade() {
            DockerCliFacade dockerCliFacade = DockerAgentImpl.this.myCliFacade;
            if (dockerCliFacade == null) {
                DockerAgentContextImpl.$$$reportNull$$$0(4);
            }
            return dockerCliFacade;
        }

        @Override
        @NotNull
        public CloudAgentLogger getLogger() {
            CloudAgentLogger cloudAgentLogger = DockerAgentImpl.this.myLogger;
            if (cloudAgentLogger == null) {
                DockerAgentContextImpl.$$$reportNull$$$0(5);
            }
            return cloudAgentLogger;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/docker/agent/DockerAgentImpl$DockerAgentContextImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAgent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClientExt";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClient";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorHandler";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCliFacade";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogger";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

