/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.DockerClient;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentConfig;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.DockerAgentDeployment;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.DockerAgentNetwork;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAgentVolume;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.cli.communicator.DockerCliFacade;
import com.intellij.docker.agent.events.DockerEvent;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DockerAgent {
    public DockerClient getDockerClient();

    public DockerAgentApplication[] getApplications(boolean var1);

    public void connect(DockerAgentConfig var1, DockerCliFacade var2, CloudAgentLogger var3, CloudAgentErrorHandler var4);

    public void disconnect();

    public boolean isConnected();

    public DockerAgentDeployment createDeployment(@NotNull DockerAgentDeploymentConfig var1, @NotNull DockerAgentPathMapper var2);

    public DockerAgentContainer @NotNull [] getContainers();

    @Nullable
    public DockerAgentContainer findContainer(String var1);

    public DockerAgentImage @NotNull [] getImages(String var1, boolean var2);

    default public DockerAgentImage @NotNull [] getImages(String label) {
        DockerAgentImage[] dockerAgentImageArray = this.getImages(label, false);
        if (dockerAgentImageArray == null) {
            DockerAgent.$$$reportNull$$$0(0);
        }
        return dockerAgentImageArray;
    }

    public DockerAgentVolume @NotNull [] getVolumes();

    public DockerAgentNetwork @NotNull [] getNetworks();

    public OngoingProcess pullImage(DockerAgentRepositoryConfig var1, DockerAgentProgressCallback var2);

    @NotNull
    public CompletableFuture<BlockingQueue<byte[]>> asyncPullImage(DockerAgentRepositoryConfig var1);

    @NotNull
    public DockerImageBuilder createImageBuilder();

    public void imageRegistryAuth(DockerAuthConfig var1);

    public void removeVolume(String var1);

    public void attachEventListener(@NotNull DockerEvent.Listener var1);

    public DockerCliFacade getCliFacade();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/agent/DockerAgent", "getImages"));
    }

    public static interface DockerImageBuilder {
        public CompletableFuture<BlockingQueue<byte[]>> asyncBuildImage(@NotNull DockerAgentDeploymentConfig var1);
    }

    public static interface Factory {
        @NotNull
        public DockerAgent createAgent();
    }
}

