/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.intellij.docker.agent.ApiTask;
import com.intellij.docker.agent.ApiTaskBase;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.DockerErrorUtilKt;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a(\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u0004H\u0000\u001a'\u0010\u0005\u001a\u0004\u0018\u0001H\u0002\"\u0004\b\u0000\u0010\u0002*\u00020\u00062\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004H\u0001\u00a2\u0006\u0002\u0010\u0007\u001a\u001a\u0010\b\u001a\u00020\t*\u00020\u00062\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\t0\u0004H\u0000\u00a8\u0006\n"}, d2={"promiseApiTask", "Ljava/util/concurrent/CompletableFuture;", "T", "computation", "Lkotlin/Function0;", "launchApiTask", "Lcom/intellij/remoteServer/agent/util/CloudAgentErrorHandler;", "(Lcom/intellij/remoteServer/agent/util/CloudAgentErrorHandler;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "launchStateChange", "", "intellij.clouds.docker.agent.impl"})
public final class ApiTasksKt {
    @Deprecated(message="ApiTask(Base) was needed for old agent. Use #promiseApiTask instead")
    @Nullable
    public static final <T> T launchApiTask(@NotNull CloudAgentErrorHandler $this$launchApiTask, @NotNull Function0<? extends T> computation) {
        Intrinsics.checkNotNullParameter((Object)$this$launchApiTask, (String)"$this$launchApiTask");
        Intrinsics.checkNotNullParameter(computation, (String)"computation");
        ApiTaskBase task2 = new ApiTaskBase<T>($this$launchApiTask, computation, $this$launchApiTask){
            final /* synthetic */ CloudAgentErrorHandler $this_launchApiTask;
            final /* synthetic */ Function0 $computation;

            protected T doPerform() throws IOException, ApiTaskException {
                return (T)this.$computation.invoke();
            }
            {
                this.$this_launchApiTask = $receiver;
                this.$computation = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
        return task2.perform();
    }

    public static final void launchStateChange(@NotNull CloudAgentErrorHandler $this$launchStateChange, @NotNull Function0<Unit> computation) {
        Intrinsics.checkNotNullParameter((Object)$this$launchStateChange, (String)"$this$launchStateChange");
        Intrinsics.checkNotNullParameter(computation, (String)"computation");
        ApiTasksKt.launchApiTask($this$launchStateChange, (Function0)new Function0<Unit>(computation){
            final /* synthetic */ Function0 $computation;

            public final void invoke() {
                try {
                    this.$computation.invoke();
                }
                catch (NotModifiedException e) {
                    if (e.getMessage() == null) {
                        String safeMessage = "Possibly, container is in the target state already";
                        throw (Throwable)new NotModifiedException(safeMessage, (Throwable)e);
                    }
                    throw (Throwable)e;
                }
            }
            {
                this.$computation = function0;
                super(0);
            }
        });
    }

    @NotNull
    public static final <T> CompletableFuture<T> promiseApiTask(@NotNull Function0<? extends CompletableFuture<T>> computation) {
        Intrinsics.checkNotNullParameter(computation, (String)"computation");
        try {
            return (CompletableFuture)computation.invoke();
        }
        catch (Error e) {
            ApiTask.LOG.log((Priority)Level.ERROR, (Object)e);
            throw (Throwable)e;
        }
        catch (IOException e) {
            ApiTask.LOG.log((Priority)Level.ERROR, (Object)e);
            CompletableFuture completableFuture = CompletableFuture.failedFuture(e);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.failedFuture(e)");
            return completableFuture;
        }
        catch (DockerException ex) {
            CompletableFuture completableFuture;
            ApiTask.LOG.log((Priority)Level.DEBUG, (Object)ex);
            String userFriendlyMessage = DockerErrorUtilKt.extractDockerErrorMessage(ex);
            if (userFriendlyMessage != null) {
                CompletableFuture completableFuture2 = CompletableFuture.failedFuture(new DockerException(userFriendlyMessage, ex.getHttpStatus(), (Throwable)ex));
                completableFuture = completableFuture2;
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"CompletableFuture.failed\u2026sage, ex.httpStatus, ex))");
            } else {
                CompletableFuture completableFuture3 = CompletableFuture.failedFuture(ex);
                completableFuture = completableFuture3;
                Intrinsics.checkNotNullExpressionValue(completableFuture3, (String)"CompletableFuture.failedFuture(ex)");
            }
            return completableFuture;
        }
        catch (Throwable other) {
            ApiTask.LOG.log((Priority)Level.DEBUG, (Object)other);
            CompletableFuture completableFuture = CompletableFuture.failedFuture(other);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.failedFuture(other)");
            return completableFuture;
        }
    }
}

