/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action.networks;

import com.intellij.docker.DockerIcons;
import com.intellij.docker.action.networks.ConnectNetworkDialog;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerNetworkRuntime;
import com.intellij.docker.ui.components.ComboBoxWithAutoCompletion;
import com.intellij.docker.ui.components.LookupElement;
import com.intellij.docker.ui.fragmented.dialog.ComponentWithFlag;
import com.intellij.docker.ui.fragmented.dialog.FragmentedDialog;
import com.intellij.docker.ui.fragmented.dialog.FragmentedDialogCommandlineBuilder;
import com.intellij.docker.ui.fragmented.dialog.FragmentedDialogOptionsBuilderImpl;
import com.intellij.docker.ui.fragmented.dialog.FragmentedDialogStaticOptionBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CollectionComboBoxModel;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00100\u00100\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\r\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lcom/intellij/docker/action/networks/ConnectNetworkDialog;", "", "project", "Lcom/intellij/openapi/project/Project;", "runtime", "Lcom/intellij/docker/runtimes/DockerNetworkRuntime;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/docker/runtimes/DockerNetworkRuntime;)V", "dialog", "Lcom/intellij/docker/ui/fragmented/dialog/FragmentedDialog$Default;", "Lcom/intellij/docker/action/networks/ConnectNetworkDialog$Settings;", "getDialog", "()Lcom/intellij/docker/ui/fragmented/dialog/FragmentedDialog$Default;", "dialog$delegate", "Lkotlin/Lazy;", "myContainerNames", "", "", "myContainers", "", "Lcom/intellij/docker/agent/DockerAgentContainer;", "kotlin.jvm.PlatformType", "myContainersComboBox", "Lcom/intellij/docker/ui/components/ComboBoxWithAutoCompletion;", "getMyContainersComboBox", "()Lcom/intellij/docker/ui/components/ComboBoxWithAutoCompletion;", "myContainersComboBox$delegate", "Companion", "Settings", "intellij.clouds.docker"})
public final class ConnectNetworkDialog {
    private final Map<String, DockerAgentContainer> myContainers;
    private final List<String> myContainerNames;
    private final Lazy myContainersComboBox$delegate;
    @NotNull
    private final Lazy dialog$delegate;
    @NlsSafe
    private static final String CONNECT_COMMAND = "docker network connect";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final ComboBoxWithAutoCompletion<String> getMyContainersComboBox() {
        Lazy lazy = this.myContainersComboBox$delegate;
        ConnectNetworkDialog connectNetworkDialog = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ComboBoxWithAutoCompletion)((Object)lazy.getValue());
    }

    @NotNull
    public final FragmentedDialog.Default<Settings> getDialog() {
        Lazy lazy = this.dialog$delegate;
        ConnectNetworkDialog connectNetworkDialog = this;
        Object var3_3 = null;
        boolean bl = false;
        return (FragmentedDialog.Default)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public ConnectNetworkDialog(@NotNull Project project, @NotNull DockerNetworkRuntime runtime) {
        Map map2;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)runtime), (String)"runtime");
        DockerAgentContainer[] dockerAgentContainerArray = runtime.getContext().getAgent().getContainers();
        Intrinsics.checkNotNullExpressionValue((Object)dockerAgentContainerArray, (String)"runtime.context.agent.containers");
        DockerAgentContainer[] dockerAgentContainerArray2 = dockerAgentContainerArray;
        ConnectNetworkDialog connectNetworkDialog = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((void)$this$associateBy$iv).length), (int)16);
        void var6_7 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        void var9_10 = $this$associateByTo$iv$iv;
        int n = ((void)var9_10).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void element$iv$iv;
            void var13_14 = element$iv$iv = var9_10[j];
            map2 = destination$iv$iv;
            boolean bl = false;
            String string = it.getContainerName();
            String string2 = string != null ? StringsKt.drop((String)string, (int)1) : null;
            map2.put(string2, element$iv$iv);
        }
        connectNetworkDialog.myContainers = map2 = destination$iv$iv;
        this.myContainerNames = CollectionsKt.filterNotNull((Iterable)this.myContainers.keySet());
        this.myContainersComboBox$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ComboBoxWithAutoCompletion<String>>(this, project){
            final /* synthetic */ ConnectNetworkDialog this$0;
            final /* synthetic */ Project $project;

            @NotNull
            public final ComboBoxWithAutoCompletion<String> invoke() {
                Comparable comparable;
                ComboBoxWithAutoCompletion<String> comboBoxWithAutoCompletion = new ComboBoxWithAutoCompletion<String>(new CollectionComboBoxModel(ConnectNetworkDialog.access$getMyContainerNames$p(this.this$0)), this.$project, DockerBundle.message("ConnectNetworkDialog.specify.container", new Object[0]), (Function1)new Function1<String, LookupElement>(this){
                    final /* synthetic */ myContainersComboBox.2 this$0;

                    @NotNull
                    public final LookupElement invoke(String it) {
                        String string = it;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                        return new LookupElement(string, com.intellij.docker.action.networks.ConnectNetworkDialog$Companion.access$computeIcon(ConnectNetworkDialog.Companion, (DockerAgentContainer)ConnectNetworkDialog.access$getMyContainers$p(this.this$0.this$0).get(it)), null, null, 12, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
                boolean bl = false;
                boolean bl2 = false;
                ComboBoxWithAutoCompletion<String> $this$apply = comboBoxWithAutoCompletion;
                boolean bl3 = false;
                Iterable iterable = ConnectNetworkDialog.access$getMyContainerNames$p(this.this$0);
                CharSequence charSequence = "#";
                ComboBoxWithAutoCompletion<String> comboBoxWithAutoCompletion2 = $this$apply;
                boolean bl4 = false;
                Iterator<T> iterator = iterable.iterator();
                if (!iterator.hasNext()) {
                    comparable = null;
                } else {
                    String it = (String)iterator.next();
                    boolean bl5 = false;
                    Comparable comparable2 = Integer.valueOf(it.length());
                    while (iterator.hasNext()) {
                        String it2 = (String)iterator.next();
                        $i$a$-maxOfOrNull-ConnectNetworkDialog$myContainersComboBox$2$2$1 = false;
                        Comparable comparable3 = Integer.valueOf(it2.length());
                        if (comparable2.compareTo(comparable3) >= 0) continue;
                        comparable2 = comparable3;
                    }
                    comparable = comparable2;
                }
                Comparable comparable4 = comparable;
                Integer n = (Integer)comparable4;
                comboBoxWithAutoCompletion2.setPrototypeDisplayValue(StringsKt.repeat((CharSequence)charSequence, (int)(n != null ? n : 0)));
                return comboBoxWithAutoCompletion;
            }
            {
                this.this$0 = connectNetworkDialog;
                this.$project = project;
                super(0);
            }
        }));
        this.dialog$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FragmentedDialog.Default<Settings>>(this, project, runtime){
            final /* synthetic */ ConnectNetworkDialog this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ DockerNetworkRuntime $runtime;

            @NotNull
            public final FragmentedDialog.Default<Settings> invoke() {
                String string = DockerBundle.message("ConnectNetworkDialog.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"ConnectNetworkDialog.title\")");
                String string2 = DockerBundle.message("ConnectNetworkDialog.popup.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"ConnectNetworkDialog.popup.title\")");
                Function1 function1 = (Function1)new Function1<FragmentedDialogOptionsBuilderImpl<Settings>, Unit>(this){
                    final /* synthetic */ dialog.2 this$0;

                    public final void invoke(@NotNull FragmentedDialogOptionsBuilderImpl<Settings> $receiver) {
                        Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
                        $receiver.commandLine("docker network connect", (Function1<FragmentedDialogCommandlineBuilder<Settings>, Unit>)((Function1)new Function1<FragmentedDialogCommandlineBuilder<Settings>, Unit>(this){
                            final /* synthetic */ dialog.2 this$0;

                            public final void invoke(@NotNull FragmentedDialogCommandlineBuilder<Settings> $this$commandLine) {
                                Intrinsics.checkNotNullParameter($this$commandLine, (String)"$receiver");
                                ComboBox comboBox2 = ConnectNetworkDialog.access$getMyContainersComboBox$p(this.this$0.this$0.this$0);
                                String string = this.this$0.this$0.$runtime.getNetwork().getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"runtime.network.name");
                                Function1 function1 = (Function1)new Function1<FragmentedDialogStaticOptionBuilder<ComponentWithFlag<ComboBoxWithAutoCompletion<String>>, Settings>, Unit>(this){
                                    final /* synthetic */ dialog.1 this$0;

                                    public final void invoke(@NotNull FragmentedDialogStaticOptionBuilder<ComponentWithFlag<ComboBoxWithAutoCompletion<String>>, Settings> $this$staticComboBoxWithFlag) {
                                        Intrinsics.checkNotNullParameter($this$staticComboBoxWithFlag, (String)"$receiver");
                                        $this$staticComboBoxWithFlag.setValidation((Function2<ComponentWithFlag<ComboBoxWithAutoCompletion<String>>, Settings, ValidationInfo>)((Function2)new Function2<ComponentWithFlag<ComboBoxWithAutoCompletion<String>>, Settings, ValidationInfo>(this){
                                            final /* synthetic */ dialog.2 this$0;

                                            /*
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            @Nullable
                                            public final ValidationInfo invoke(@NotNull ComponentWithFlag<ComboBoxWithAutoCompletion<String>> $noName_0, @NotNull Settings s) {
                                                ValidationInfo validationInfo;
                                                Intrinsics.checkNotNullParameter($noName_0, (String)"<anonymous parameter 0>");
                                                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                                                if (StringsKt.isBlank((CharSequence)s.getContainer())) {
                                                    validationInfo = new ValidationInfo(DockerBundle.message("ConnectNetworkDialog.validation.empty.container.name", new Object[0]));
                                                    return validationInfo;
                                                } else if (ConnectNetworkDialog.access$getMyContainers$p(this.this$0.this$0.this$0.this$0.this$0).get(s.getContainer()) == null) {
                                                    validationInfo = new ValidationInfo(DockerBundle.message("ConnectNetworkDialog.validation.container.not.exist", new Object[0]));
                                                    return validationInfo;
                                                } else {
                                                    DockerAgentContainer dockerAgentContainer = (DockerAgentContainer)ConnectNetworkDialog.access$getMyContainers$p(this.this$0.this$0.this$0.this$0.this$0).get(s.getContainer());
                                                    if (dockerAgentContainer == null) return null;
                                                    if (com.intellij.docker.action.networks.ConnectNetworkDialog$Companion.access$isInUpState(ConnectNetworkDialog.Companion, dockerAgentContainer)) return null;
                                                    validationInfo = new ValidationInfo(DockerBundle.message("ConnectNetworkDialog.validation.container.not.running", new Object[0]));
                                                }
                                                return validationInfo;
                                            }
                                            {
                                                this.this$0 = var1_1;
                                                super(2);
                                            }
                                        }));
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }
                                };
                                Function1 function12 = null;
                                boolean bl = false;
                                Function2 function2 = dialog.1.INSTANCE;
                                Function2 function22 = null;
                                String string2 = string;
                                FragmentedDialogCommandlineBuilder.staticComboBoxWithFlag$default($this$commandLine, comboBox2, function2, function22, string2, bl, function12, function1, 52, null);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }));
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                };
                Function1 function12 = (Function1)new Function1<Settings, String>(this){
                    final /* synthetic */ dialog.2 this$0;

                    @NotNull
                    public final String invoke(@NotNull Settings it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return "docker network connect " + this.this$0.$runtime.getNetwork().getName() + ' ' + it.getContainer();
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                };
                Object var3_3 = null;
                String string3 = "org.jetbrains.docker.engine/reference/commandline/network_connect/";
                Settings settings = new Settings(null, 1, null);
                return new FragmentedDialog.Default<Settings>(this.$project, string, string2, DockerBundle.message("ConnectNetworkDialog.ok.button.text", new Object[0]), string3, (Object)settings, var3_3, function12, function1, 64, null);
            }
            {
                this.this$0 = connectNetworkDialog;
                this.$project = project;
                this.$runtime = dockerNetworkRuntime;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ List access$getMyContainerNames$p(ConnectNetworkDialog $this) {
        return $this.myContainerNames;
    }

    public static final /* synthetic */ Map access$getMyContainers$p(ConnectNetworkDialog $this) {
        return $this.myContainers;
    }

    public static final /* synthetic */ ComboBoxWithAutoCompletion access$getMyContainersComboBox$p(ConnectNetworkDialog $this) {
        return $this.getMyContainersComboBox();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/action/networks/ConnectNetworkDialog$Settings;", "", "container", "", "(Ljava/lang/String;)V", "getContainer", "()Ljava/lang/String;", "setContainer", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clouds.docker"})
    public static final class Settings {
        @NotNull
        private String container;

        @NotNull
        public final String getContainer() {
            return this.container;
        }

        public final void setContainer(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.container = string;
        }

        public Settings(@NotNull String container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            this.container = container;
        }

        public /* synthetic */ Settings(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            this(string);
        }

        public Settings() {
            this(null, 1, null);
        }

        @NotNull
        public final String component1() {
            return this.container;
        }

        @NotNull
        public final Settings copy(@NotNull String container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            return new Settings(container);
        }

        public static /* synthetic */ Settings copy$default(Settings settings, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = settings.container;
            }
            return settings.copy(string);
        }

        @NotNull
        public String toString() {
            return "Settings(container=" + this.container + ")";
        }

        public int hashCode() {
            String string = this.container;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Settings)) break block3;
                    Settings settings = (Settings)object;
                    if (!Intrinsics.areEqual((Object)this.container, (Object)settings.container)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u0004\u0018\u00010\u0007H\u0002J\f\u0010\b\u001a\u00020\t*\u00020\u0007H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/action/networks/ConnectNetworkDialog$Companion;", "", "()V", "CONNECT_COMMAND", "", "computeIcon", "Ljavax/swing/Icon;", "Lcom/intellij/docker/agent/DockerAgentContainer;", "isInUpState", "", "intellij.clouds.docker"})
    public static final class Companion {
        private final boolean isInUpState(DockerAgentContainer $this$isInUpState) {
            String string = $this$isInUpState.getContainer().getStatus();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.container.status");
            return StringsKt.startsWith$default((String)string, (String)"Up", (boolean)false, (int)2, null);
        }

        private final Icon computeIcon(DockerAgentContainer $this$computeIcon) {
            Icon icon;
            DockerAgentContainer dockerAgentContainer = $this$computeIcon;
            if (dockerAgentContainer != null) {
                boolean bl = this.isInUpState(dockerAgentContainer);
                boolean bl2 = false;
                boolean bl3 = false;
                boolean it = bl;
                boolean bl4 = false;
                icon = it ? DockerIcons.SingleRunningContainer : DockerIcons.SingleStoppedContainer;
            } else {
                icon = null;
            }
            return icon;
        }

        private Companion() {
        }

        public static final /* synthetic */ Icon access$computeIcon(Companion $this, DockerAgentContainer $this$access_u24computeIcon) {
            return $this.computeIcon($this$access_u24computeIcon);
        }

        public static final /* synthetic */ boolean access$isInUpState(Companion $this, DockerAgentContainer $this$access_u24isInUpState) {
            return $this.isInUpState($this$access_u24isInUpState);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

