/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action.compose;

import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MessageType;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.util.ApplicationActionUtils;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ComposeServiceActionBase
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(ComposeServiceActionBase.class);
    private final boolean myIsMultipleActionsEnabled;

    protected ComposeServiceActionBase(boolean enableMultipleActions) {
        this.myIsMultipleActionsEnabled = enableMultipleActions;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ComposeServiceActionBase.$$$reportNull$$$0(0);
        }
        if (this.myIsMultipleActionsEnabled) {
            List runtimes = ComposeServiceActionBase.getComposeServiceRuntimes(e).toList();
            boolean isVisible = !runtimes.isEmpty() && ContainerUtil.and((Iterable)runtimes, r -> r != null && r.isContainsContainers());
            e.getPresentation().setVisible(isVisible);
            e.getPresentation().setEnabled(isVisible && ContainerUtil.and((Iterable)runtimes, this::isEnabled));
        } else {
            ComposeServiceRuntime runtime = (ComposeServiceRuntime)ApplicationActionUtils.getApplicationRuntime((AnActionEvent)e, ComposeServiceRuntime.class);
            e.getPresentation().setVisible(runtime != null && runtime.isContainsContainers());
            e.getPresentation().setEnabled(this.isEnabled(runtime));
        }
    }

    protected boolean isEnabled(@Nullable ComposeServiceRuntime serviceRuntime) {
        return serviceRuntime != null && !serviceRuntime.isOrphans();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ComposeServiceActionBase.$$$reportNull$$$0(1);
        }
        ComposeServiceActionBase.getComposeServiceRuntimes(e).forEach(this::tryDoAction);
    }

    private static JBIterable<ComposeServiceRuntime> getComposeServiceRuntimes(@NotNull AnActionEvent e) {
        if (e == null) {
            ComposeServiceActionBase.$$$reportNull$$$0(2);
        }
        return ServiceViewActionUtils.getTargets((AnActionEvent)e, DeploymentNode.class).map(n -> (ComposeServiceRuntime)ApplicationActionUtils.getApplicationRuntime((DeploymentNode)n, ComposeServiceRuntime.class));
    }

    private void tryDoAction(ComposeServiceRuntime serviceRuntime) {
        try {
            this.doActionPerformed(serviceRuntime);
        }
        catch (ServerRuntimeException ex) {
            LOG.debug((Throwable)ex);
            ComposeApplicationRuntime.COMPOSE_NOTIFIER.showMessage(ex.getMessage(), MessageType.ERROR);
        }
    }

    protected abstract void doActionPerformed(ComposeServiceRuntime var1) throws ServerRuntimeException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/docker/action/compose/ComposeServiceActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getComposeServiceRuntimes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

