/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action.compose;

import com.intellij.docker.action.compose.ComposeServiceActionBase;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.ui.Messages;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/action/compose/ComposeDeleteServiceAction;", "Lcom/intellij/docker/action/compose/ComposeServiceActionBase;", "()V", "doActionPerformed", "", "serviceRuntime", "Lcom/intellij/docker/runtimes/ComposeServiceRuntime;", "getUserConfirmation", "", "serviceName", "", "containerCount", "", "isEnabled", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.clouds.docker"})
public final class ComposeDeleteServiceAction
extends ComposeServiceActionBase {
    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
        } else {
            super.update(e);
        }
    }

    @Override
    protected void doActionPerformed(@Nullable ComposeServiceRuntime serviceRuntime) {
        ComposeServiceRuntime composeServiceRuntime = serviceRuntime;
        if (composeServiceRuntime == null) {
            return;
        }
        int size = composeServiceRuntime.getCountOfContainers();
        if (size != 0 && this.getUserConfirmation(serviceRuntime.getServiceName(), size)) {
            serviceRuntime.deleteAllContainers();
        }
    }

    @Override
    protected boolean isEnabled(@Nullable ComposeServiceRuntime serviceRuntime) {
        return serviceRuntime != null;
    }

    private final boolean getUserConfirmation(String serviceName, int containerCount) {
        String string;
        switch (containerCount) {
            case 0: {
                throw (Throwable)new IllegalArgumentException();
            }
            case 1: {
                string = DockerBundle.message("DockerDeleteProvider.confirmation.container.one", new Object[0]);
                break;
            }
            default: {
                string = DockerBundle.message("DockerDeleteProvider.confirmation.container.many", containerCount);
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (containerCount) {\n\u2026y\", containerCount)\n    }");
        String containersPiece = string;
        return Messages.showYesNoDialog(null, (String)DockerBundle.message("ComposeDeleteServiceAction.confirmation", containersPiece, serviceName), (String)DockerBundle.message("DockerDeleteProvider.confirmation.title", new Object[0]), (Icon)Messages.getWarningIcon()) == 0;
    }

    public ComposeDeleteServiceAction() {
        super(true);
    }
}

