/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.action.DockerDeleteRuntimeActionBase;
import com.intellij.docker.runtimes.DockerRuntimeBase;
import com.intellij.docker.ui.utils.DockerDeleteConfirmation;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014J\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH$J \u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0014J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000bH$J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n*\u00020\u0006H\u0004\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/action/DockerDeleteRuntimeActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "confirmDeletion", "", "runtimes", "", "Lcom/intellij/docker/runtimes/DockerRuntimeBase;", "isEnabled", "isVisible", "performDelete", "runtime", "update", "getRuntimes", "intellij.clouds.docker"})
public abstract class DockerDeleteRuntimeActionBase
extends DumbAwareAction {
    protected abstract boolean isEnabled(@NotNull AnActionEvent var1, @NotNull List<? extends DockerRuntimeBase> var2);

    protected abstract void performDelete(@NotNull DockerRuntimeBase var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isVisible(@NotNull AnActionEvent e, @NotNull List<? extends DockerRuntimeBase> runtimes) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(runtimes, (String)"runtimes");
        Collection collection = runtimes;
        boolean bl2 = false;
        if (collection.isEmpty()) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        Iterable $this$all$iv = runtimes;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            DockerRuntimeBase it = (DockerRuntimeBase)((Object)element$iv);
            boolean bl4 = false;
            if (it == null) return false;
            bl = true;
        } while (bl);
        return false;
    }

    public final void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        List<DockerRuntimeBase> runtimes = this.getRuntimes(e);
        boolean visible = this.isVisible(e, runtimes);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setVisible(visible);
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabled(visible && this.isEnabled(e, CollectionsKt.filterNotNull((Iterable)runtimes)));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List runtimes = CollectionsKt.filterNotNull((Iterable)this.getRuntimes(e));
        if (runtimes.isEmpty() || !this.confirmDeletion(runtimes)) {
            return;
        }
        Iterable $this$forEach$iv = runtimes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DockerRuntimeBase it = (DockerRuntimeBase)((Object)element$iv);
            boolean bl = false;
            this.performDelete(it);
        }
    }

    @NotNull
    protected final List<DockerRuntimeBase> getRuntimes(@NotNull AnActionEvent $this$getRuntimes) {
        Intrinsics.checkNotNullParameter((Object)$this$getRuntimes, (String)"$this$getRuntimes");
        JBIterable jBIterable = ServiceViewActionUtils.getTargets((AnActionEvent)$this$getRuntimes, DeploymentNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"ServiceViewActionUtils.g\u2026ploymentNode::class.java)");
        JBIterable nodes = jBIterable;
        List list = nodes.map((Function)getRuntimes.1.INSTANCE).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"nodes.map { ApplicationA\u2026kerRuntimeBase }.toList()");
        return list;
    }

    protected boolean confirmDeletion(@NotNull List<? extends DockerRuntimeBase> runtimes) {
        Intrinsics.checkNotNullParameter(runtimes, (String)"runtimes");
        return DockerDeleteConfirmation.getUserConfirmation(runtimes.size());
    }
}

