/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerRunConfigurationCreator;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import java.util.List;
import java.util.Optional;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerRunLineMarkerProviderBase
implements LineMarkerProvider {
    protected static List<RemoteServer<DockerCloudConfiguration>> listAllDockerAccounts() {
        return RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance());
    }

    @Nls
    public static String getGenericTooltip() {
        return DockerBundle.message("DockerRunLineMarkerProviderBase.tooltip", new Object[0]);
    }

    @Nullable
    protected static ActionGroup combineActions(@NotNull List<? extends AnAction> existingRunConfigsActions, @NotNull List<? extends AnAction> newRunConfigActions) {
        if (existingRunConfigsActions == null) {
            DockerRunLineMarkerProviderBase.$$$reportNull$$$0(0);
        }
        if (newRunConfigActions == null) {
            DockerRunLineMarkerProviderBase.$$$reportNull$$$0(1);
        }
        if (existingRunConfigsActions.isEmpty() && newRunConfigActions.isEmpty()) {
            return null;
        }
        DefaultActionGroup result2 = new DefaultActionGroup();
        for (AnAction anAction : existingRunConfigsActions) {
            result2.addAction(anAction);
        }
        if (!existingRunConfigsActions.isEmpty() && !newRunConfigActions.isEmpty()) {
            result2.addAction((AnAction)new Separator());
        }
        for (AnAction anAction : newRunConfigActions) {
            result2.addAction(anAction);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "existingRunConfigsActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "newRunConfigActions";
                break;
            }
        }
        objectArray[1] = "com/intellij/docker/DockerRunLineMarkerProviderBase";
        objectArray[2] = "combineActions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static abstract class RunConfigLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        public RunConfigLineMarkerInfo(@NotNull PsiElement psi, @NotNull Icon icon) {
            if (psi == null) {
                RunConfigLineMarkerInfo.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                RunConfigLineMarkerInfo.$$$reportNull$$$0(1);
            }
            super(psi, psi.getTextRange(), icon, whatever -> DockerRunLineMarkerProviderBase.getGenericTooltip(), null, GutterIconRenderer.Alignment.CENTER);
        }

        @NotNull
        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return null;
                }

                public boolean isNavigateAction() {
                    return true;
                }

                @Nullable
                public ActionGroup getPopupMenuActions() {
                    PsiElement psi = this.getElement();
                    if (psi == null) {
                        return null;
                    }
                    VirtualFile vFile = Optional.ofNullable(psi.getContainingFile()).map(PsiFile::getVirtualFile).orElse(null);
                    return vFile == null ? null : this.computeGutterPopup(new DockerRunConfigurationCreator(psi.getProject()), vFile);
                }
            };
        }

        protected abstract ActionGroup computeGutterPopup(@NotNull DockerRunConfigurationCreator var1, @NotNull VirtualFile var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psi";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/DockerRunLineMarkerProviderBase$RunConfigLineMarkerInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

