/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerMappingConfigurable;
import com.intellij.docker.agent.settings.DockerPathMappingImpl;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.settings.TableWithCardEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.remoteServer.util.Column;
import org.jetbrains.annotations.Nls;

public class DockerPathMappingEditor
extends TableWithCardEditor<DockerPathMappingImpl, ColumnBase> {
    public DockerPathMappingEditor() {
        super((Column[])new ColumnBase[]{new VirtualMachinePathColumn(), new LocalPathColumn()});
        this.setShowGrid(false);
    }

    @Override
    protected DockerPathMappingImpl createItem() {
        return new DockerPathMappingImpl();
    }

    @Override
    protected DockerPathMappingImpl cloneItem(DockerPathMappingImpl item) {
        return new DockerPathMappingImpl(item);
    }

    @Override
    protected Configurable createItemConfigurable(DockerPathMappingImpl item) {
        return new DockerMappingConfigurable(item);
    }

    private static class LocalPathColumn
    extends ColumnBase {
        LocalPathColumn() {
            super(DockerBundle.message("docker.path.mapping.editor.table.local.path.header", new Object[0]));
        }

        public Object getColumnValue(DockerPathMappingImpl row) {
            return row.getLocalPath();
        }
    }

    private static class VirtualMachinePathColumn
    extends ColumnBase {
        VirtualMachinePathColumn() {
            super(DockerBundle.message("docker.path.mapping.editor.table.virtual.machine.path.header", new Object[0]));
        }

        public Object getColumnValue(DockerPathMappingImpl row) {
            return row.getVirtualMachinePath();
        }
    }

    public static abstract class ColumnBase
    extends Column<DockerPathMappingImpl> {
        public ColumnBase(@Nls String name) {
            super(name);
        }
    }
}

