/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerIcons;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.icons.AllIcons;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerDeploymentStatus {
    private static final DeploymentStatus STOPPED_EXITED = new DeploymentStatus(DockerIcons.SingleStoppedContainer, DockerBundle.messagePointer("DockerDeploymentStatus.stopped", new Object[0]), false);
    private static final DeploymentStatus STOPPED_CREATED = new DeploymentStatus(DockerIcons.SingleStoppedContainer, DockerBundle.messagePointer("DockerDeploymentStatus.created", new Object[0]), false);
    public static final DeploymentStatus IMAGE = new DeploymentStatus(DockerIcons.SingleImage, DockerBundle.messagePointer("DockerDeploymentStatus.image", new Object[0]), false);
    public static final DockerDeploymentStatus STARTING = new DockerDeploymentStatus(DeploymentStatus.DEPLOYING, DockerBundle.messagePointer("DockerDeploymentStatus.starting", new Object[0]));
    public static final DockerDeploymentStatus STARTED = new DockerDeploymentStatus(DeploymentStatus.DEPLOYED, DockerBundle.messagePointer("DockerDeploymentStatus.started", new Object[0]));
    public static final DockerDeploymentStatus STOPPING = new DockerDeploymentStatus(DeploymentStatus.UNDEPLOYING, DockerBundle.messagePointer("DockerDeploymentStatus.stopping", new Object[0]));
    public static final DeploymentStatus PAUSED = new DeploymentStatus(AllIcons.RunConfigurations.TestPaused, DockerBundle.messagePointer("DockerDeploymentStatus.paused", new Object[0]), false);
    public static final DockerDeploymentStatus STOPPED = DockerDeploymentStatus.wrapStatus(STOPPED_EXITED);
    public static final DockerDeploymentStatus CREATED = DockerDeploymentStatus.wrapStatus(STOPPED_CREATED);
    public static final DockerDeploymentStatus DELETING = new DockerDeploymentStatus(DeploymentStatus.UNDEPLOYING, DockerBundle.messagePointer("DockerDeploymentStatus.deleting", new Object[0]));
    public static final DockerDeploymentStatus DELETED = new DockerDeploymentStatus(DeploymentStatus.NOT_DEPLOYED, DockerBundle.messagePointer("DockerDeploymentStatus.deleted", new Object[0]));
    private final DeploymentStatus myMainStatus;
    private final Supplier<@Nls String> myCustomText;

    public static DockerDeploymentStatus newContainerStatus(@Nullable @Nls String statusText2) {
        if (statusText2 == null || DockerUtil.isStartedStatus(statusText2)) {
            return statusText2 == null ? DockerDeploymentStatus.wrapStatus(DeploymentStatus.DEPLOYED) : new DockerDeploymentStatus(DeploymentStatus.DEPLOYED, statusText2);
        }
        if (DockerUtil.isExitedStatus(statusText2)) {
            return new DockerDeploymentStatus(STOPPED_EXITED, statusText2);
        }
        if (DockerUtil.isCreatedStatus(statusText2)) {
            return new DockerDeploymentStatus(STOPPED_CREATED, statusText2);
        }
        if (DockerUtil.isPausedStatus(statusText2)) {
            return new DockerDeploymentStatus(PAUSED, statusText2);
        }
        return new DockerDeploymentStatus(DeploymentStatus.DEPLOYING, statusText2);
    }

    public static DockerDeploymentStatus wrapStatus(@NotNull DeploymentStatus mainStatus) {
        if (mainStatus == null) {
            DockerDeploymentStatus.$$$reportNull$$$0(0);
        }
        return new DockerDeploymentStatus(mainStatus, mainStatus.getPresentableText());
    }

    public static DockerDeploymentStatus newImageStatus(@NotNull @Nls String statusText2) {
        if (statusText2 == null) {
            DockerDeploymentStatus.$$$reportNull$$$0(1);
        }
        return new DockerDeploymentStatus(IMAGE, statusText2);
    }

    public DockerDeploymentStatus(@NotNull DeploymentStatus mainStatus, @NotNull @Nls String customText) {
        if (mainStatus == null) {
            DockerDeploymentStatus.$$$reportNull$$$0(2);
        }
        if (customText == null) {
            DockerDeploymentStatus.$$$reportNull$$$0(3);
        }
        this(mainStatus, () -> customText);
    }

    public DockerDeploymentStatus(@NotNull DeploymentStatus mainStatus, @NotNull Supplier<@Nls String> customText) {
        if (mainStatus == null) {
            DockerDeploymentStatus.$$$reportNull$$$0(4);
        }
        if (customText == null) {
            DockerDeploymentStatus.$$$reportNull$$$0(5);
        }
        this.myMainStatus = mainStatus;
        this.myCustomText = customText;
    }

    public DeploymentStatus getStatus() {
        return this.myMainStatus;
    }

    @Nls
    public String getCustomText() {
        return this.myCustomText.get();
    }

    public boolean matches(@NotNull Deployment deploymentModel) {
        if (deploymentModel == null) {
            DockerDeploymentStatus.$$$reportNull$$$0(6);
        }
        return this.myMainStatus.equals(deploymentModel.getStatus()) && this.getCustomText().equals(deploymentModel.getStatusText());
    }

    public void apply(@Nullable Deployment deploymentModel) {
        if (deploymentModel != null) {
            deploymentModel.setStatus(this.myMainStatus, this.getCustomText());
        }
    }

    public static boolean canBeStarted(@NotNull DeploymentStatus status) {
        if (status == null) {
            DockerDeploymentStatus.$$$reportNull$$$0(7);
        }
        return status == STOPPED.getStatus() || status == CREATED.getStatus();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + ":" + this.myCustomText + ", main status: " + this.myMainStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainStatus";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusText";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/DockerDeploymentStatus";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapStatus";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "newImageStatus";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "matches";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeStarted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

