/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConnectionConfigurator;
import com.intellij.docker.agent.DockerAgentConfig;
import com.intellij.docker.agent.settings.DockerPathMappingImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.util.SystemProperties;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerCloudConfiguration
extends CloudConfigurationBase<DockerCloudConfiguration> {
    private static final Logger LOG = Logger.getInstance(DockerCloudConfiguration.class);
    @NonNls
    public static final String DOCKER_MACHINE_NAME_VAR = "DOCKER_MACHINE_NAME";
    @NonNls
    public static final String DOCKER_HOST_ENV_VAR = "DOCKER_HOST";
    @NonNls
    public static final String DOCKER_TLS_VERIFY_ENV_VAR = "DOCKER_TLS_VERIFY";
    @NonNls
    public static final String DOCKER_CERT_PATH_ENV_VAR = "DOCKER_CERT_PATH";
    private String myApiUrl = "";
    private String myCertificatesPath = "";
    private String myMachine;
    private List<DockerPathMappingImpl> myPathMappings = DockerCloudConfiguration.createDefaultMappings();
    private Map<String, String> myContributedData = new LinkedHashMap<String, String>();
    private String myCustomConfiguratorId = null;
    private static final String DEFAULT_LINUX_CERT_PATH = "~/.docker";
    public static final String DEFAULT_UNIX_SOCK = "unix:///var/run/docker.sock";
    public static final String DEFAULT_WIN_PIPE = "npipe:////./pipe/docker_engine";

    public String getApiUrl() {
        return this.myApiUrl;
    }

    @NotNull
    public String computeDockerHost() {
        String string = Optional.ofNullable(this.myCustomConfiguratorId).map(DockerCloudConnectionConfigurator::findById).map(configurator -> configurator.computeDockerHost(this)).orElseGet(() -> StringUtil.notNullize((String)this.myApiUrl));
        if (string == null) {
            DockerCloudConfiguration.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public DockerAgentConfig createConnectionConfig() {
        DockerAgentConfig result2 = null;
        DockerCloudConnectionConfigurator configurator = DockerCloudConnectionConfigurator.findById(this.myCustomConfiguratorId);
        if (configurator != null) {
            result2 = configurator.configureConnection(this);
        }
        return result2 != null ? result2 : new DockerAgentConfig.Impl(StringUtil.notNullize((String)this.getApiUrl()), this.getCertificatesPath());
    }

    public void setApiUrl(String apiUrl) {
        this.myApiUrl = apiUrl;
    }

    public String getCertificatesPath() {
        return this.myCertificatesPath;
    }

    public void setCertificatesPath(String certificatesPath) {
        this.myCertificatesPath = certificatesPath;
    }

    public String getCustomConfiguratorId() {
        return this.myCustomConfiguratorId;
    }

    public void setCustomConfiguratorId(String customConfiguratorId) {
        this.myCustomConfiguratorId = customConfiguratorId;
    }

    public static DockerCloudConfiguration createDefault() {
        DockerCloudConfiguration result2 = new DockerCloudConfiguration();
        Pieces pieces = Pieces.reload();
        if (pieces.getApiUrlAsString() != null) {
            result2.setApiUrl(pieces.getApiUrlAsString());
        } else {
            String defaultUrl = SystemInfo.isWindows ? DEFAULT_WIN_PIPE : DEFAULT_UNIX_SOCK;
            result2.setApiUrl(defaultUrl);
        }
        String certificatesPath = pieces.getCertificatesPath();
        if (certificatesPath != null) {
            result2.setCertificatesPath(FileUtil.toSystemDependentName((String)certificatesPath));
        } else if (SystemInfo.isLinux) {
            Optional.ofNullable(Pieces.replaceLinuxHome(DEFAULT_LINUX_CERT_PATH)).map(File::new).filter(File::exists).filter(File::isDirectory).ifPresent(folder -> result2.setCertificatesPath(folder.getAbsolutePath()));
        }
        return result2;
    }

    private static List<DockerPathMappingImpl> createDefaultMappings() {
        ArrayList<DockerPathMappingImpl> result2 = new ArrayList<DockerPathMappingImpl>();
        if (SystemInfo.isMac) {
            result2.add(DockerPathMappingImpl.createMacDefaults());
        }
        if (SystemInfo.isWindows) {
            result2.add(DockerPathMappingImpl.createWinDefaults());
        }
        return result2;
    }

    @Nullable
    public String getMachine() {
        return this.myMachine;
    }

    public void setMachine(@Nullable String machine) {
        this.myMachine = machine;
    }

    @AbstractCollection
    public List<DockerPathMappingImpl> getPathMappings() {
        return this.myPathMappings;
    }

    public void setPathMappings(List<DockerPathMappingImpl> pathMappings) {
        this.myPathMappings = pathMappings;
    }

    @Property(surroundWithTag=false)
    @MapAnnotation(surroundKeyWithTag=false, surroundWithTag=false, keyAttributeName="contributedKey")
    public Map<String, String> getContributedData() {
        return this.myContributedData;
    }

    public void setContributedData(Map<String, String> contributedData) {
        this.myContributedData = contributedData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerCloudConfiguration", "computeDockerHost"));
    }

    private static final class FromDockerOptsFile {
        @NonNls
        private static final String DOCKER_OPTS_FILE_PATH = "/etc/default/docker";
        @NonNls
        private static final String DOCKER_OPTS_INIT_VAR = "DOCKER_OPTS";
        @NonNls
        private static final String TLS_CERT_OPTION = "--tlscert";
        @NonNls
        private static final String HOST_OPTION = "-H";

        private FromDockerOptsFile() {
        }

        public static void load(@NotNull Pieces output) throws IOException {
            if (output == null) {
                FromDockerOptsFile.$$$reportNull$$$0(0);
            }
            if (!SystemInfo.isLinux) {
                return;
            }
            String initVarPrefix = "DOCKER_OPTS=";
            for (String line : FileUtil.loadLines((String)DOCKER_OPTS_FILE_PATH)) {
                if (!line.startsWith("DOCKER_OPTS=")) continue;
                FromDockerOptsFile.parseInitVar(StringUtil.trimStart((String)line, (String)"DOCKER_OPTS="), output);
            }
        }

        private static void parseInitVar(String initVar, @NotNull Pieces output) {
            Iterator itOpts;
            String opt;
            if (output == null) {
                FromDockerOptsFile.$$$reportNull$$$0(1);
            }
            String string = opt = (itOpts = ParametersListUtil.parse((String)StringUtil.unquoteString((String)initVar)).iterator()).hasNext() ? (String)itOpts.next() : null;
            while (opt != null) {
                String optValue;
                String nextOpt = itOpts.hasNext() ? (String)itOpts.next() : null;
                int eqIndex = opt.indexOf("=");
                boolean hasEq = eqIndex > -1;
                String optName = hasEq ? opt.substring(0, eqIndex) : opt;
                String string2 = optValue = hasEq ? opt.substring(eqIndex + 1) : nextOpt;
                if (optValue != null) {
                    if (TLS_CERT_OPTION.equals(optName)) {
                        String tlscert = FileUtil.toSystemIndependentName((String)optValue);
                        int filenameIndex = tlscert.lastIndexOf("/");
                        if (filenameIndex > -1) {
                            output.setCertificatesPath(tlscert.substring(0, filenameIndex));
                        }
                    } else if (HOST_OPTION.equals(optName)) {
                        output.setDockerHost(optValue);
                    }
                }
                opt = nextOpt;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "output";
            objectArray2[1] = "com/intellij/docker/DockerCloudConfiguration$FromDockerOptsFile";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "load";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseInitVar";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Pieces {
        @NonNls
        private static final String LINUX_HOME_PATH = "~";
        private String myApiUrlString;
        private String myCertificatesPath;

        private Pieces() {
        }

        @Nullable
        public String getApiUrlAsString() {
            return this.myApiUrlString;
        }

        @NotNull
        public static Pieces reload() {
            Pieces result2 = new Pieces();
            if (SystemInfo.isLinux) {
                try {
                    FromDockerOptsFile.load(result2);
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            }
            result2.loadFromEnvVars();
            Pieces pieces = result2;
            if (pieces == null) {
                Pieces.$$$reportNull$$$0(0);
            }
            return pieces;
        }

        public void setDockerHost(@NotNull String dockerHost) {
            if (dockerHost == null) {
                Pieces.$$$reportNull$$$0(1);
            }
            this.myApiUrlString = Pieces.replaceAnyHost(dockerHost);
        }

        public void setCertificatesPath(@Nullable String certificatesPath) {
            this.myCertificatesPath = certificatesPath;
        }

        private void loadFromEnvVars() {
            String dockerHost = System.getenv(DockerCloudConfiguration.DOCKER_HOST_ENV_VAR);
            if (dockerHost != null) {
                boolean secured;
                this.setDockerHost(dockerHost);
                boolean bl = secured = System.getenv(DockerCloudConfiguration.DOCKER_TLS_VERIFY_ENV_VAR) != null;
                if (secured) {
                    this.setCertificatesPath(StringUtil.nullize((String)System.getenv(DockerCloudConfiguration.DOCKER_CERT_PATH_ENV_VAR)));
                }
            }
        }

        @Nullable
        public String getCertificatesPath() {
            return Pieces.replaceLinuxHome(this.myCertificatesPath);
        }

        @NotNull
        private static String replaceAnyHost(@NotNull String urlString) {
            if (urlString == null) {
                Pieces.$$$reportNull$$$0(2);
            }
            String LOCAL_HOST = "127.0.0.1";
            String ANY_HOST = "0.0.0.0";
            String string = urlString.contains("0.0.0.0") ? urlString.replace("0.0.0.0", "127.0.0.1") : urlString;
            if (string == null) {
                Pieces.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Contract(value="null -> null")
        @Nullable
        public static String replaceLinuxHome(@Nullable String path) {
            return path != null && path.startsWith(LINUX_HOME_PATH) ? SystemProperties.getUserHome() + StringUtil.trimStart((String)path, (String)LINUX_HOME_PATH) : path;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/DockerCloudConfiguration$Pieces";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dockerHost";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urlString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "reload";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/DockerCloudConfiguration$Pieces";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replaceAnyHost";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setDockerHost";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceAnyHost";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

