/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import java.util.Map;

public class DockerAgentPathMapperImpl
implements DockerAgentPathMapper {
    private final PathMacroManager myMacroManager;
    private final Project myProject;
    private final ExpandMacroToPathMap myEnvVars;

    public DockerAgentPathMapperImpl(Project project) {
        this.myProject = project;
        this.myEnvVars = DockerAgentPathMapperImpl.getSystemEnvMacroToPathMap();
        this.myMacroManager = PathMacroManager.getInstance((ComponentManager)project);
    }

    @Override
    public String expandPath(String path) {
        if (this.myProject.isDisposed()) {
            return path;
        }
        String expandedPath = this.myMacroManager.expandPath(path);
        if (expandedPath.equals(path)) {
            return this.myEnvVars.substitute(DockerAgentPathMapperImpl.normalizeEnvMacros(path), SystemInfoRt.isFileSystemCaseSensitive);
        }
        return expandedPath;
    }

    @Override
    public String collapsePath(String path) {
        if (this.myProject.isDisposed()) {
            return path;
        }
        return this.myMacroManager.collapsePath(path);
    }

    private static String normalizeEnvMacros(String macros) {
        if (macros.startsWith("${") && macros.endsWith("}")) {
            return "$" + macros.substring(2, macros.length() - 1) + "$";
        }
        return macros;
    }

    private static ExpandMacroToPathMap getSystemEnvMacroToPathMap() {
        ExpandMacroToPathMap result2 = new ExpandMacroToPathMap();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            result2.addMacroExpand(entry.getKey(), entry.getValue());
        }
        return result2;
    }
}

