/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerRunConfigurationCreator;
import com.intellij.docker.RunConfigActionBase;
import com.intellij.docker.deployment.DockerRunConfig;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.RemoteServer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\rH\u0016R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/ConfigureNewRunConfig;", "Lcom/intellij/docker/RunConfigActionBase;", "helper", "Lcom/intellij/docker/DockerRunConfigurationCreator;", "mySourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "mySourceType", "Lcom/intellij/docker/deploymentSource/DockerSingletonDeploymentSourceType;", "myDocker", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "(Lcom/intellij/docker/DockerRunConfigurationCreator;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/docker/deploymentSource/DockerSingletonDeploymentSourceType;Lcom/intellij/remoteServer/configuration/RemoteServer;)V", "customize", "", "runConfigWrapper", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "execute", "intellij.clouds.docker"})
public class ConfigureNewRunConfig
extends RunConfigActionBase {
    private final VirtualFile mySourceFile;
    private final DockerSingletonDeploymentSourceType mySourceType;
    private final RemoteServer<DockerCloudConfiguration> myDocker;

    @Override
    public void execute() {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.getHelper().createConfiguration(this.mySourceType, this.mySourceFile, this.myDocker);
        Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"helper.createConfigurati\u2026, mySourceFile, myDocker)");
        RunnerAndConfigurationSettings runConfig = runnerAndConfigurationSettings;
        DockerRunConfig.Wrapper dockerRunConfig = DockerRunConfig.Wrapper.Companion.wrapIfDocker(runConfig);
        boolean bl = dockerRunConfig != null;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "for " + runConfig;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        DockerRunConfig.Wrapper wrapper = dockerRunConfig;
        Intrinsics.checkNotNull((Object)wrapper);
        this.customize(wrapper);
        this.getHelper().openForEditingAndExecute(runConfig, DockerBundle.message("DockerRunLineMarkerProviderBase.ConfigureNewRunConfig.dialogTitle", new Object[0]));
    }

    protected void customize(@NotNull DockerRunConfig.Wrapper runConfigWrapper) {
        Intrinsics.checkNotNullParameter((Object)runConfigWrapper, (String)"runConfigWrapper");
    }

    public ConfigureNewRunConfig(@NotNull DockerRunConfigurationCreator helper, @Nullable VirtualFile mySourceFile, @NotNull DockerSingletonDeploymentSourceType mySourceType, @Nullable RemoteServer<DockerCloudConfiguration> myDocker) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Intrinsics.checkNotNullParameter((Object)((Object)mySourceType), (String)"mySourceType");
        super(helper);
        this.mySourceFile = mySourceFile;
        this.mySourceType = mySourceType;
        this.myDocker = myDocker;
        this.getTemplatePresentation().setText(DockerBundle.messagePointer("DockerRunLineMarkerProviderBase.ConfigureNewRunConfig.text", new Object[0]));
    }
}

