/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.statistics;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.lifecycle.beans.tab.BeansEndpointTabSettings;
import com.intellij.spring.boot.run.lifecycle.beans.tab.LiveBeansPanelContent;
import com.intellij.spring.boot.run.update.SpringBootApplicationUpdatePolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringBootRunFeatureUsagesCollector
extends ProjectUsagesCollector {
    private static final List<Integer> steps = Arrays.asList(1, 2, 3, 4, 5, 10, 100, 200, 500, 1000);

    SpringBootRunFeatureUsagesCollector() {
    }

    @NotNull
    public String getGroupId() {
        return "spring.boot.run";
    }

    public int getVersion() {
        return 3;
    }

    protected boolean requiresReadAccess() {
        return true;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            SpringBootRunFeatureUsagesCollector.$$$reportNull$$$0(0);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(project)) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                SpringBootRunFeatureUsagesCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        LinkedHashSet<MetricEvent> metrics = new LinkedHashSet<MetricEvent>();
        List runnerAndConfigurationSettings = RunManager.getInstance((Project)project).getConfigurationSettingsList((ConfigurationType)SpringBootApplicationConfigurationTypeBase.getInstance());
        metrics.add(MetricEventFactoryKt.newMetric((String)"spring.boot.run.configs", (FeatureUsageData)new FeatureUsageData().addData("count", runnerAndConfigurationSettings.size()).addData("count_group", StatisticsUtil.INSTANCE.getCountingStepName(runnerAndConfigurationSettings.size(), steps))));
        HashMap<String, Integer> mainClassCounter = new HashMap<String, Integer>();
        for (RunnerAndConfigurationSettings settings : runnerAndConfigurationSettings) {
            ProgressManager.checkCanceled();
            RunConfiguration configuration = settings.getConfiguration();
            if (!(configuration instanceof SpringBootApplicationRunConfiguration)) continue;
            SpringBootApplicationRunConfiguration sbRunConfig = (SpringBootApplicationRunConfiguration)configuration;
            mainClassCounter.merge(sbRunConfig.getSpringBootMainClass(), 1, (integer, integer2) -> integer + 1);
            metrics.add(MetricEventFactoryKt.newBooleanMetric((String)"config.active.profiles.set", (boolean)StringUtil.isNotEmpty((String)sbRunConfig.getActiveProfiles())));
            metrics.add(MetricEventFactoryKt.newBooleanMetric((String)"config.hide.banner", (boolean)sbRunConfig.isHideBanner()));
            metrics.add(MetricEventFactoryKt.newBooleanMetric((String)"config.debug.mode", (boolean)sbRunConfig.isDebugMode()));
            metrics.add(MetricEventFactoryKt.newBooleanMetric((String)"config.enable.launch.optimization", (boolean)sbRunConfig.isEnableLaunchOptimization()));
            metrics.add(MetricEventFactoryKt.newBooleanMetric((String)"config.enable.jmx.agent", (boolean)sbRunConfig.isEnableJmxAgent()));
            metrics.add(MetricEventFactoryKt.newMetric((String)"config.update.action.update.policy", (String)SpringBootRunFeatureUsagesCollector.getUpdatePolicyDescriptor(sbRunConfig.getUpdateActionUpdatePolicy())));
            metrics.add(MetricEventFactoryKt.newMetric((String)"config.frame.deactivation.update.policy", (String)SpringBootRunFeatureUsagesCollector.getUpdatePolicyDescriptor(sbRunConfig.getFrameDeactivationUpdatePolicy())));
            List<SpringBootAdditionalParameter> parameters = sbRunConfig.getAdditionalParameters();
            int additionalParamsSize = parameters.size();
            metrics.add(MetricEventFactoryKt.newMetric((String)"config.additional.params.total", (FeatureUsageData)new FeatureUsageData().addData("count", additionalParamsSize).addData("count_group", StatisticsUtil.INSTANCE.getCountingStepName(additionalParamsSize, steps))));
            if (additionalParamsSize > 0) {
                long enabledParams = parameters.stream().filter(SpringBootAdditionalParameter::isEnabled).count();
                long disabledParams = (long)parameters.size() - enabledParams;
                metrics.add(MetricEventFactoryKt.newMetric((String)"config.additional.params.enabled", (FeatureUsageData)new FeatureUsageData().addData("params", enabledParams)));
                metrics.add(MetricEventFactoryKt.newMetric((String)"config.additional.params.disabled", (FeatureUsageData)new FeatureUsageData().addData("params", disabledParams)));
            }
            SpringBootRunFeatureUsagesCollector.addConfigEnvironmentMetrics(metrics, sbRunConfig);
            metrics.add(MetricEventFactoryKt.newBooleanMetric((String)"config.log.files", (!sbRunConfig.getLogFiles().isEmpty() ? 1 : 0) != 0));
        }
        boolean showRunDashboard = RunDashboardManager.getInstance((Project)project).getTypes().contains(SpringBootApplicationConfigurationTypeBase.getInstance().getId());
        metrics.add(MetricEventFactoryKt.newBooleanMetric((String)"run.dashboard", (boolean)showRunDashboard));
        for (Integer integer3 : mainClassCounter.values()) {
            metrics.add(MetricEventFactoryKt.newMetric((String)"configs.main.class", (FeatureUsageData)new FeatureUsageData().addData("count", integer3.intValue()).addData("count_group", StatisticsUtil.INSTANCE.getCountingStepName(integer3.intValue(), steps))));
        }
        metrics.add(MetricEventFactoryKt.newBooleanMetric((String)"endpoints.beans.diagram", (((LiveBeansPanelContent[])LiveBeansPanelContent.EP_NAME.getExtensions()).length != 0 && BeansEndpointTabSettings.getInstance(project).isDiagramMode() ? 1 : 0) != 0));
        LinkedHashSet<MetricEvent> linkedHashSet = metrics;
        if (linkedHashSet == null) {
            SpringBootRunFeatureUsagesCollector.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    private static String getUpdatePolicyDescriptor(@Nullable SpringBootApplicationUpdatePolicy policy) {
        if (policy == null) {
            return "Nothing";
        }
        return PluginInfoDetectorKt.getPluginInfo(policy.getClass()).isDevelopedByJetBrains() ? policy.getId() : "third.party";
    }

    private static void addConfigEnvironmentMetrics(Set<MetricEvent> metrics, SpringBootApplicationRunConfiguration sbRunConfig) {
        metrics.add(MetricEventFactoryKt.newBooleanMetric((String)"config.vm.options", (boolean)StringUtil.isNotEmpty((String)sbRunConfig.getVMParameters())));
        metrics.add(MetricEventFactoryKt.newBooleanMetric((String)"config.program.arguments", (boolean)StringUtil.isNotEmpty((String)sbRunConfig.getProgramParameters())));
        metrics.add(MetricEventFactoryKt.newBooleanMetric((String)"config.working.directory", (boolean)StringUtil.isNotEmpty((String)sbRunConfig.getWorkingDirectory())));
        metrics.add(MetricEventFactoryKt.newBooleanMetric((String)"config.environment.variables", (!sbRunConfig.getEnvs().isEmpty() ? 1 : 0) != 0));
        metrics.add(MetricEventFactoryKt.newBooleanMetric((String)"config.include.provided.scope", (boolean)sbRunConfig.isIncludeProvidedScope()));
        metrics.add(MetricEventFactoryKt.newBooleanMetric((String)"config.alternative.jre.path.enabled", (boolean)sbRunConfig.isAlternativeJrePathEnabled()));
        ShortenCommandLine shortenCommandLine = sbRunConfig.getShortenCommandLine();
        if (shortenCommandLine == null) {
            shortenCommandLine = ShortenCommandLine.NONE;
        }
        metrics.add(MetricEventFactoryKt.newMetric((String)"config.shorten.command.line", (String)shortenCommandLine.name()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/statistics/SpringBootRunFeatureUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/statistics/SpringBootRunFeatureUsagesCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

