/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.Endpoint;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.tabs.EndpointTab;
import com.intellij.spring.boot.run.lifecycle.tabs.SpringBootEndpointsTabSettings;
import com.intellij.spring.boot.run.statistics.SpringBootRunUsageTriggerCollector;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.JBTabsPaneImpl;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationEndpointsTab
extends AdditionalTabComponent {
    private final SpringBootApplicationRunConfigurationBase myRunConfiguration;
    private final ProcessHandler myProcessHandler;
    private final TabbedPaneWrapper myWrapper;
    private final List<EndpointTab<?>> myTabs;
    private DefaultActionGroup myActionGroup;
    private final Map<EndpointTab<?>, ActionGroup> myTabActions;
    private final LiveProperty.LivePropertyListener myReadyStateListener;
    private SpringBootApplicationLifecycleManager.InfoListener myInfoListener;

    public SpringBootApplicationEndpointsTab(@NotNull SpringBootApplicationRunConfigurationBase runConfiguration, @NotNull ProcessHandler processHandler) {
        if (runConfiguration == null) {
            SpringBootApplicationEndpointsTab.$$$reportNull$$$0(0);
        }
        if (processHandler == null) {
            SpringBootApplicationEndpointsTab.$$$reportNull$$$0(1);
        }
        super((LayoutManager)new BorderLayout());
        this.myTabs = new ArrayList();
        this.myTabActions = new HashMap();
        this.myRunConfiguration = runConfiguration;
        this.myProcessHandler = processHandler;
        this.myWrapper = new TabbedPaneWrapper((Disposable)this){

            protected TabbedPane createTabbedPane(int tabPlacement) {
                TabbedPane tabbedPane = super.createTabbedPane(tabPlacement);
                if (tabbedPane instanceof JBTabsPaneImpl) {
                    JBTabs tabs = ((JBTabsPaneImpl)tabbedPane).getTabs();
                    DefaultActionGroup popupGroup = new DefaultActionGroup();
                    popupGroup.add((AnAction)new FocusOnStartAction(tabs));
                    tabs.setPopupGroup((ActionGroup)popupGroup, "unknown", true);
                }
                return tabbedPane;
            }
        };
        this.add(this.myWrapper.getComponent(), "Center");
        for (Endpoint endpoint : (Endpoint[])Endpoint.EP_NAME.getExtensions()) {
            ContainerUtil.addIfNotNull(this.myTabs, endpoint.createEndpointTab(runConfiguration, processHandler));
        }
        Endpoint.EP_NAME.addExtensionPointListener(new ExtensionPointListener<Endpoint<?>>(){

            public void extensionRemoved(@NotNull Endpoint<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                for (int i = 0; i < SpringBootApplicationEndpointsTab.this.myTabs.size(); ++i) {
                    EndpointTab<?> tab = SpringBootApplicationEndpointsTab.this.myTabs.get(i);
                    if (!tab.getId().equals(extension.getId())) continue;
                    SpringBootApplicationEndpointsTab.this.myWrapper.removeTabAt(i);
                    SpringBootApplicationEndpointsTab.this.myTabs.remove(tab);
                    if (SpringBootApplicationEndpointsTab.this.myActionGroup != null) {
                        SpringBootApplicationEndpointsTab.this.myActionGroup.remove((AnAction)SpringBootApplicationEndpointsTab.this.myTabActions.remove(tab));
                    }
                    Disposer.dispose(tab);
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/boot/run/lifecycle/tabs/SpringBootApplicationEndpointsTab$2";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        ApplicationManager.getApplication().executeOnPooledThread(() -> DumbService.getInstance((Project)this.getProject()).runReadActionInSmartMode(() -> this.myTabs.forEach(EndpointTab::checkAvailability)));
        String selectedTabId = SpringBootEndpointsTabSettings.getInstance(this.getProject()).getSelectedTab();
        for (EndpointTab<?> tab : this.myTabs) {
            this.myWrapper.addTab(tab.getTitle(), tab.getIcon(), tab.getComponent(), null);
            int tabIndex = this.myWrapper.getTabCount() - 1;
            tab.setTooltipChangeListener(tooltip -> this.myWrapper.setToolTipTextAt(tabIndex, tooltip));
            if (tab.getId().equals(selectedTabId)) {
                this.myWrapper.setSelectedIndex(tabIndex);
            }
            Disposer.register((Disposable)this, tab);
        }
        this.myReadyStateListener = new LiveProperty.LivePropertyListener(){

            @Override
            public void propertyChanged() {
            }

            @Override
            public void computationFailed(@NotNull Exception e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                for (EndpointTab<?> tab : SpringBootApplicationEndpointsTab.this.myTabs) {
                    tab.showMessage(SpringBootRunBundle.message("spring.boot.application.endpoints.application.ready.check.failed", e.getLocalizedMessage()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/run/lifecycle/tabs/SpringBootApplicationEndpointsTab$3", "computationFailed"));
            }
        };
        SpringBootApplicationInfo info = this.getInfo();
        if (info != null) {
            info.getReadyState().addPropertyListener(this.myReadyStateListener);
            for (EndpointTab<?> tab : this.myTabs) {
                tab.initPropertyListeners(info);
            }
        } else {
            this.myInfoListener = new SpringBootApplicationLifecycleManager.InfoListener(){

                @Override
                public void infoAdded(@NotNull ProcessHandler handler, @NotNull SpringBootApplicationInfo info) {
                    if (handler == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (info == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    if (SpringBootApplicationEndpointsTab.this.myProcessHandler.equals(handler)) {
                        info.getReadyState().addPropertyListener(SpringBootApplicationEndpointsTab.this.myReadyStateListener);
                        for (EndpointTab<?> tab : SpringBootApplicationEndpointsTab.this.myTabs) {
                            tab.initPropertyListeners(info);
                        }
                    }
                }

                @Override
                public void infoRemoved(@NotNull ProcessHandler handler, @NotNull SpringBootApplicationInfo info) {
                    if (handler == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    if (info == null) {
                        4.$$$reportNull$$$0(3);
                    }
                    if (SpringBootApplicationEndpointsTab.this.myProcessHandler.equals(handler)) {
                        SpringBootApplicationLifecycleManager.getInstance(SpringBootApplicationEndpointsTab.this.getProject()).removeInfoListener(this);
                        SpringBootApplicationEndpointsTab.this.myTabs.forEach(EndpointTab::infoRemoved);
                        AppUIUtil.invokeLaterIfProjectAlive((Project)SpringBootApplicationEndpointsTab.this.getProject(), () -> {
                            for (int i = 0; i < SpringBootApplicationEndpointsTab.this.myWrapper.getTabCount(); ++i) {
                                SpringBootApplicationEndpointsTab.this.myWrapper.setIconAt(i, IconLoader.getDisabledIcon((Icon)SpringBootApplicationEndpointsTab.this.myTabs.get(i).getIcon()));
                            }
                        });
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "handler";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "info";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/SpringBootApplicationEndpointsTab$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "infoAdded";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "infoRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            SpringBootApplicationLifecycleManager.getInstance(this.getProject()).addInfoListener(this.myInfoListener);
        }
        this.myWrapper.getComponent().putClientProperty("DataProvider", dataId -> {
            EndpointTab<?> selectedTab = this.getSelectedTab();
            if (selectedTab != null) {
                return selectedTab.getData(dataId);
            }
            return null;
        });
        this.myWrapper.addChangeListener(new ChangeListener(){
            private EndpointTab<?> mySelectedTab;
            {
                this.mySelectedTab = SpringBootApplicationEndpointsTab.this.getSelectedTab();
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                EndpointTab<?> oldSelectedTab = this.mySelectedTab;
                this.mySelectedTab = SpringBootApplicationEndpointsTab.this.getSelectedTab();
                if (oldSelectedTab != this.mySelectedTab && this.mySelectedTab != null) {
                    SpringBootRunUsageTriggerCollector.logActuatorTabSelected(SpringBootApplicationEndpointsTab.this.getProject(), this.mySelectedTab.getEndpoint().getClass());
                }
            }
        });
    }

    public void setSelected() {
        EndpointTab<?> selectedTab = this.getSelectedTab();
        if (selectedTab != null) {
            SpringBootRunUsageTriggerCollector.logActuatorTabSelected(this.getProject(), selectedTab.getEndpoint().getClass());
        }
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myWrapper.getComponent();
    }

    @Nullable
    public ActionGroup getToolbarActions() {
        this.myActionGroup = new DefaultActionGroup();
        this.myActionGroup.add(new AnAction(){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                Presentation presentation = e.getPresentation();
                presentation.setText(SpringBootRunBundle.messagePointer("spring.boot.application.endpoints.refresh.action.name", new Object[0]));
                presentation.setDescription(SpringBootRunBundle.messagePointer("spring.boot.application.endpoints.refresh.action.description", new Object[0]));
                presentation.setIcon(AllIcons.Actions.Refresh);
                SpringBootApplicationInfo info = SpringBootApplicationEndpointsTab.this.getInfo();
                EndpointTab<?> selectedTab = SpringBootApplicationEndpointsTab.this.getSelectedTab();
                if (info != null && !Boolean.FALSE.equals(info.getReadyState().getValue()) && selectedTab != null) {
                    selectedTab.updateRefreshAction(e, info);
                } else {
                    presentation.setEnabled(false);
                }
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                SpringBootApplicationInfo info;
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                if ((info = SpringBootApplicationEndpointsTab.this.getInfo()) != null && info.getReadyState().getValue() == null) {
                    info.getReadyState().compute();
                    SpringBootApplicationEndpointsTab.this.myTabs.forEach(EndpointTab::showLoading);
                    return;
                }
                SpringBootApplicationEndpointsTab.this.myTabs.get(SpringBootApplicationEndpointsTab.this.myWrapper.getSelectedIndex()).refresh();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/SpringBootApplicationEndpointsTab$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myActionGroup.addSeparator();
        for (final EndpointTab<?> tab : this.myTabs) {
            DefaultActionGroup tabGroup = new DefaultActionGroup(){

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    e.getPresentation().setVisible(tab == SpringBootApplicationEndpointsTab.this.getSelectedTab());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/run/lifecycle/tabs/SpringBootApplicationEndpointsTab$7", "update"));
                }
            };
            tabGroup.addAll(tab.getToolbarActions());
            this.myActionGroup.add((AnAction)tabGroup);
            this.myTabActions.put(tab, (ActionGroup)tabGroup);
        }
        return this.myActionGroup;
    }

    @Nullable
    public JComponent getSearchComponent() {
        return null;
    }

    @Nullable
    public String getToolbarPlace() {
        return "unknown";
    }

    @Nullable
    public JComponent getToolbarContextComponent() {
        return this.myWrapper.getComponent();
    }

    public boolean isContentBuiltIn() {
        return false;
    }

    @NotNull
    public String getTabTitle() {
        String string = SpringBootRunBundle.message("spring.boot.application.endpoints.tab.title", new Object[0]);
        if (string == null) {
            SpringBootApplicationEndpointsTab.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void dispose() {
        SpringBootApplicationInfo info;
        if (this.myInfoListener != null) {
            SpringBootApplicationLifecycleManager.getInstance(this.getProject()).removeInfoListener(this.myInfoListener);
        }
        if ((info = this.getInfo()) != null) {
            info.getReadyState().removePropertyListener(this.myReadyStateListener);
        }
    }

    @NotNull
    private Project getProject() {
        Project project = this.myRunConfiguration.getProject();
        if (project == null) {
            SpringBootApplicationEndpointsTab.$$$reportNull$$$0(3);
        }
        return project;
    }

    @Nullable
    private EndpointTab<?> getSelectedTab() {
        return this.myWrapper.getSelectedIndex() >= 0 ? this.myTabs.get(this.myWrapper.getSelectedIndex()) : null;
    }

    @Nullable
    private SpringBootApplicationInfo getInfo() {
        Project project = this.getProject();
        if (project.isDisposed()) {
            return null;
        }
        return SpringBootApplicationLifecycleManager.getInstance(project).getSpringBootApplicationInfo(this.myProcessHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/tabs/SpringBootApplicationEndpointsTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/SpringBootApplicationEndpointsTab";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FocusOnStartAction
    extends AnAction
    implements Toggleable {
        private final JBTabs myTabs;

        FocusOnStartAction(JBTabs tabs) {
            super(ActionsBundle.actionText((String)"Runner.FocusOnStartup"), ActionsBundle.actionDescription((String)"Runner.FocusOnStartup"), null);
            this.myTabs = tabs;
        }

        public void update(@NotNull AnActionEvent e) {
            EndpointTab<?> currentTab;
            if (e == null) {
                FocusOnStartAction.$$$reportNull$$$0(0);
            }
            boolean visible = (currentTab = this.getCurrentTab()) != null;
            e.getPresentation().setVisible(visible);
            if (visible) {
                Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)this.isToFocus(currentTab));
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            EndpointTab<?> currentTab;
            if (e == null) {
                FocusOnStartAction.$$$reportNull$$$0(1);
            }
            if ((currentTab = this.getCurrentTab()) == null) {
                return;
            }
            boolean isToFocus = this.isToFocus(currentTab);
            SpringBootEndpointsTabSettings.getInstance(SpringBootApplicationEndpointsTab.this.getProject()).setSelectedTab(isToFocus ? null : currentTab.getId());
        }

        private boolean isToFocus(@NotNull EndpointTab<?> tab) {
            if (tab == null) {
                FocusOnStartAction.$$$reportNull$$$0(2);
            }
            return tab.getId().equals(SpringBootEndpointsTabSettings.getInstance(SpringBootApplicationEndpointsTab.this.getProject()).getSelectedTab());
        }

        @Nullable
        private EndpointTab<?> getCurrentTab() {
            int index;
            TabInfo info = this.myTabs.getTargetInfo();
            int n = index = info == null ? SpringBootApplicationEndpointsTab.this.myWrapper.getSelectedIndex() : this.myTabs.getIndexOf(info);
            if (index >= 0) {
                return SpringBootApplicationEndpointsTab.this.myTabs.get(index);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tab";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/SpringBootApplicationEndpointsTab$FocusOnStartAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isToFocus";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

