/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.tab;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBeansModel;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveContext;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveResource;
import com.intellij.spring.boot.run.lifecycle.beans.tab.BeansEndpointTabSettings;
import com.intellij.spring.boot.run.lifecycle.beans.tab.LifecycleFinderRecursivePanel;
import com.intellij.spring.boot.run.lifecycle.beans.tab.LiveBeansPanel;
import com.intellij.spring.boot.run.statistics.SpringBootRunUsageTriggerCollector;
import com.intellij.ui.FinderRecursivePanel;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveResourcesPanel
extends LifecycleFinderRecursivePanel<LiveResourceItem> {
    private static final String LIVE_RESOURCES_PANEL_GROUP_ID = "LiveResourcesPanel";

    LiveResourcesPanel(@NotNull Project project, @NotNull SpringBootApplicationRunConfigurationBase runConfiguration, @NotNull ProcessHandler processHandler) {
        if (project == null) {
            LiveResourcesPanel.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            LiveResourcesPanel.$$$reportNull$$$0(1);
        }
        if (processHandler == null) {
            LiveResourcesPanel.$$$reportNull$$$0(2);
        }
        this(project, null, LIVE_RESOURCES_PANEL_GROUP_ID, runConfiguration, processHandler);
    }

    LiveResourcesPanel(@NotNull Project project, @Nullable FinderRecursivePanel parent, @Nullable String groupId, @NotNull SpringBootApplicationRunConfigurationBase runConfiguration, @NotNull ProcessHandler processHandler) {
        if (project == null) {
            LiveResourcesPanel.$$$reportNull$$$0(3);
        }
        if (runConfiguration == null) {
            LiveResourcesPanel.$$$reportNull$$$0(4);
        }
        if (processHandler == null) {
            LiveResourcesPanel.$$$reportNull$$$0(5);
        }
        super(project, parent, groupId, runConfiguration, processHandler);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected List<LiveResourceItem> getListItems() {
        List<LiveResource> resources;
        block8: {
            FinderRecursivePanel parent = this.getParentPanel();
            if (parent != null) {
                if (parent.getSelectedValue() instanceof LiveContext) {
                    resources = ((LiveContext)parent.getSelectedValue()).getResources();
                    break block8;
                } else {
                    List<LiveResourceItem> list = Collections.emptyList();
                    if (list == null) {
                        LiveResourcesPanel.$$$reportNull$$$0(6);
                    }
                    return list;
                }
            }
            LiveBeansModel model = this.getModel();
            if (model == null) {
                List<LiveResourceItem> list = Collections.emptyList();
                if (list == null) {
                    LiveResourcesPanel.$$$reportNull$$$0(7);
                }
                return list;
            }
            resources = model.getResources();
        }
        SpringBootApplicationRunConfigurationBase runConfiguration = this.getRunConfiguration();
        Module module = runConfiguration.getModule();
        PsiClass mainClass = runConfiguration.getMainClass();
        GlobalSearchScope searchScope = this.getRunConfiguration().getSearchScope();
        Stream<LiveResourceItem> resourcesStream = resources.stream().map(resource -> new LiveResourceItem(this.getProject(), (LiveResource)resource, module, mainClass, searchScope));
        if (!BeansEndpointTabSettings.getInstance(this.getProject()).isShowLibraryBeans()) {
            resourcesStream = resourcesStream.filter(item -> {
                VirtualFile virtualFile = this.getContainingFile((LiveResourceItem)item);
                if (virtualFile == null) {
                    return false;
                }
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
                return !fileIndex.isInLibrary(virtualFile);
            });
        }
        List<LiveResourceItem> list = resourcesStream.sorted(Comparator.comparing(item -> item.getResource().getDisplayName(), NaturalComparator.INSTANCE)).collect(Collectors.toList());
        if (list == null) {
            LiveResourcesPanel.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    protected String getItemText(@NotNull LiveResourceItem item) {
        if (item == null) {
            LiveResourcesPanel.$$$reportNull$$$0(9);
        }
        String string = item.getResource().getDisplayName();
        if (string == null) {
            LiveResourcesPanel.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected boolean hasChildren(@NotNull LiveResourceItem item) {
        if (item == null) {
            LiveResourcesPanel.$$$reportNull$$$0(11);
        }
        return true;
    }

    @Nullable
    protected Icon getItemIcon(@NotNull LiveResourceItem item) {
        Navigatable navigatable;
        if (item == null) {
            LiveResourcesPanel.$$$reportNull$$$0(12);
        }
        if ((navigatable = item.getNavigatable()) instanceof PsiFile) {
            return ((PsiFile)navigatable).getIcon(0);
        }
        Icon icon = item.getResource().getIcon();
        return icon == null ? SpringApiIcons.SpringJavaConfig : icon;
    }

    @Nullable
    protected JComponent createRightComponent(@NotNull LiveResourceItem item) {
        if (item == null) {
            LiveResourcesPanel.$$$reportNull$$$0(13);
        }
        SpringBootRunUsageTriggerCollector.logRuntimeResourceSelected(this.getProject());
        return new LiveBeansPanel(this.getProject(), this, this.getGroupId(), this.getRunConfiguration(), this.getProcessHandler());
    }

    @Nullable
    protected String getItemTooltipText(@NotNull LiveResourceItem item) {
        if (item == null) {
            LiveResourcesPanel.$$$reportNull$$$0(14);
        }
        if (item.getResource().hasDescription()) {
            return item.getResource().getDescription();
        }
        return item.getResource().getDisplayName();
    }

    @Nullable
    protected VirtualFile getContainingFile(@NotNull LiveResourceItem item) {
        Navigatable navigatable;
        if (item == null) {
            LiveResourcesPanel.$$$reportNull$$$0(15);
        }
        if (!((navigatable = item.getNavigatable()) instanceof PsiElement)) {
            return null;
        }
        PsiElement psiElement = (PsiElement)navigatable;
        if (psiElement.isValid() && psiElement.getContainingFile() != null) {
            return psiElement.getContainingFile().getVirtualFile();
        }
        return null;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        LiveResourceItem selectedValue;
        if (dataId == null) {
            LiveResourcesPanel.$$$reportNull$$$0(16);
        }
        if ((selectedValue = (LiveResourceItem)this.getSelectedValue()) != null) {
            PsiElement psiElement;
            Navigatable navigatable = selectedValue.getNavigatable();
            if (CommonDataKeys.NAVIGATABLE.is(dataId) || CommonDataKeys.PSI_ELEMENT.is(dataId) && navigatable instanceof PsiElement) {
                return navigatable;
            }
            if (CommonDataKeys.PSI_FILE.is(dataId) && navigatable instanceof PsiElement && (psiElement = (PsiElement)navigatable).isValid()) {
                return psiElement.getContainingFile();
            }
        }
        return super.getData(dataId);
    }

    @Override
    protected boolean doUpdateItem(@NotNull LiveResourceItem item) {
        if (item == null) {
            LiveResourcesPanel.$$$reportNull$$$0(17);
        }
        SpringBootApplicationRunConfigurationBase runConfiguration = this.getRunConfiguration();
        Module module = runConfiguration.getModule();
        PsiClass mainClass = runConfiguration.getMainClass();
        GlobalSearchScope searchScope = this.getRunConfiguration().getSearchScope();
        return item.updateItem(module, mainClass, searchScope);
    }

    @Override
    @NlsContexts.HintText
    protected String getEditActionHintMessage(@NotNull LiveResourceItem item) {
        if (item == null) {
            LiveResourcesPanel.$$$reportNull$$$0(18);
        }
        return SpringBootRunBundle.message("spring.boot.application.endpoints.config.file.not.found", new Object[0]);
    }

    @Override
    protected boolean performEditAction() {
        if (this.getSelectedValue() != null) {
            SpringBootRunUsageTriggerCollector.logEditRuntimeResource(this.getProject(), "ToolwindowContent");
        }
        return super.performEditAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveResourcesPanel";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveResourcesPanel";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getItemText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasChildren";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createRightComponent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getItemTooltipText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateItem";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getEditActionHintMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LiveResourceItem {
        @NotNull
        private final Project myProject;
        @NotNull
        private final LiveResource myResource;
        @Nullable
        private Navigatable myNavigatable;

        LiveResourceItem(@NotNull Project project, @NotNull LiveResource resource, @Nullable Module module, @Nullable PsiClass mainClass, @NotNull GlobalSearchScope searchScope) {
            if (project == null) {
                LiveResourceItem.$$$reportNull$$$0(0);
            }
            if (resource == null) {
                LiveResourceItem.$$$reportNull$$$0(1);
            }
            if (searchScope == null) {
                LiveResourceItem.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myResource = resource;
            this.updateItem(module, mainClass, searchScope);
        }

        @NotNull
        public LiveResource getResource() {
            LiveResource liveResource = this.myResource;
            if (liveResource == null) {
                LiveResourceItem.$$$reportNull$$$0(3);
            }
            return liveResource;
        }

        @Nullable
        public Navigatable getNavigatable() {
            return DumbService.isDumb((Project)this.myProject) ? null : this.myNavigatable;
        }

        public boolean updateItem(@Nullable Module module, @Nullable PsiClass mainClass, @NotNull GlobalSearchScope searchScope) {
            Navigatable navigatable;
            if (searchScope == null) {
                LiveResourceItem.$$$reportNull$$$0(4);
            }
            boolean changed = !Comparing.equal((Object)this.myNavigatable, (Object)(navigatable = this.myResource.findResourceNavigatable(this.myProject, module, (PsiElement)mainClass, searchScope)));
            this.myNavigatable = navigatable;
            return changed;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof LiveResourceItem) {
                return this.myResource.equals(((LiveResourceItem)obj).myResource);
            }
            return false;
        }

        public int hashCode() {
            return this.myResource.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resource";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchScope";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveResourcesPanel$LiveResourceItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveResourcesPanel$LiveResourceItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "updateItem";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

