/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.tab;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.Endpoint;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBeansModel;
import com.intellij.spring.boot.run.lifecycle.beans.tab.BeansEndpointTabSettings;
import com.intellij.spring.boot.run.lifecycle.beans.tab.LifecycleFinderRecursivePanel;
import com.intellij.spring.boot.run.lifecycle.beans.tab.LiveBeansPanel;
import com.intellij.spring.boot.run.lifecycle.beans.tab.LiveBeansPanelContent;
import com.intellij.spring.boot.run.lifecycle.beans.tab.LiveContextsPanel;
import com.intellij.spring.boot.run.lifecycle.beans.tab.LiveResourcesPanel;
import com.intellij.spring.boot.run.lifecycle.tabs.EndpointTab;
import com.intellij.spring.boot.run.lifecycle.tabs.SpringBootEndpointsTabSettings;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.LayeredIcon;
import icons.SpringBootApiIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveBeansTab
extends EndpointTab<LiveBeansModel> {
    private static final String BEANS_MODE = "BEANS_MODE";
    private static final String BEANS_FULL = "BEANS_FULL";
    private static final String BEANS_UPDATE_DETAILS = "BEANS_UPDATE_DETAILS";
    private static final String BEANS_CONTENT = "BEANS_CONTENT";
    private final JComponent myWrapper;
    private final SimpleToolWindowPanel myMainPanel;
    private LifecycleFinderRecursivePanel myBeansPanel;
    private JComponent myDiagramPanel;
    private final DefaultActionGroup myDiagramActionGroup;
    private final UserDataHolder myDiagramDataHolder;
    private volatile boolean myNeedUpdateAfterRefresh;
    private final BeansEndpointTabSettings mySettings;

    public LiveBeansTab(@NotNull Endpoint<LiveBeansModel> endpoint, @NotNull SpringBootApplicationRunConfigurationBase runConfiguration, @NotNull ProcessHandler processHandler) {
        if (endpoint == null) {
            LiveBeansTab.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            LiveBeansTab.$$$reportNull$$$0(1);
        }
        if (processHandler == null) {
            LiveBeansTab.$$$reportNull$$$0(2);
        }
        super(endpoint, runConfiguration, processHandler);
        this.myMainPanel = new SimpleToolWindowPanel(false, true);
        this.myDiagramDataHolder = new UserDataHolderBase();
        this.mySettings = BeansEndpointTabSettings.getInstance(this.getProject());
        this.myDiagramActionGroup = new DefaultActionGroup(){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                e.getPresentation().setVisible(LiveBeansTab.this.isDiagramMode() && !DumbService.isDumb((Project)LiveBeansTab.this.getProject()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveBeansTab$1", "update"));
            }
        };
        this.refreshContentPanel();
        this.myWrapper = DumbService.getInstance((Project)this.getProject()).wrapGently((JComponent)this.myMainPanel, (Disposable)this);
        this.getProject().getMessageBus().connect((Disposable)this).subscribe(SpringBootEndpointsTabSettings.TOPIC, (Object)new SpringBootEndpointsTabSettings.Listener(){

            @Override
            public void settingsChanged(@NotNull String changeType) {
                if (changeType == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (changeType.equals(LiveBeansTab.BEANS_MODE)) {
                    LiveBeansTab.this.performModeUpdate();
                } else if (changeType.equals(LiveBeansTab.BEANS_FULL)) {
                    LiveBeansTab.this.performFullUpdate();
                } else if (changeType.equals(LiveBeansTab.BEANS_UPDATE_DETAILS)) {
                    LiveBeansTab.this.performDetailsUpdate();
                } else if (changeType.equals(LiveBeansTab.BEANS_CONTENT)) {
                    LiveBeansTab.this.updateContent();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeType", "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveBeansTab$2", "settingsChanged"));
            }
        });
    }

    @Override
    public String getTitle() {
        return SpringBootRunBundle.message("spring.boot.application.endpoints.beans.tab.title", new Object[0]);
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = SpringApiIcons.SpringBean;
        if (icon == null) {
            LiveBeansTab.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @Override
    @NotNull
    protected List<AnAction> getToolbarActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        if (((LiveBeansPanelContent[])LiveBeansPanelContent.EP_NAME.getExtensions()).length != 0) {
            actions.add((AnAction)new EndpointTab.EndpointToggleAction(SpringBootRunBundle.message("spring.boot.application.endpoints.diagram.mode.action.name", new Object[0]), null, (Icon)new LayeredIcon(new Icon[]{AllIcons.FileTypes.Diagram, SpringBootApiIcons.SpringBoot_Overlay})){

                public boolean isSelected(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return LiveBeansTab.this.mySettings.isDiagramMode();
                }

                public void setSelected(@NotNull AnActionEvent e, boolean state) {
                    if (e == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    LiveBeansTab.this.mySettings.setDiagramMode(state);
                    SpringBootEndpointsTabSettings.getInstance(LiveBeansTab.this.getProject()).fireSettingsChanged(LiveBeansTab.BEANS_MODE);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveBeansTab$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSelected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setSelected";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            actions.add((AnAction)Separator.getInstance());
            actions.add((AnAction)this.myDiagramActionGroup);
            actions.add((AnAction)Separator.getInstance());
        }
        actions.add((AnAction)new LiveBeansPanelToggleAction(SpringApiBundle.message((String)"spring.beans.view.show.library.beans.title", (Object[])new Object[0]), null, AllIcons.Nodes.PpLib){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                return LiveBeansTab.this.mySettings.isShowLibraryBeans();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                LiveBeansTab.this.mySettings.setShowLibraryBeans(state);
                SpringBootEndpointsTabSettings.getInstance(LiveBeansTab.this.getProject()).fireSettingsChanged(LiveBeansTab.BEANS_CONTENT);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveBeansTab$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        actions.add((AnAction)Separator.getInstance());
        actions.add((AnAction)new LiveBeansPanelToggleAction(SpringBootRunBundle.message("spring.boot.application.endpoints.show.context.action.name", new Object[0]), null, SpringApiIcons.FileSet){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                return LiveBeansTab.this.mySettings.isShowContexts();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                LiveBeansTab.this.mySettings.setShowContexts(state);
                SpringBootEndpointsTabSettings.getInstance(LiveBeansTab.this.getProject()).fireSettingsChanged(LiveBeansTab.BEANS_FULL);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveBeansTab$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        actions.add((AnAction)new LiveBeansPanelToggleAction(SpringApiBundle.message((String)"spring.beans.view.show.configuration.files", (Object[])new Object[0]), null, SpringApiIcons.SpringConfig){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                return LiveBeansTab.this.mySettings.isShowFiles();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                LiveBeansTab.this.mySettings.setShowFiles(state);
                SpringBootEndpointsTabSettings.getInstance(LiveBeansTab.this.getProject()).fireSettingsChanged(LiveBeansTab.BEANS_FULL);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveBeansTab$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        actions.add((AnAction)Separator.getInstance());
        actions.add((AnAction)new LiveBeansPanelToggleAction(SpringApiBundle.message((String)"spring.beans.view.show.bean.documentation.title", (Object[])new Object[0]), null, AllIcons.Toolwindows.Documentation){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                return LiveBeansTab.this.mySettings.isShowDoc();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    7.$$$reportNull$$$0(1);
                }
                LiveBeansTab.this.mySettings.setShowDoc(state);
                SpringBootEndpointsTabSettings.getInstance(LiveBeansTab.this.getProject()).fireSettingsChanged(LiveBeansTab.BEANS_UPDATE_DETAILS);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveBeansTab$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (((LiveBeansPanelContent[])LiveBeansPanelContent.EP_NAME.getExtensions()).length != 0) {
            actions.add((AnAction)new LiveBeansPanelToggleAction(SpringApiBundle.message((String)"spring.beans.view.show.bean.graph.title", (Object[])new Object[0]), null, AllIcons.FileTypes.Diagram){

                public boolean isSelected(@NotNull AnActionEvent e) {
                    if (e == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    return LiveBeansTab.this.mySettings.isShowLiveBeansGraph();
                }

                public void setSelected(@NotNull AnActionEvent e, boolean state) {
                    if (e == null) {
                        8.$$$reportNull$$$0(1);
                    }
                    LiveBeansTab.this.mySettings.setShowLiveBeansGraph(state);
                    SpringBootEndpointsTabSettings.getInstance(LiveBeansTab.this.getProject()).fireSettingsChanged(LiveBeansTab.BEANS_UPDATE_DETAILS);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveBeansTab$8";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSelected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setSelected";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        ArrayList<AnAction> arrayList = actions;
        if (arrayList == null) {
            LiveBeansTab.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected JComponent getEndpointComponent() {
        JComponent jComponent = this.myWrapper;
        if (jComponent == null) {
            LiveBeansTab.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    @Override
    protected void doUpdateComponent(LiveBeansModel value) {
        this.updateContent();
        this.myNeedUpdateAfterRefresh = true;
    }

    private void updateContent() {
        if (this.isDiagramMode()) {
            if (this.myDiagramPanel != null) {
                for (LiveBeansPanelContent content : (LiveBeansPanelContent[])LiveBeansPanelContent.EP_NAME.getExtensions()) {
                    content.update(this.myDiagramDataHolder);
                }
            }
        } else if (this.myBeansPanel != null) {
            this.myBeansPanel.updateComponent();
        }
    }

    @Override
    protected String getErrorMessage(String cause) {
        return SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.application.beans.snapshot", cause);
    }

    @Override
    public void checkAvailability() {
    }

    @Override
    public void updateRefreshAction(AnActionEvent e, @NotNull SpringBootApplicationInfo info) {
        if (info == null) {
            LiveBeansTab.$$$reportNull$$$0(6);
        }
        e.getPresentation().setEnabled(true);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        SpringBootApplicationInfo info;
        if (dataId == null) {
            LiveBeansTab.$$$reportNull$$$0(7);
        }
        if (this.isDiagramMode() && (info = this.getInfo()) != null && Boolean.TRUE.equals(info.getReadyState().getValue()) && this.getLiveProperty(info).getValue() != null && !this.isTabLoading()) {
            for (LiveBeansPanelContent content : (LiveBeansPanelContent[])LiveBeansPanelContent.EP_NAME.getExtensions()) {
                Object data = content.getData(this.myDiagramDataHolder, dataId);
                if (data == null) continue;
                return data;
            }
        }
        return super.getData(dataId);
    }

    private boolean isDiagramMode() {
        return ((LiveBeansPanelContent[])LiveBeansPanelContent.EP_NAME.getExtensions()).length != 0 && this.mySettings.isDiagramMode();
    }

    private void refreshContentPanel() {
        Object component;
        if (this.isDiagramMode()) {
            if (this.myDiagramPanel == null) {
                for (LiveBeansPanelContent content : (LiveBeansPanelContent[])LiveBeansPanelContent.EP_NAME.getExtensions()) {
                    this.myDiagramPanel = content.createComponent(this.getProject(), this.myDiagramDataHolder, this, () -> {
                        SpringBootApplicationInfo info = this.getInfo();
                        if (info == null) {
                            return Collections.emptyList();
                        }
                        LiveBeansModel liveBeansModel = (LiveBeansModel)this.getLiveProperty(info).getValue();
                        if (liveBeansModel == null) {
                            return Collections.emptyList();
                        }
                        return liveBeansModel.getBeans();
                    }, this.getRunConfiguration(), false);
                    this.myDiagramActionGroup.removeAll();
                    this.myDiagramActionGroup.add((AnAction)content.createToolbarActions(this.myDiagramDataHolder));
                }
            }
            component = this.myDiagramPanel;
        } else {
            if (this.myBeansPanel == null) {
                this.myBeansPanel = this.createRootBeansPanel();
                this.myBeansPanel.initPanel();
                Disposer.register((Disposable)this, (Disposable)this.myBeansPanel);
            }
            component = this.myBeansPanel;
        }
        this.myMainPanel.setContent(component);
        if (this.myNeedUpdateAfterRefresh) {
            this.updateContent();
            this.myNeedUpdateAfterRefresh = false;
        }
    }

    private LifecycleFinderRecursivePanel createRootBeansPanel() {
        if (this.mySettings.isShowContexts()) {
            return new LiveContextsPanel(this.getProject(), this.getRunConfiguration(), this.getProcessHandler());
        }
        if (this.mySettings.isShowFiles()) {
            return new LiveResourcesPanel(this.getProject(), this.getRunConfiguration(), this.getProcessHandler());
        }
        return new LiveBeansPanel(this.getProject(), this.getRunConfiguration(), this.getProcessHandler());
    }

    private void performModeUpdate() {
        ApplicationManager.getApplication().invokeLater(() -> this.refreshContentPanel(), ModalityState.NON_MODAL, o -> Disposer.isDisposed((Disposable)this));
    }

    private void performFullUpdate() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myBeansPanel == null) {
                return;
            }
            LifecycleFinderRecursivePanel oldPanel = this.myBeansPanel;
            Disposer.dispose((Disposable)oldPanel);
            this.myBeansPanel = null;
            this.refreshContentPanel();
        }, ModalityState.NON_MODAL, o -> Disposer.isDisposed((Disposable)this));
    }

    private void performDetailsUpdate() {
        if (this.myBeansPanel == null) {
            return;
        }
        LifecycleFinderRecursivePanel panel = this.myBeansPanel;
        while (true) {
            if (!(panel.getSecondComponent() instanceof FinderRecursivePanel)) break;
            panel = (FinderRecursivePanel)panel.getSecondComponent();
        }
        panel.updateRightComponent(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveBeansTab";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveBeansTab";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateRefreshAction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class LiveBeansPanelToggleAction
    extends EndpointTab.EndpointToggleAction {
        LiveBeansPanelToggleAction(@Nullable @NlsActions.ActionDescription String text, @Nullable String description, Icon icon) {
            super(LiveBeansTab.this, text, description, icon);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                LiveBeansPanelToggleAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setVisible(!LiveBeansTab.this.isDiagramMode());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveBeansTab$LiveBeansPanelToggleAction", "update"));
        }
    }
}

