/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.tab;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBeansModel;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveContext;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveResource;
import com.intellij.spring.boot.run.lifecycle.beans.tab.BeansEndpointTabSettings;
import com.intellij.spring.boot.run.lifecycle.beans.tab.LifecycleFinderRecursivePanel;
import com.intellij.spring.boot.run.lifecycle.beans.tab.LiveBeansPanelContent;
import com.intellij.spring.boot.run.lifecycle.beans.tab.LiveResourcesPanel;
import com.intellij.spring.boot.run.statistics.SpringBootRunUsageTriggerCollector;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.util.SmartList;
import com.intellij.xml.util.PsiElementPointer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveBeansPanel
extends LifecycleFinderRecursivePanel<LiveBeanItem> {
    private static final String LIVE_BEANS_PANEL_GROUP_ID = "LiveBeansPanel";
    private final NullableFactory<CommonSpringModel> myModelFactory;
    private final NavigateToBeanClassAction myNavigateAction;

    public LiveBeansPanel(@NotNull Project project, @NotNull SpringBootApplicationRunConfigurationBase runConfiguration, @NotNull ProcessHandler processHandler) {
        if (project == null) {
            LiveBeansPanel.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            LiveBeansPanel.$$$reportNull$$$0(1);
        }
        if (processHandler == null) {
            LiveBeansPanel.$$$reportNull$$$0(2);
        }
        this(project, null, LIVE_BEANS_PANEL_GROUP_ID, runConfiguration, processHandler);
    }

    public LiveBeansPanel(@NotNull Project project, @Nullable FinderRecursivePanel parent, @Nullable String groupId, @NotNull SpringBootApplicationRunConfigurationBase runConfiguration, @NotNull ProcessHandler processHandler) {
        if (project == null) {
            LiveBeansPanel.$$$reportNull$$$0(3);
        }
        if (runConfiguration == null) {
            LiveBeansPanel.$$$reportNull$$$0(4);
        }
        if (processHandler == null) {
            LiveBeansPanel.$$$reportNull$$$0(5);
        }
        super(project, parent, groupId, runConfiguration, processHandler);
        this.myModelFactory = () -> {
            Module module = this.getRunConfiguration().getModule();
            return module == null ? null : SpringManager.getInstance((Project)this.getProject()).getCombinedModel(module);
        };
        this.myNavigateAction = new NavigateToBeanClassAction();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected List<LiveBeanItem> getListItems() {
        SmartList resources;
        block10: {
            block11: {
                FinderRecursivePanel parent = this.getParentPanel();
                if (parent == null) break block11;
                if (parent.getSelectedValue() instanceof LiveContext) {
                    resources = ((LiveContext)parent.getSelectedValue()).getResources();
                    break block10;
                } else if (parent.getSelectedValue() instanceof LiveResourcesPanel.LiveResourceItem) {
                    resources = new SmartList((Object)((LiveResourcesPanel.LiveResourceItem)parent.getSelectedValue()).getResource());
                    break block10;
                } else {
                    List<LiveBeanItem> list = Collections.emptyList();
                    if (list == null) {
                        LiveBeansPanel.$$$reportNull$$$0(6);
                    }
                    return list;
                }
            }
            LiveBeansModel model = this.getModel();
            if (model == null) {
                List<LiveBeanItem> list = Collections.emptyList();
                if (list == null) {
                    LiveBeansPanel.$$$reportNull$$$0(7);
                }
                return list;
            }
            resources = model.getResources();
        }
        CommonSpringModel springModel = (CommonSpringModel)this.myModelFactory.create();
        SpringBootApplicationRunConfigurationBase runConfiguration = this.getRunConfiguration();
        Module module = runConfiguration.getModule();
        PsiClass mainClass = runConfiguration.getMainClass();
        GlobalSearchScope searchScope = runConfiguration.getSearchScope();
        boolean showLibraryBeans = BeansEndpointTabSettings.getInstance(this.getProject()).isShowLibraryBeans();
        ArrayList<LiveBeanItem> items = new ArrayList<LiveBeanItem>();
        for (LiveResource resource : resources) {
            ProjectFileIndex fileIndex;
            VirtualFile resourceFile;
            PsiElement resourceElement = resource.findResourceElement(this.getProject(), module, (PsiElement)mainClass, searchScope);
            if (!showLibraryBeans && resourceElement != null && resourceElement.isValid() && resourceElement.getContainingFile() != null && (resourceFile = resourceElement.getContainingFile().getVirtualFile()) != null && (fileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex()).isInLibrary(resourceFile)) continue;
            for (LiveBean liveBean : resource.getBeans()) {
                ProjectFileIndex fileIndex2;
                VirtualFile resourceFile2;
                PsiClass beanClass;
                LiveBeanItem item2 = new LiveBeanItem(this.getProject(), liveBean);
                item2.updateBeanClass(searchScope);
                if (!showLibraryBeans && !resource.hasDescription() && (beanClass = item2.getBeanClass()) != null && (resourceFile2 = beanClass.getContainingFile().getVirtualFile()) != null && (fileIndex2 = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex()).isInLibrary(resourceFile2)) continue;
                item2.updateBeanPointer(resourceElement, springModel);
                items.add(item2);
            }
        }
        items.sort(Comparator.comparing(item -> item.getBean().getName(), NaturalComparator.INSTANCE));
        ArrayList<LiveBeanItem> arrayList = items;
        if (arrayList == null) {
            LiveBeansPanel.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    protected String getItemText(@NotNull LiveBeanItem item) {
        if (item == null) {
            LiveBeansPanel.$$$reportNull$$$0(9);
        }
        String string = item.getBean().getName();
        if (string == null) {
            LiveBeansPanel.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected boolean hasChildren(@NotNull LiveBeanItem item) {
        if (item == null) {
            LiveBeansPanel.$$$reportNull$$$0(11);
        }
        return false;
    }

    @Nullable
    protected VirtualFile getContainingFile(@NotNull LiveBeanItem item) {
        PsiElement beanElement;
        if (item == null) {
            LiveBeansPanel.$$$reportNull$$$0(12);
        }
        if ((beanElement = item.getPointer().getPsiElement()) != null && beanElement.isValid() && beanElement.getContainingFile() != null) {
            return beanElement.getContainingFile().getVirtualFile();
        }
        return null;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        Object data;
        LiveBeanItem selectedValue;
        if (dataId == null) {
            LiveBeansPanel.$$$reportNull$$$0(13);
        }
        if ((selectedValue = (LiveBeanItem)this.getSelectedValue()) != null) {
            PsiElement element;
            if (CommonDataKeys.NAVIGATABLE.is(dataId) || CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return selectedValue.getPointer().getPsiElement();
            }
            if (CommonDataKeys.PSI_FILE.is(dataId) && (element = selectedValue.getPointer().getPsiElement()) != null) {
                return element.getContainingFile();
            }
        }
        if ((data = super.getData(dataId)) != null) {
            return data;
        }
        for (LiveBeansPanelContent content : (LiveBeansPanelContent[])LiveBeansPanelContent.EP_NAME.getExtensions()) {
            Object contentData = content.getData((UserDataHolder)this, dataId);
            if (contentData == null) continue;
            return contentData;
        }
        return null;
    }

    @Nullable
    protected Icon getItemIcon(@NotNull LiveBeanItem item) {
        PsiElementPointer pointer;
        if (item == null) {
            LiveBeansPanel.$$$reportNull$$$0(14);
        }
        return (pointer = item.getPointer()) instanceof SpringBeanPointer ? SpringPresentationProvider.getSpringIcon((Object)pointer) : item.getBean().getIcon();
    }

    @Nullable
    protected JComponent createDefaultRightComponent() {
        BeansEndpointTabSettings settings = BeansEndpointTabSettings.getInstance(this.getProject());
        if (!(settings.isShowDoc() || settings.isShowLiveBeansGraph() && ((LiveBeansPanelContent[])LiveBeansPanelContent.EP_NAME.getExtensions()).length != 0)) {
            return null;
        }
        return super.createDefaultRightComponent();
    }

    @Nullable
    protected JComponent createRightComponent(@NotNull LiveBeanItem item) {
        if (item == null) {
            LiveBeansPanel.$$$reportNull$$$0(15);
        }
        SpringBootRunUsageTriggerCollector.logRuntimeBeanSelected(this.getProject());
        BeansEndpointTabSettings settings = BeansEndpointTabSettings.getInstance(this.getProject());
        LiveBeansPanelContent[] contentExtensions = (LiveBeansPanelContent[])LiveBeansPanelContent.EP_NAME.getExtensions();
        if (!(settings.isShowDoc() || settings.isShowLiveBeansGraph() && contentExtensions.length != 0)) {
            return null;
        }
        FinderRecursivePanel.DisposablePanel panel = new FinderRecursivePanel.DisposablePanel((LayoutManager)new BorderLayout(), (Disposable)this);
        OnePixelSplitter splitter = new OnePixelSplitter(true);
        splitter.setProportion(0.5f);
        panel.add((Component)splitter, (Object)"Center");
        if (settings.isShowDoc()) {
            PsiElement element = item.getPointer().getPsiElement();
            if (item.getPointer() instanceof LiveBean.LiveResourcePointer || element == null) {
                splitter.setFirstComponent((JComponent)new JBPanelWithEmptyText().withEmptyText(CodeInsightBundle.message((String)"no.documentation.found", (Object[])new Object[0])));
            } else {
                DocumentationComponent documentationComponent = DocumentationComponent.createAndFetch((Project)this.getProject(), (PsiElement)element, (Disposable)this);
                splitter.setFirstComponent((JComponent)documentationComponent);
            }
        }
        if (settings.isShowLiveBeansGraph()) {
            for (LiveBeansPanelContent content : contentExtensions) {
                SmartList beanList = new SmartList((Object)item.getBean());
                splitter.setSecondComponent(content.createComponent(this.getProject(), (UserDataHolder)this, (Disposable)panel, () -> LiveBeansPanel.lambda$createRightComponent$2((List)beanList), this.getRunConfiguration(), true));
            }
        }
        return panel;
    }

    public void setSecondComponent(@Nullable JComponent component) {
        super.setSecondComponent(component);
        if (!BeansEndpointTabSettings.getInstance(this.getProject()).isShowLiveBeansGraph()) {
            return;
        }
        for (LiveBeansPanelContent content : (LiveBeansPanelContent[])LiveBeansPanelContent.EP_NAME.getExtensions()) {
            content.update((UserDataHolder)this);
        }
    }

    protected AnAction[] getCustomListActions() {
        return new AnAction[]{this.myNavigateAction};
    }

    @Override
    protected JBList<LiveBeanItem> createList() {
        JBList list = super.createList();
        this.myNavigateAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditSource").getShortcutSet(), (JComponent)list);
        return list;
    }

    @Nullable
    protected String getItemTooltipText(@NotNull LiveBeanItem item) {
        if (item == null) {
            LiveBeansPanel.$$$reportNull$$$0(16);
        }
        return item.getBean().getClassName();
    }

    @Override
    protected boolean doUpdateItem(@NotNull LiveBeanItem item) {
        if (item == null) {
            LiveBeansPanel.$$$reportNull$$$0(17);
        }
        LiveBean bean = item.getBean();
        SpringBootApplicationRunConfigurationBase runConfiguration = this.getRunConfiguration();
        GlobalSearchScope searchScope = runConfiguration.getSearchScope();
        PsiElement resourceElement = null;
        if (bean.getResource() != null) {
            resourceElement = bean.getResource().findResourceElement(this.getProject(), runConfiguration.getModule(), (PsiElement)runConfiguration.getMainClass(), searchScope);
        }
        return item.updateItem(resourceElement, (CommonSpringModel)this.myModelFactory.create(), searchScope);
    }

    @Override
    @NlsContexts.HintText
    protected String getEditActionHintMessage(@NotNull LiveBeanItem item) {
        if (item == null) {
            LiveBeansPanel.$$$reportNull$$$0(18);
        }
        return SpringBootRunBundle.message("spring.boot.application.endpoints.bean.definition.not.found", new Object[0]);
    }

    @Override
    protected boolean performEditAction() {
        if (this.getSelectedValue() != null) {
            SpringBootRunUsageTriggerCollector.logEditRuntimeBean(this.getProject(), "ToolwindowContent");
        }
        return super.performEditAction();
    }

    private static /* synthetic */ List lambda$createRightComponent$2(List beanList) {
        return beanList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveBeansPanel";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveBeansPanel";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getItemText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasChildren";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createRightComponent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getItemTooltipText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateItem";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getEditActionHintMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NavigateToBeanClassAction
    extends AnAction {
        NavigateToBeanClassAction() {
            super(SpringBootRunBundle.messagePointer("spring.boot.application.endpoints.navigate.to.bean.class.action.name", new Object[0]), SpringBootRunBundle.messagePointer("spring.boot.application.endpoints.navigate.to.bean.class.action.description", new Object[0]), AllIcons.Nodes.Class);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                NavigateToBeanClassAction.$$$reportNull$$$0(0);
            }
            LiveBeanItem value = (LiveBeanItem)LiveBeansPanel.this.getSelectedValue();
            e.getPresentation().setEnabled(value != null && value.getBeanClass() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            LiveBeanItem value;
            if (e == null) {
                NavigateToBeanClassAction.$$$reportNull$$$0(1);
            }
            if ((value = (LiveBeanItem)LiveBeansPanel.this.getSelectedValue()) == null) {
                return;
            }
            LiveBeansPanel.this.updateItem(value);
            PsiClass beanClass = value.getBeanClass();
            if (beanClass != null && beanClass.canNavigate()) {
                beanClass.navigate(true);
            } else {
                LiveBeansPanel.this.showHint(SpringBootRunBundle.message("spring.boot.application.endpoints.bean.class.not.found", new Object[0]));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveBeansPanel$NavigateToBeanClassAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class LiveBeanItem {
        @NotNull
        private final Project myProject;
        @NotNull
        private final LiveBean myBean;
        @NotNull
        private PsiElementPointer myPointer;
        @Nullable
        private PsiClass myBeanClass;

        LiveBeanItem(@NotNull Project project, @NotNull LiveBean bean) {
            if (project == null) {
                LiveBeanItem.$$$reportNull$$$0(0);
            }
            if (bean == null) {
                LiveBeanItem.$$$reportNull$$$0(1);
            }
            this.myPointer = () -> null;
            this.myProject = project;
            this.myBean = bean;
        }

        @NotNull
        LiveBean getBean() {
            LiveBean liveBean = this.myBean;
            if (liveBean == null) {
                LiveBeanItem.$$$reportNull$$$0(2);
            }
            return liveBean;
        }

        @NotNull
        PsiElementPointer getPointer() {
            if (DumbService.isDumb((Project)this.myProject) || this.myPointer instanceof SpringBeanPointer && !((SpringBeanPointer)this.myPointer).isValid()) {
                PsiElementPointer psiElementPointer = () -> null;
                if (psiElementPointer == null) {
                    LiveBeanItem.$$$reportNull$$$0(3);
                }
                return psiElementPointer;
            }
            PsiElementPointer psiElementPointer = this.myPointer;
            if (psiElementPointer == null) {
                LiveBeanItem.$$$reportNull$$$0(4);
            }
            return psiElementPointer;
        }

        @Nullable
        PsiClass getBeanClass() {
            return DumbService.isDumb((Project)this.myProject) ? null : this.myBeanClass;
        }

        boolean updateItem(PsiElement resourceElement, CommonSpringModel springModel, GlobalSearchScope searchScope) {
            boolean changed = this.updateBeanClass(searchScope);
            return this.updateBeanPointer(resourceElement, springModel) || changed;
        }

        boolean updateBeanClass(GlobalSearchScope searchScope) {
            PsiClass beanClass = this.myBean.findBeanClass(this.myProject, searchScope);
            boolean changed = !Comparing.equal((Object)beanClass, (Object)this.myBeanClass);
            this.myBeanClass = beanClass;
            return changed;
        }

        boolean updateBeanPointer(@Nullable PsiElement resourceElement, @Nullable CommonSpringModel springModel) {
            if (resourceElement != null && !resourceElement.isValid()) {
                resourceElement = null;
            }
            PsiElementPointer pointer = this.myBean.findBeanPointer(this.myBeanClass, resourceElement, springModel);
            boolean changed = this.myPointer instanceof SpringBeanPointer ? !this.myPointer.equals(pointer) : (pointer instanceof SpringBeanPointer ? !pointer.equals(this.myPointer) : !Comparing.equal((Object)this.myPointer.getPsiElement(), (Object)pointer.getPsiElement()));
            this.myPointer = pointer;
            return changed;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof LiveBeanItem) {
                return this.myBean.equals(((LiveBeanItem)obj).myBean);
            }
            return false;
        }

        public int hashCode() {
            return this.myBean.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bean";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveBeansPanel$LiveBeanItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/tab/LiveBeansPanel$LiveBeanItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBean";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPointer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

