/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.diagram;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.actions.DiagramAddElementAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.run.lifecycle.beans.diagram.LiveBeanWrapper;
import com.intellij.spring.boot.run.statistics.SpringBootRunUsageTriggerCollector;
import com.intellij.spring.perspectives.diagrams.SpringDiagramExtras;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.xml.util.PsiElementPointer;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class LiveBeanDiagramExtras
extends SpringDiagramExtras {
    @NonNls
    private static final String HELP_ID = "spring.runtime.beans";

    public Object getData(@NotNull String dataId, List<DiagramNode<SpringElementWrapper<?>>> diagramNodes, DiagramBuilder builder) {
        PsiElementPointer pointer;
        PsiElement psiElement;
        SpringElementWrapper wrapper;
        if (dataId == null) {
            LiveBeanDiagramExtras.$$$reportNull$$$0(0);
        }
        if ((CommonDataKeys.NAVIGATABLE.is(dataId) || CommonDataKeys.PSI_ELEMENT.is(dataId) || CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) && diagramNodes != null && diagramNodes.size() == 1 && (wrapper = (SpringElementWrapper)diagramNodes.get(0).getIdentifyingElement()) instanceof LiveBeanWrapper && (psiElement = (pointer = ((LiveBeanWrapper)wrapper).getPointer()).getPsiElement()) != null && psiElement.isValid()) {
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return psiElement;
            }
            if (psiElement instanceof Navigatable) {
                final Navigatable navigatable = (Navigatable)psiElement;
                Navigatable navigatableWrapper = new Navigatable(){

                    public void navigate(boolean requestFocus) {
                        LiveBeanDiagramExtras.triggerUsage(psiElement.getProject());
                        navigatable.navigate(requestFocus);
                    }

                    public boolean canNavigate() {
                        return navigatable.canNavigate();
                    }

                    public boolean canNavigateToSource() {
                        return navigatable.canNavigateToSource();
                    }
                };
                if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                    return new Navigatable[]{navigatableWrapper};
                }
                return navigatableWrapper;
            }
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId, diagramNodes, builder);
    }

    public DiagramAddElementAction getAddElementHandler() {
        return null;
    }

    public void doEdit(DiagramNode<SpringElementWrapper<?>> node, DiagramPresentationModel presentationModel) {
        SpringElementWrapper wrapper = (SpringElementWrapper)node.getIdentifyingElement();
        if (!(wrapper instanceof LiveBeanWrapper)) {
            return;
        }
        PsiElement psiElement = ((LiveBeanWrapper)wrapper).getPointer().getPsiElement();
        if (!(psiElement instanceof Navigatable) || !psiElement.isValid()) {
            return;
        }
        Navigatable navigatable = (Navigatable)psiElement;
        if (navigatable.canNavigate()) {
            LiveBeanDiagramExtras.triggerUsage(psiElement.getProject());
            navigatable.navigate(true);
        }
    }

    private static void triggerUsage(Project project) {
        SpringBootRunUsageTriggerCollector.logEditRuntimeBean(project, "unknown");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/spring/boot/run/lifecycle/beans/diagram/LiveBeanDiagramExtras", "getData"));
    }
}

