/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.microservices.config.ConfigTunnelPortMapping;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.spring.boot.run.lifecycle.AbstractLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import org.jetbrains.annotations.NotNull;

class MappedPortProperty
extends AbstractLiveProperty<Integer>
implements LiveProperty.LivePropertyListener {
    private final LiveProperty<Integer> myRemoteProperty;
    private final ConfigTunnelPortMapping myPortMapping;

    @NotNull
    public static LiveProperty<Integer> withMappedPorts(@NotNull LiveProperty<Integer> remoteProperty, @NotNull ProcessHandler processHandler) {
        ConfigTunnelPortMapping portMapping;
        if (remoteProperty == null) {
            MappedPortProperty.$$$reportNull$$$0(0);
        }
        if (processHandler == null) {
            MappedPortProperty.$$$reportNull$$$0(1);
        }
        return (portMapping = (ConfigTunnelPortMapping)ConfigTunnelPortMapping.MAPPING_KEY.get((UserDataHolder)processHandler)) == null ? remoteProperty : new MappedPortProperty(remoteProperty, portMapping);
    }

    private MappedPortProperty(@NotNull LiveProperty<Integer> remoteProperty, @NotNull ConfigTunnelPortMapping portMapping) {
        if (remoteProperty == null) {
            MappedPortProperty.$$$reportNull$$$0(2);
        }
        if (portMapping == null) {
            MappedPortProperty.$$$reportNull$$$0(3);
        }
        super(null);
        this.myRemoteProperty = remoteProperty;
        this.myPortMapping = portMapping;
        this.myRemoteProperty.addPropertyListener(this);
        Disposer.register(remoteProperty, (Disposable)this);
    }

    @Override
    public void compute() {
        this.myRemoteProperty.compute();
    }

    public void dispose() {
        this.myRemoteProperty.removePropertyListener(this);
    }

    @Override
    public void computationFailed(@NotNull Exception e) {
        if (e == null) {
            MappedPortProperty.$$$reportNull$$$0(4);
        }
        this.getListeners().forEach(listener -> listener.computationFailed(e));
    }

    @Override
    public void computationFinished() {
        this.getListeners().forEach(listener -> listener.computationFinished());
    }

    @Override
    public void propertyChanged() {
        Integer remoteValue = this.myRemoteProperty.getValue();
        Integer mappedValue = remoteValue == null ? null : Integer.valueOf(this.myPortMapping.getLocalPort(remoteValue.intValue()));
        this.setValue(mappedValue);
        this.getListeners().forEach(listener -> listener.propertyChanged());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteProperty";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "portMapping";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/MappedPortProperty";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "withMappedPorts";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computationFailed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

