/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.editor;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.editor.SpringBootAdditionalParamsTableView;
import com.intellij.spring.boot.run.update.SpringBootApplicationUpdatePolicy;
import com.intellij.spring.profiles.SpringProfileCompletionProvider;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootSettingsPanel
extends JPanel
implements PanelWithAnchor {
    private JPanel myRootPanel;
    private JComponent myAnchor;
    private JBCheckBox myEnableDebugOutput;
    private JBCheckBox myEnableLaunchOptimization;
    private JBCheckBox myHideBanner;
    private JBCheckBox myEnableJmxAgent;
    private JPanel myAdditionalParametersPanel;
    private SpringProfileCompletionProvider myProfileCompletionProvider;
    private LabeledComponent<TextFieldWithAutoCompletion<String>> myActiveProfiles;
    private JLabel myDevToolsMessage;
    private LabeledComponent<ComboBox<SpringBootApplicationUpdatePolicy>> myUpdateActionPolicy;
    private ContextHelpLabel myUpdateActionHelpLabel;
    private LabeledComponent<ComboBox<SpringBootApplicationUpdatePolicy>> myFrameDeactivationPolicy;
    private ContextHelpLabel myFrameDeactivationHelpLabel;
    private JPanel myUpdatePoliciesPanel;
    private JBLabel myAdditionalParametersLabel;
    private SpringBootAdditionalParamsTableView myAdditionalParamsTable;
    private final Project myProject;
    private Module myModule;

    public SpringBootSettingsPanel(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.initAdditionalParamsTable();
        if (AdvancedSettings.getBoolean((String)"compiler.automake.allow.when.app.running")) {
            this.myDevToolsMessage.setIcon(AllIcons.General.BalloonError);
            this.myDevToolsMessage.setText(SpringBootApiBundle.message("spring.boot.run.config.settings.background.compilation.enabled", new Object[0]));
        }
        UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myUpdateActionPolicy, this.myFrameDeactivationPolicy});
        this.myUpdatePoliciesPanel.setBorder(IdeBorderFactory.createTitledBorder((String)SpringBootApiBundle.message("spring.boot.run.config.settings.running.application.update.policies", new Object[0])));
    }

    private void initAdditionalParamsTable() {
        this.myAdditionalParamsTable = new SpringBootAdditionalParamsTableView(this.myProject);
        this.myAdditionalParametersPanel.add((Component)ToolbarDecorator.createDecorator((JTable)((Object)this.myAdditionalParamsTable)).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SpringBootSettingsPanel.this.myAdditionalParamsTable.addAdditionalParameter();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.removeSelectedItems((JTable)((Object)SpringBootSettingsPanel.this.myAdditionalParamsTable));
            }
        }).createPanel(), "Center");
        this.myAdditionalParametersLabel.setLabelFor((Component)((Object)this.myAdditionalParamsTable));
    }

    void resetEditorFrom(@NotNull SpringBootApplicationRunConfiguration configuration) {
        if (configuration == null) {
            SpringBootSettingsPanel.$$$reportNull$$$0(0);
        }
        this.myEnableDebugOutput.setSelected(configuration.isDebugMode());
        this.myEnableLaunchOptimization.setSelected(configuration.isEnableLaunchOptimization());
        this.myHideBanner.setSelected(configuration.isHideBanner());
        this.myEnableJmxAgent.setSelected(configuration.isEnableJmxAgent());
        ((TextFieldWithAutoCompletion)this.myActiveProfiles.getComponent()).setText(configuration.getActiveProfiles());
        ((ComboBox)this.myUpdateActionPolicy.getComponent()).setSelectedItem((Object)configuration.getUpdateActionUpdatePolicy());
        ((ComboBox)this.myFrameDeactivationPolicy.getComponent()).setSelectedItem((Object)configuration.getFrameDeactivationUpdatePolicy());
        this.myAdditionalParamsTable.setAdditionalParameters(configuration.getAdditionalParameters());
    }

    void applyEditorTo(@NotNull SpringBootApplicationRunConfiguration configuration) {
        if (configuration == null) {
            SpringBootSettingsPanel.$$$reportNull$$$0(1);
        }
        configuration.setDebugMode(this.myEnableDebugOutput.isSelected());
        configuration.setEnableLaunchOptimization(this.myEnableLaunchOptimization.isSelected());
        configuration.setHideBanner(this.myHideBanner.isSelected());
        configuration.setEnableJmxAgent(this.myEnableJmxAgent.isSelected());
        configuration.setActiveProfiles(((TextFieldWithAutoCompletion)this.myActiveProfiles.getComponent()).getText());
        configuration.setUpdateActionUpdatePolicy((SpringBootApplicationUpdatePolicy)((ComboBox)this.myUpdateActionPolicy.getComponent()).getSelectedItem());
        configuration.setFrameDeactivationUpdatePolicy((SpringBootApplicationUpdatePolicy)((ComboBox)this.myFrameDeactivationPolicy.getComponent()).getSelectedItem());
        configuration.setAdditionalParameters(this.myAdditionalParamsTable.getAdditionalParameters());
    }

    JComponent getComponent() {
        return this.myRootPanel;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myActiveProfiles.setAnchor(anchor);
    }

    public void setModule(Module module) {
        this.myModule = module;
        this.myAdditionalParamsTable.setModule(module);
        this.myEnableJmxAgent.setEnabled(this.myModule == null || SpringBootLibraryUtil.isAtLeastVersion(this.myModule, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0));
        this.myProfileCompletionProvider.setContext((Collection)(module == null ? Collections.emptyList() : new SmartList((Object)module)));
    }

    private void createUIComponents() {
        this.myProfileCompletionProvider = new SpringProfileCompletionProvider(false);
        TextFieldWithAutoCompletion field = new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)this.myProfileCompletionProvider, true, "");
        this.myActiveProfiles = LabeledComponent.create((JComponent)field, (String)SpringBootApiBundle.message("spring.boot.run.config.settings.active.profiles", new Object[0]));
        ComboBox updateActionComboBox = new ComboBox();
        SpringBootSettingsPanel.initUpdatePolicyComboBox((ComboBox<SpringBootApplicationUpdatePolicy>)updateActionComboBox, false);
        this.myUpdateActionPolicy = LabeledComponent.create((JComponent)updateActionComboBox, (String)SpringBootApiBundle.message("spring.boot.run.config.settings.on.update.action", new Object[0]));
        this.myUpdateActionHelpLabel = ContextHelpLabel.create((String)SpringBootSettingsPanel.getHelpLabelDescription((ComboBox<SpringBootApplicationUpdatePolicy>)updateActionComboBox));
        ComboBox frameDeactivationComboBox = new ComboBox();
        SpringBootSettingsPanel.initUpdatePolicyComboBox((ComboBox<SpringBootApplicationUpdatePolicy>)frameDeactivationComboBox, true);
        this.myFrameDeactivationPolicy = LabeledComponent.create((JComponent)frameDeactivationComboBox, (String)SpringBootApiBundle.message("spring.boot.run.config.settings.on.frame.deactivation", new Object[0]));
        this.myFrameDeactivationHelpLabel = ContextHelpLabel.create((String)SpringBootSettingsPanel.getHelpLabelDescription((ComboBox<SpringBootApplicationUpdatePolicy>)frameDeactivationComboBox));
    }

    private static void initUpdatePolicyComboBox(ComboBox<SpringBootApplicationUpdatePolicy> comboBox, boolean onFrameDeactivation) {
        comboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)SpringBootRunBundle.message("spring.boot.application.run.configuration.do.nothing", new Object[0]), value -> UIUtil.removeMnemonic((String)value.getName())));
        comboBox.addItem(null);
        List<SpringBootApplicationUpdatePolicy> policies = SpringBootApplicationUpdatePolicy.getAvailablePolicies(onFrameDeactivation);
        for (SpringBootApplicationUpdatePolicy policy : policies) {
            comboBox.addItem((Object)policy);
        }
        if (comboBox.getItemCount() > 0) {
            comboBox.setSelectedIndex(0);
        }
    }

    @NlsSafe
    private static String getHelpLabelDescription(ComboBox<SpringBootApplicationUpdatePolicy> updateActionComboBox) {
        StringBuilder description = new StringBuilder();
        for (int i = 0; i < updateActionComboBox.getItemCount(); ++i) {
            SpringBootApplicationUpdatePolicy policy = (SpringBootApplicationUpdatePolicy)updateActionComboBox.getItemAt(i);
            if (policy == null) continue;
            description.append("<p><b>").append(policy.getName()).append("</b><br>").append(policy.getDescription()).append("</p>");
        }
        return description.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "configuration";
        objectArray2[1] = "com/intellij/spring/boot/run/editor/SpringBootSettingsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyEditorTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JLabel jLabel;
        JPanel jPanel2;
        JBCheckBox jBCheckBox4;
        JPanel jPanel3;
        this.createUIComponents();
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEnableDebugOutput = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/SpringBootRunBundle", SpringBootSettingsPanel.class).getString("spring.boot.application.run.configuration.debug.output"));
        jBCheckBox4.setToolTipText(ResourceBundle.getBundle("messages/SpringBootRunBundle").getString("spring.boot.application.run.configuration.debug.output.tooltip"));
        jPanel3.add((Component)jBCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 5, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAdditionalParametersPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(4, 0, 1, 6, 0, 3, 3, 3, null, null, null));
        LabeledComponent<TextFieldWithAutoCompletion<String>> labeledComponent = this.myActiveProfiles;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/SpringBootRunBundle", SpringBootSettingsPanel.class).getString("spring.boot.application.run.configuration.active.profiles"));
        labeledComponent.setToolTipText(ResourceBundle.getBundle("messages/SpringBootRunBundle").getString("spring.boot.application.run.configuration.active.profiles.tooltip"));
        jPanel3.add((Component)labeledComponent, new GridConstraints(2, 0, 1, 6, 0, 1, 3, 3, null, null, null));
        this.myDevToolsMessage = jLabel = new JLabel();
        jLabel.setText("");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnableLaunchOptimization = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/SpringBootRunBundle", SpringBootSettingsPanel.class).getString("spring.boot.application.run.configuration.launch.optimization"));
        jBCheckBox3.setToolTipText(ResourceBundle.getBundle("messages/SpringBootRunBundle").getString("spring.boot.application.run.configuration.launch.optimization.tooltip"));
        jPanel3.add((Component)jBCheckBox3, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myHideBanner = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/SpringBootRunBundle", SpringBootSettingsPanel.class).getString("spring.boot.application.run.configuration.hide.banner"));
        jBCheckBox2.setToolTipText(ResourceBundle.getBundle("messages/SpringBootRunBundle").getString("spring.boot.application.run.configuration.hide.banner.tooltip"));
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnableJmxAgent = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/SpringBootRunBundle", SpringBootSettingsPanel.class).getString("spring.boot.application.run.configuration.jmx.agent"));
        jBCheckBox.setToolTipText(ResourceBundle.getBundle("messages/SpringBootRunBundle").getString("spring.boot.application.run.configuration.jmx.agent.tooltip"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 3, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myUpdatePoliciesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null, 1));
        LabeledComponent<ComboBox<SpringBootApplicationUpdatePolicy>> labeledComponent2 = this.myUpdateActionPolicy;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/SpringBootRunBundle", SpringBootSettingsPanel.class).getString("spring.boot.application.run.configuration.on.update.action"));
        jPanel.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent<ComboBox<SpringBootApplicationUpdatePolicy>> labeledComponent3 = this.myFrameDeactivationPolicy;
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(DynamicBundle.getBundle((String)"messages/SpringBootRunBundle", SpringBootSettingsPanel.class).getString("spring.boot.application.run.configuration.on.frame.deactivation"));
        jPanel.add((Component)labeledComponent3, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        ContextHelpLabel contextHelpLabel = this.myUpdateActionHelpLabel;
        jPanel.add((Component)contextHelpLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        ContextHelpLabel contextHelpLabel2 = this.myFrameDeactivationHelpLabel;
        jPanel.add((Component)contextHelpLabel2, new GridConstraints(1, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myAdditionalParametersLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/SpringBootRunBundle", SpringBootSettingsPanel.class).getString("spring.boot.application.run.configuration.override.parameters"));
        jPanel3.add((Component)jBLabel, new GridConstraints(3, 0, 1, 3, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

