/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.editor;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootAdditionalParamsTableView
extends TableView<SpringBootAdditionalParameter> {
    private final ListTableModel<SpringBootAdditionalParameter> myAdditionalParamsModel;
    private final Project myProject;
    @Nullable
    private Module myModule;

    SpringBootAdditionalParamsTableView(Project project) {
        this.myProject = project;
        Shortcut[] quickDocShortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"QuickJavaDoc").getShortcuts();
        final String quickDocShortcutText = quickDocShortcuts.length == 0 ? null : "Full documentation available (" + KeymapUtil.getShortcutText((Shortcut)quickDocShortcuts[0]) + ")";
        this.myAdditionalParamsModel = new ListTableModel(new ColumnInfo[]{new ColumnInfo<SpringBootAdditionalParameter, Boolean>(""){

            public Boolean valueOf(SpringBootAdditionalParameter parameter) {
                return parameter.isEnabled();
            }

            public Class<?> getColumnClass() {
                return Boolean.class;
            }

            public void setValue(SpringBootAdditionalParameter parameter, Boolean value) {
                parameter.setEnabled(value);
            }

            public boolean isCellEditable(SpringBootAdditionalParameter parameter) {
                return true;
            }
        }, new ColumnInfo<SpringBootAdditionalParameter, String>(SpringBootApiBundle.message("additional.params.table.name", new Object[0])){
            private final TableCellRenderer myRenderer;
            {
                super(arg0);
                this.myRenderer = new DefaultTableCellRenderer();
            }

            public TableCellEditor getEditor(SpringBootAdditionalParameter parameter) {
                if (SpringBootAdditionalParamsTableView.this.myModule == null || DumbService.isDumb((Project)SpringBootAdditionalParamsTableView.this.myModule.getProject())) {
                    return SpringBootAdditionalParamsTableView.createDefaultParameterEditor(SpringBootAdditionalParamsTableView.this.myProject, parameter.getName());
                }
                return new MySpringBootNameTableCellEditor(SpringBootAdditionalParamsTableView.this.myModule);
            }

            @Nullable
            public String valueOf(SpringBootAdditionalParameter parameter) {
                return parameter.getName();
            }

            public void setValue(SpringBootAdditionalParameter parameter, String value) {
                parameter.setName(StringUtil.trim((String)value));
            }

            public boolean isCellEditable(SpringBootAdditionalParameter parameter) {
                return parameter.isEnabled();
            }

            public TableCellRenderer getRenderer(SpringBootAdditionalParameter parameter) {
                return this.myRenderer;
            }

            public TableCellRenderer getCustomizedRenderer(SpringBootAdditionalParameter o, TableCellRenderer renderer) {
                MetaConfigKey key = SpringBootAdditionalParamsTableView.this.findMetaConfigKey(o);
                if (key != null) {
                    @NlsSafe Object toolTipText = key.getDescriptionText().getFullText();
                    if (quickDocShortcutText != null) {
                        toolTipText = !((String)toolTipText).isEmpty() ? (String)toolTipText + "\n\n" + quickDocShortcutText : quickDocShortcutText;
                    }
                    ((DefaultTableCellRenderer)renderer).setToolTipText((String)toolTipText);
                }
                return renderer;
            }

            public String getPreferredStringValue() {
                return "012345678901234";
            }
        }, new ColumnInfo<SpringBootAdditionalParameter, String>(SpringBootApiBundle.message("additional.params.table.value", new Object[0])){

            @Nullable
            public String valueOf(SpringBootAdditionalParameter parameter) {
                return parameter.getValue();
            }

            public void setValue(SpringBootAdditionalParameter parameter, String value) {
                parameter.setValue(value);
            }

            public boolean isCellEditable(SpringBootAdditionalParameter parameter) {
                return parameter.isEnabled();
            }

            public TableCellEditor getEditor(SpringBootAdditionalParameter parameter) {
                MetaConfigKey key = SpringBootAdditionalParamsTableView.this.findMetaConfigKey(parameter);
                if (key == null) {
                    return SpringBootAdditionalParamsTableView.createDefaultParameterEditor(SpringBootAdditionalParamsTableView.this.myProject, parameter.getValue());
                }
                List<Object> variants = SpringBootAdditionalParamsTableView.this.getCompletionVariants(key, parameter.getName());
                if (variants.isEmpty()) {
                    return SpringBootAdditionalParamsTableView.createDefaultParameterEditor(SpringBootAdditionalParamsTableView.this.myProject, parameter.getValue());
                }
                return SpringBootAdditionalParamsTableView.this.createValueTableCellEditor(parameter, variants);
            }
        }});
        this.setModelAndUpdateColumns(this.myAdditionalParamsModel);
        this.getTableHeader().setReorderingAllowed(false);
        TableUtil.setupCheckboxColumn((TableColumn)this.getColumnModel().getColumn(0), (int)this.getColumnModel().getColumnMargin());
        StatusText emptyText = this.getEmptyText();
        emptyText.setText(SpringBootApiBundle.message("additional.params.table.empty.text", new Object[0]));
        emptyText.appendSecondaryText(SpringBootApiBundle.message("additional.params.table.add", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpringBootAdditionalParamsTableView.this.addAdditionalParameter();
            }
        });
        ShortcutSet shortcutSet = CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD);
        Shortcut shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])shortcutSet.getShortcuts());
        if (shortcut != null) {
            emptyText.appendSecondaryText(" (" + KeymapUtil.getShortcutText((Shortcut)shortcut) + ")", StatusText.DEFAULT_ATTRIBUTES, null);
        }
        this.setShowGrid(false);
        this.setColumnSelectionAllowed(false);
        this.setRowHeight(new LanguageTextField().getPreferredSize().height * 2 + JBUIScale.scale((int)1));
        this.setVisibleRowCount(5);
        new TableSpeedSearch((JTable)((Object)this));
        new AnAction(SpringBootApiBundle.message("additional.params.table.quick.doc", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (SpringBootAdditionalParamsTableView.this.myModule == null) {
                    return;
                }
                List selectedParams = SpringBootAdditionalParamsTableView.this.getSelectedObjects();
                if (selectedParams.size() != 1) {
                    return;
                }
                SpringBootAdditionalParamsTableView.showHint(SpringBootAdditionalParamsTableView.this.myModule, ((SpringBootAdditionalParameter)selectedParams.get(0)).getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/run/editor/SpringBootAdditionalParamsTableView$5", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(quickDocShortcuts), (JComponent)((Object)this));
    }

    List<SpringBootAdditionalParameter> getAdditionalParameters() {
        return this.myAdditionalParamsModel.getItems();
    }

    void setAdditionalParameters(List<SpringBootAdditionalParameter> parameters) {
        ArrayList<SpringBootAdditionalParameter> copy = new ArrayList<SpringBootAdditionalParameter>();
        for (SpringBootAdditionalParameter parameter : parameters) {
            copy.add(new SpringBootAdditionalParameter(parameter.isEnabled(), parameter.getName(), parameter.getValue()));
        }
        this.myAdditionalParamsModel.setItems(copy);
    }

    void addAdditionalParameter() {
        this.stopEditing();
        this.myAdditionalParamsModel.addRow((Object)new SpringBootAdditionalParameter(true, "", ""));
        int index = this.myAdditionalParamsModel.getRowCount() - 1;
        this.setRowSelectionInterval(index, index);
        SwingUtilities.invokeLater(() -> {
            TableUtil.scrollSelectionToVisible((JTable)((Object)this));
            TableUtil.editCellAt((JTable)((Object)this), (int)index, (int)1);
        });
    }

    void setModule(@Nullable Module module) {
        this.myModule = module;
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.isAltDown() || e.isMetaDown() || e.getID() != 401) {
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        if (e.isControlDown()) {
            if (e.getKeyCode() == 10 && this.isEditing()) {
                this.stopEditing();
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        if (this.isEditing() && (e.getKeyCode() == 9 || (e.getKeyCode() == 38 || e.getKeyCode() == 40) && e.getModifiers() == 0)) {
            int row = this.getSelectedRow();
            int column = this.getSelectedColumn();
            boolean result2 = super.processKeyBinding(ks, e, condition, pressed);
            if (!(this.isEditing() || row == this.getSelectedRow() && column == this.getSelectedColumn())) {
                TableUtil.editCellAt((JTable)((Object)this), (int)this.getSelectedRow(), (int)this.getSelectedColumn());
                e.consume();
                return true;
            }
            return result2;
        }
        if (e.getKeyCode() == 10 && e.getModifiers() == 0) {
            if (this.isEditing()) {
                this.stopEditing();
            } else {
                TableUtil.editCellAt((JTable)((Object)this), (int)this.getSelectedRow(), (int)this.getSelectedColumn());
            }
            e.consume();
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    @NotNull
    private TableCellEditor createValueTableCellEditor(SpringBootAdditionalParameter parameter, List<Object> variants) {
        assert (this.myModule != null);
        final TextFieldWithAutoCompletion field = new TextFieldWithAutoCompletion(this.myModule.getProject(), (TextFieldWithAutoCompletionListProvider)new ApplicationPropertiesAutoCompletionListProvider(variants), true, parameter.getValue());
        return new AbstractTableCellEditor(){

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return field;
            }

            public Object getCellEditorValue() {
                return field.getText();
            }
        };
    }

    private List<Object> getCompletionVariants(@NotNull MetaConfigKey key, String keyText) {
        if (key == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(0);
        }
        ProcessingContext processingContext = new ProcessingContext();
        if (!key.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL})) {
            processingContext.put(SpringBootHintReferencesProvider.HINT_REFERENCES_CONFIG_KEY_TEXT, (Object)keyText);
        }
        PsiElement dummyValueNode = this.createDummyValueNode();
        List<TextRange> valueTextRanges = Collections.singletonList(ElementManipulators.getValueTextRange((PsiElement)dummyValueNode));
        Object[] references = SpringBootHintReferencesProvider.getInstance().getValueReferences(this.myModule, key, null, dummyValueNode, valueTextRanges, processingContext);
        PsiReference reference = (PsiReference)ArrayUtil.getFirstElement((Object[])references);
        if (reference == null) {
            return Collections.emptyList();
        }
        if (reference instanceof JavaClassReference) {
            JavaClassReference javaClassReference = (JavaClassReference)reference;
            List names = javaClassReference.getSuperClasses();
            PsiElement context = javaClassReference.getCompletionContext();
            if (!names.isEmpty() && context instanceof PsiPackage) {
                ArrayList<Object> variants = new ArrayList<Object>();
                javaClassReference.processSubclassVariants((PsiPackage)context, ArrayUtilRt.toStringArray((Collection)names), element -> variants.add(element));
                return variants;
            }
        }
        return Arrays.stream(reference.getVariants()).filter(o -> !(o instanceof PsiNamedElement) || ((PsiNamedElement)o).getName() != null).collect(Collectors.toList());
    }

    @NotNull
    private PsiElement createDummyValueNode() {
        assert (this.myModule != null);
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)this.myModule.getProject()).createFileFromText("application.properties", (FileType)PropertiesFileType.INSTANCE, (CharSequence)"dummyKey=x\n");
        dummyFile.putUserData(ModuleUtilCore.KEY_MODULE, (Object)this.myModule);
        PropertiesFile propertiesFile = (PropertiesFile)dummyFile;
        IProperty dummyKey = propertiesFile.findPropertyByKey("dummyKey");
        assert (dummyKey != null);
        PropertyImpl dummyProperty = (PropertyImpl)dummyKey.getPsiElement();
        ASTNode valueNode = dummyProperty.getValueNode();
        assert (valueNode != null);
        PsiElement psiElement = valueNode.getPsi();
        if (psiElement == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @Nullable
    private MetaConfigKey findMetaConfigKey(SpringBootAdditionalParameter parameter) {
        if (this.myModule == null || DumbService.isDumb((Project)this.myModule.getProject())) {
            return null;
        }
        return SpringBootApplicationMetaConfigKeyManager.getInstance().findApplicationMetaConfigKey(this.myModule, parameter.getName());
    }

    @NotNull
    private static PsiElement createDummyKeyNode(@NotNull Module module, @NotNull String prefix) {
        if (module == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(2);
        }
        if (prefix == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(3);
        }
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)module.getProject()).createFileFromText("application.properties", (FileType)PropertiesFileType.INSTANCE, (CharSequence)prefix);
        dummyFile.putUserData(ModuleUtilCore.KEY_MODULE, (Object)module);
        PropertiesFile propertiesFile = (PropertiesFile)dummyFile;
        IProperty dummyKey = propertiesFile.findPropertyByKey(prefix);
        assert (dummyKey != null);
        PropertyImpl dummyProperty = (PropertyImpl)dummyKey.getPsiElement();
        ASTNode keyNode = dummyProperty.getKeyNode();
        assert (keyNode != null);
        PsiElement psiElement = keyNode.getPsi();
        if (psiElement == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @NotNull
    private static TableCellEditor createDefaultParameterEditor(Project project, String value) {
        final LanguageTextField field = new LanguageTextField((Language)PlainTextLanguage.INSTANCE, project, value);
        return new AbstractTableCellEditor(){

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return field;
            }

            public Object getCellEditorValue() {
                return field.getText();
            }
        };
    }

    private static void showHint(@NotNull Module module, @NotNull String configKey) {
        if (module == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(5);
        }
        if (configKey == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(6);
        }
        MetaConfigKey key = SpringBootApplicationMetaConfigKeyManager.getInstance().findApplicationMetaConfigKey(module, configKey);
        DocumentationManager documentationManager = DocumentationManager.getInstance((Project)module.getProject());
        documentationManager.restorePopupBehavior();
        if (key == null) {
            PsiFile psiFile = PsiFileFactory.getInstance((Project)module.getProject()).createFileFromText((Language)PlainTextLanguage.INSTANCE, (CharSequence)"");
            documentationManager.showJavaDocInfo((PsiElement)psiFile, null, true, null);
        } else {
            PsiElement propertyElement = SpringBootAdditionalParamsTableView.createDummyKeyNode(module, configKey).getParent();
            propertyElement.getContainingFile().putUserData(SpringBootApplicationMetaConfigKeyManager.ELEMENT_IN_EXTERNAL_CONTEXT, (Object)Boolean.TRUE);
            documentationManager.showJavaDocInfo(propertyElement, propertyElement, true, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/editor/SpringBootAdditionalParamsTableView";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/editor/SpringBootAdditionalParamsTableView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyValueNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyKeyNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariants";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDummyKeyNode";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ApplicationPropertiesAutoCompletionListProvider
    extends TextFieldWithAutoCompletionListProvider<Object> {
        ApplicationPropertiesAutoCompletionListProvider(@Nullable Collection<Object> variants) {
            super(variants);
        }

        @NotNull
        protected String getLookupString(@NotNull Object item) {
            if (item == null) {
                ApplicationPropertiesAutoCompletionListProvider.$$$reportNull$$$0(0);
            }
            if (item instanceof MetaConfigKey) {
                String string = ((MetaConfigKey)item).getName();
                if (string == null) {
                    ApplicationPropertiesAutoCompletionListProvider.$$$reportNull$$$0(1);
                }
                return string;
            }
            if (item instanceof String) {
                String string = (String)item;
                if (string == null) {
                    ApplicationPropertiesAutoCompletionListProvider.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (item instanceof LookupElement) {
                String string = ((LookupElement)item).getLookupString();
                if (string == null) {
                    ApplicationPropertiesAutoCompletionListProvider.$$$reportNull$$$0(3);
                }
                return string;
            }
            if (item instanceof PsiNamedElement) {
                Ref name = new Ref();
                ApplicationManager.getApplication().runReadAction(() -> name.set((Object)((PsiNamedElement)item).getName()));
                if (name.get() != null) {
                    String string = (String)name.get();
                    if (string == null) {
                        ApplicationPropertiesAutoCompletionListProvider.$$$reportNull$$$0(4);
                    }
                    return string;
                }
            }
            String string = item.toString() + " " + item.getClass();
            if (string == null) {
                ApplicationPropertiesAutoCompletionListProvider.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public LookupElementBuilder createLookupBuilder(@NotNull Object item) {
            if (item == null) {
                ApplicationPropertiesAutoCompletionListProvider.$$$reportNull$$$0(6);
            }
            if (item instanceof MetaConfigKey) {
                LookupElementBuilder lookupElementBuilder = ((MetaConfigKey)item).getPresentation().getLookupElement();
                if (lookupElementBuilder == null) {
                    ApplicationPropertiesAutoCompletionListProvider.$$$reportNull$$$0(7);
                }
                return lookupElementBuilder;
            }
            if (item instanceof LookupElementBuilder) {
                LookupElementBuilder lookupElementBuilder = (LookupElementBuilder)item;
                if (lookupElementBuilder == null) {
                    ApplicationPropertiesAutoCompletionListProvider.$$$reportNull$$$0(8);
                }
                return lookupElementBuilder;
            }
            LookupElementBuilder lookupElementBuilder = super.createLookupBuilder(item);
            if (lookupElementBuilder == null) {
                ApplicationPropertiesAutoCompletionListProvider.$$$reportNull$$$0(9);
            }
            return lookupElementBuilder;
        }

        @Nullable
        protected Icon getIcon(@NotNull Object item) {
            if (item == null) {
                ApplicationPropertiesAutoCompletionListProvider.$$$reportNull$$$0(10);
            }
            if (item instanceof PsiPresentableMetaData) {
                return ((PsiPresentableMetaData)item).getIcon();
            }
            if (item instanceof Iconable) {
                return ((Iconable)item).getIcon(0);
            }
            return super.getIcon(item);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/run/editor/SpringBootAdditionalParamsTableView$ApplicationPropertiesAutoCompletionListProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/run/editor/SpringBootAdditionalParamsTableView$ApplicationPropertiesAutoCompletionListProvider";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLookupBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createLookupBuilder";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MySpringBootNameTableCellEditor
    extends AbstractTableCellEditor {
        private final TextFieldWithAutoCompletion<Object> myTextField;

        MySpringBootNameTableCellEditor(final @NotNull Module module) {
            if (module == null) {
                MySpringBootNameTableCellEditor.$$$reportNull$$$0(0);
            }
            List allKeys = SpringBootApplicationMetaConfigKeyManager.getInstance().getAllMetaConfigKeys(module);
            ArrayList<Object> variants = new ArrayList<Object>(allKeys);
            for (MetaConfigKey key : allKeys) {
                if (!key.isAccessType(MetaConfigKey.AccessType.MAP_GROUP)) continue;
                String prefix = key.getName() + ".";
                PsiElement dummyKeyNode = SpringBootAdditionalParamsTableView.createDummyKeyNode(module, prefix);
                Object[] references = SpringBootHintReferencesProvider.getInstance().getKeyReferences(module, key, dummyKeyNode, new ProcessingContext());
                PsiReference reference = (PsiReference)ArrayUtil.getFirstElement((Object[])references);
                SmartList hints = new SmartList();
                if (reference != null) {
                    for (Object variant : reference.getVariants()) {
                        if (!(variant instanceof LookupElement)) continue;
                        hints.add(prefix + ((LookupElement)variant).getLookupString());
                    }
                }
                if (hints.isEmpty()) {
                    hints.add(prefix);
                }
                variants.remove(key);
                for (String hint : hints) {
                    variants.add(key.getPresentation().getLookupElement(hint));
                }
            }
            this.myTextField = new TextFieldWithAutoCompletion(module.getProject(), (TextFieldWithAutoCompletionListProvider)new ApplicationPropertiesAutoCompletionListProvider(variants), true, null);
            Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"QuickJavaDoc").getShortcuts();
            new AnAction(SpringBootApiBundle.message("additional.params.table.quick.doc", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    SpringBootAdditionalParamsTableView.showHint(module, myTextField.getText());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/run/editor/SpringBootAdditionalParamsTableView$MySpringBootNameTableCellEditor$1", "actionPerformed"));
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), this.myTextField);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.myTextField.setText((String)value);
            return this.myTextField;
        }

        public Object getCellEditorValue() {
            return this.myTextField.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/run/editor/SpringBootAdditionalParamsTableView$MySpringBootNameTableCellEditor", "<init>"));
        }
    }
}

