/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManagerImpl;
import com.intellij.util.net.NetUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 \u000f2\u00020\u0001:\u0003\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/spring/boot/run/SpringBootJmxSetup;", "", "()V", "handleCreatedEnvironment", "", "environment", "Lcom/intellij/execution/target/TargetEnvironment;", "setupJmxParameters", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "targetRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "setupProcessHandler", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "Companion", "LocalSetup", "RemoteSetup", "intellij.spring.boot.run"})
public abstract class SpringBootJmxSetup {
    private static final String JMX_REGISTRY_PORT = "com.sun.management.jmxremote.port";
    private static final String JMX_RMI_SERVER_PORT = "com.sun.management.jmxremote.rmi.port";
    private static final String JMX_REMOTE_AUTH = "com.sun.management.jmxremote.authenticate";
    private static final String JMX_REMOTE_SSL = "com.sun.management.jmxremote.ssl";
    private static final String JMX_RMI_SERVER_HOST = "java.rmi.server.hostname";
    private static final String JMX_REGISTRY_HOST = "com.sun.management.jmxremote.host";
    private static final String ANY_HOST = "0.0.0.0";
    private static final int DEFAULT_JMX_REGISTRY_PORT = 5000;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public abstract void setupJmxParameters(@NotNull JavaParameters var1, @NotNull TargetEnvironmentRequest var2) throws ExecutionException;

    public abstract void handleCreatedEnvironment(@NotNull TargetEnvironment var1);

    public void setupProcessHandler(@NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        processHandler.putUserData(SpringBootApplicationLifecycleManagerImpl.JMX_ENABLED, (Object)true);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/spring/boot/run/SpringBootJmxSetup$LocalSetup;", "Lcom/intellij/spring/boot/run/SpringBootJmxSetup;", "()V", "myJmxPort", "", "handleCreatedEnvironment", "", "environment", "Lcom/intellij/execution/target/TargetEnvironment;", "setupJmxParameters", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "targetRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "setupProcessHandler", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "intellij.spring.boot.run"})
    public static final class LocalSetup
    extends SpringBootJmxSetup {
        private int myJmxPort = -1;

        @Override
        public void setupJmxParameters(@NotNull JavaParameters params, @NotNull TargetEnvironmentRequest targetRequest) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)targetRequest, (String)"targetRequest");
            boolean bl = targetRequest instanceof LocalTargetEnvironmentRequest;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            ParametersList vmParametersList = params.getVMParametersList();
            String auth = vmParametersList.getPropertyValue(SpringBootJmxSetup.JMX_REMOTE_AUTH);
            if (!StringsKt.equals((String)"false", (String)auth, (boolean)true)) {
                return;
            }
            String ssl = vmParametersList.getPropertyValue(SpringBootJmxSetup.JMX_REMOTE_SSL);
            if (!StringsKt.equals((String)"false", (String)ssl, (boolean)true)) {
                return;
            }
            String jmxPort = vmParametersList.getPropertyValue(SpringBootJmxSetup.JMX_REGISTRY_PORT);
            if (jmxPort != null) {
                try {
                    String string = jmxPort;
                    boolean bl5 = false;
                    this.myJmxPort = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void handleCreatedEnvironment(@NotNull TargetEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        }

        @Override
        public void setupProcessHandler(@NotNull ProcessHandler processHandler) {
            Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
            super.setupProcessHandler(processHandler);
            if (this.myJmxPort > 0) {
                processHandler.putUserData(SpringBootApplicationLifecycleManager.JMX_PORT, (Object)this.myJmxPort);
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/spring/boot/run/SpringBootJmxSetup$RemoteSetup;", "Lcom/intellij/spring/boot/run/SpringBootJmxSetup;", "()V", "myJmxPortBinding", "Lcom/intellij/execution/target/TargetEnvironment$TargetPortBinding;", "myResolvedEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "handleCreatedEnvironment", "", "environment", "setupJmxHosts", "vmParametersList", "Lcom/intellij/execution/configurations/ParametersList;", "setupJmxParameters", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "targetRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "setupJmxPorts", "setupJmxSecurity", "setupProcessHandler", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "Companion", "intellij.spring.boot.run"})
    public static final class RemoteSetup
    extends SpringBootJmxSetup {
        private TargetEnvironment myResolvedEnvironment;
        private TargetEnvironment.TargetPortBinding myJmxPortBinding;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Override
        public void setupJmxParameters(@NotNull JavaParameters params, @NotNull TargetEnvironmentRequest targetRequest) {
            ParametersList vmParametersList;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)targetRequest, (String)"targetRequest");
            boolean bl = !(targetRequest instanceof LocalTargetEnvironmentRequest);
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            ParametersList parametersList = vmParametersList = params.getVMParametersList();
            Intrinsics.checkNotNullExpressionValue((Object)parametersList, (String)"vmParametersList");
            this.setupJmxPorts(parametersList, targetRequest);
            this.setupJmxHosts(vmParametersList);
            this.setupJmxSecurity(vmParametersList, targetRequest);
        }

        /*
         * WARNING - void declaration
         */
        private final void setupJmxPorts(ParametersList vmParametersList, TargetEnvironmentRequest targetRequest) {
            String string;
            String jmxRegistryPort = vmParametersList.getPropertyValue(SpringBootJmxSetup.JMX_REGISTRY_PORT);
            String rmiServerPort = vmParametersList.getPropertyValue(SpringBootJmxSetup.JMX_RMI_SERVER_PORT);
            if (jmxRegistryPort != null && rmiServerPort != null && Intrinsics.areEqual((Object)jmxRegistryPort, (Object)rmiServerPort) ^ true) {
                throw (Throwable)new ExecutionException(SpringBootRunBundle.message("spring.boot.jmx.setup.for.remote.case.two.ports.should.match", jmxRegistryPort, rmiServerPort));
            }
            String samePortForAll = null;
            String string2 = jmxRegistryPort;
            if (string2 == null) {
                string2 = string = rmiServerPort;
            }
            if (string2 == null) {
                string = samePortForAll = String.valueOf(NetUtils.tryToFindAvailableSocketPort((int)5000));
            }
            if (jmxRegistryPort == null) {
                vmParametersList.addProperty(SpringBootJmxSetup.JMX_REGISTRY_PORT, samePortForAll);
            }
            if (rmiServerPort == null) {
                vmParametersList.addProperty(SpringBootJmxSetup.JMX_RMI_SERVER_PORT, samePortForAll);
            }
            try {
                void it;
                String string3 = samePortForAll;
                boolean bl = false;
                int samePort = Integer.parseInt(string3);
                string3 = new TargetEnvironment.TargetPortBinding(Integer.valueOf(samePort), samePort);
                bl = false;
                boolean bl2 = false;
                String string4 = string3;
                RemoteSetup remoteSetup = this;
                boolean bl3 = false;
                targetRequest.getTargetPortBindings().add(it);
                Unit unit = Unit.INSTANCE;
                remoteSetup.myJmxPortBinding = string3;
            }
            catch (NumberFormatException e) {
                throw (Throwable)new ExecutionException(SpringBootRunBundle.message("spring.boot.jmx.setup.cant.parse.jmx.port", jmxRegistryPort));
            }
        }

        private final void setupJmxSecurity(ParametersList vmParametersList, TargetEnvironmentRequest targetRequest) {
            vmParametersList.addProperty(SpringBootJmxSetup.JMX_REMOTE_AUTH, "false");
            vmParametersList.addProperty(SpringBootJmxSetup.JMX_REMOTE_SSL, "false");
        }

        private final void setupJmxHosts(ParametersList vmParametersList) {
            RemoteSetup.Companion.addPropertyIfNotSetAlready(vmParametersList, SpringBootJmxSetup.JMX_REGISTRY_HOST, SpringBootJmxSetup.ANY_HOST);
            RemoteSetup.Companion.addPropertyIfNotSetAlready(vmParametersList, SpringBootJmxSetup.JMX_RMI_SERVER_HOST, SpringBootJmxSetup.ANY_HOST);
        }

        @Override
        public void handleCreatedEnvironment(@NotNull TargetEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            this.myResolvedEnvironment = environment;
        }

        @Override
        public void setupProcessHandler(@NotNull ProcessHandler processHandler) {
            block2: {
                Object object;
                Object resolvedPorts;
                Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
                super.setupProcessHandler(processHandler);
                Object object2 = this.myResolvedEnvironment;
                if (object2 == null || (object2 = object2.getTargetPortBindings()) == null) {
                    object2 = resolvedPorts = MapsKt.emptyMap();
                }
                if ((object = this.myJmxPortBinding) == null) break block2;
                TargetEnvironment.TargetPortBinding targetPortBinding = object;
                boolean bl = false;
                boolean bl2 = false;
                TargetEnvironment.TargetPortBinding it = targetPortBinding;
                boolean bl3 = false;
                object = (Integer)resolvedPorts.get(it);
                if (object != null) {
                    targetPortBinding = object;
                    bl = false;
                    bl2 = false;
                    int port = ((Number)targetPortBinding).intValue();
                    boolean bl4 = false;
                    processHandler.putUserData(SpringBootApplicationLifecycleManager.JMX_PORT, (Object)port);
                }
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/spring/boot/run/SpringBootJmxSetup$RemoteSetup$Companion;", "", "()V", "addPropertyIfNotSetAlready", "", "Lcom/intellij/execution/configurations/ParametersList;", "propertyName", "", "propertyValue", "intellij.spring.boot.run"})
        public static final class Companion {
            private final void addPropertyIfNotSetAlready(ParametersList $this$addPropertyIfNotSetAlready, String propertyName, String propertyValue) {
                String string = $this$addPropertyIfNotSetAlready.getPropertyValue(propertyName);
                if (string == null) {
                    $this$addPropertyIfNotSetAlready.addProperty(propertyName, propertyValue);
                    string = Unit.INSTANCE;
                }
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/boot/run/SpringBootJmxSetup$Companion;", "", "()V", "ANY_HOST", "", "DEFAULT_JMX_REGISTRY_PORT", "", "JMX_REGISTRY_HOST", "JMX_REGISTRY_PORT", "JMX_REMOTE_AUTH", "JMX_REMOTE_SSL", "JMX_RMI_SERVER_HOST", "JMX_RMI_SERVER_PORT", "intellij.spring.boot.run"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

