/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.application.ApplicationCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.microservices.config.ConfigTunnelPortMapping;
import com.intellij.microservices.http.request.NavigatorHttpRequest;
import com.intellij.microservices.utils.PortBindingNotificationPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootJmxSetup;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationUrlUtil;
import com.intellij.spring.boot.run.update.TriggerFilePolicy;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootCommandLineState
extends ApplicationCommandLineState<SpringBootApplicationRunConfiguration> {
    static final String DEBUG_PARAMETER = "-Ddebug";
    static final String TIERED_STOP_AT_LEVEL_1_PARAMETER = "-XX:TieredStopAtLevel=1";
    static final String NO_VERIFY_PARAMETER = "-noverify";
    static final String HIDE_BANNER_PARAMETER = "-Dspring.main.show_banner=false";
    static final String HIDE_BANNER_PARAMETER_1_5 = "-Dspring.main.banner-mode=OFF";
    static final String ACTIVE_PROFILES_PARAMETER = "-Dspring.profiles.active";
    static final String TRIGGER_FILE_PARAMETER = "-Dspring.devtools.restart.trigger-file";
    static final String OUTPUT_ANSI_ENABLED_PARAMETER = "-Dspring.output.ansi.enabled=always";
    static final String JMX_REMOTE_PARAMETER = "-Dcom.sun.management.jmxremote";
    static final String SPRING_JMX_PARAMETER = "-Dspring.jmx.enabled=true";
    static final String LIVE_BEAN_PARAMETER = "-Dspring.liveBeansView.mbeanDomain";
    static final String LIFECYCLE_PARAMETER = "-Dspring.application.admin.enabled=true";
    private static final int DEFAULT_SERVER_PORT = 8080;
    private static final String SERVER_PORT_PROPERTY = "server.port";
    private SpringBootJmxSetup myJmxSetup;
    private TargetEnvironment myResolvedEnvironment;
    private volatile int myServerPort;

    SpringBootCommandLineState(@NotNull SpringBootApplicationRunConfiguration configuration, ExecutionEnvironment environment) {
        if (configuration == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(0);
        }
        super((ModuleBasedConfiguration)configuration, environment);
        this.myServerPort = -1;
    }

    public void prepareTargetEnvironmentRequest(@NotNull TargetEnvironmentRequest request, @NotNull TargetProgressIndicator targetProgressIndicator) throws ExecutionException {
        if (request == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(1);
        }
        if (targetProgressIndicator == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(2);
        }
        JavaParameters javaParams = this.getJavaParameters();
        this.exposeServerHttpPort(javaParams, request);
        this.setupJmxParameters(javaParams, request);
        super.prepareTargetEnvironmentRequest(request, targetProgressIndicator);
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters params = super.createJavaParameters();
        this.applySpringBootSettings(params);
        return params;
    }

    protected boolean isProvidedScopeIncluded() {
        return ((SpringBootApplicationRunConfiguration)this.myConfiguration).isIncludeProvidedScope();
    }

    private void applySpringBootSettings(JavaParameters params) {
        ParametersList vmParametersList = params.getVMParametersList();
        for (SpringBootAdditionalParameter parameter : ((SpringBootApplicationRunConfiguration)this.myConfiguration).getAdditionalParameters()) {
            if (!parameter.isEnabled()) continue;
            String parameterValue = parameter.getValue();
            if (StringUtil.isNotEmpty((String)parameterValue)) {
                vmParametersList.add("-D" + parameter.getName() + "=" + parameterValue);
                continue;
            }
            vmParametersList.add("-D" + parameter.getName());
        }
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).isDebugMode()) {
            vmParametersList.add(DEBUG_PARAMETER);
        }
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).isEnableLaunchOptimization()) {
            vmParametersList.add(TIERED_STOP_AT_LEVEL_1_PARAMETER);
            vmParametersList.add(NO_VERIFY_PARAMETER);
        }
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).isHideBanner()) {
            if (SpringBootLibraryUtil.isAtLeastVersion(((SpringBootApplicationRunConfiguration)this.myConfiguration).getModule(), SpringBootLibraryUtil.SpringBootVersion.VERSION_1_5_0)) {
                vmParametersList.add(HIDE_BANNER_PARAMETER_1_5);
            } else {
                vmParametersList.add(HIDE_BANNER_PARAMETER);
            }
        }
        if (StringUtil.isNotEmpty((String)((SpringBootApplicationRunConfiguration)this.myConfiguration).getActiveProfiles())) {
            vmParametersList.add("-Dspring.profiles.active=" + ((SpringBootApplicationRunConfiguration)this.myConfiguration).getActiveProfiles());
        }
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).getUpdateActionUpdatePolicy() instanceof TriggerFilePolicy) {
            vmParametersList.add("-Dspring.devtools.restart.trigger-file=.restartTriggerFile");
        }
        vmParametersList.add(OUTPUT_ANSI_ENABLED_PARAMETER);
    }

    private void setupJmxParameters(JavaParameters params, TargetEnvironmentRequest targetRequest) throws ExecutionException {
        if (!((SpringBootApplicationRunConfiguration)this.myConfiguration).isEnableJmxAgent()) {
            return;
        }
        Boolean isBelow13 = (Boolean)ReadAction.compute(() -> SpringBootLibraryUtil.isBelowVersion(((SpringBootApplicationRunConfiguration)this.myConfiguration).getModule(), SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0));
        if (isBelow13.booleanValue()) {
            return;
        }
        ParametersList vmParametersList = params.getVMParametersList();
        vmParametersList.add(JMX_REMOTE_PARAMETER);
        vmParametersList.add(SPRING_JMX_PARAMETER);
        vmParametersList.add(LIVE_BEAN_PARAMETER);
        vmParametersList.add(LIFECYCLE_PARAMETER);
        this.myJmxSetup = targetRequest instanceof LocalTargetEnvironmentRequest ? new SpringBootJmxSetup.LocalSetup() : new SpringBootJmxSetup.RemoteSetup();
        this.myJmxSetup.setupJmxParameters(params, targetRequest);
    }

    public void handleCreatedTargetEnvironment(@NotNull TargetEnvironment environment, @NotNull TargetProgressIndicator targetProgressIndicator) {
        if (environment == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(3);
        }
        if (targetProgressIndicator == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(4);
        }
        super.handleCreatedTargetEnvironment(environment, targetProgressIndicator);
        this.myResolvedEnvironment = environment;
        if (this.myJmxSetup != null) {
            this.myJmxSetup.handleCreatedEnvironment(environment);
        }
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        if (executor == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(5);
        }
        if (runner == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(6);
        }
        ExecutionResult result2 = super.execute(executor, runner);
        if (this.myJmxSetup != null) {
            this.myJmxSetup.setupProcessHandler(result2.getProcessHandler());
            SpringBootApplicationLifecycleManager.getInstance(((SpringBootApplicationRunConfiguration)this.getConfiguration()).getProject());
        }
        if (this.myResolvedEnvironment == null) {
            ExecutionResult executionResult = result2;
            if (executionResult == null) {
                SpringBootCommandLineState.$$$reportNull$$$0(7);
            }
            return executionResult;
        }
        Map portsMap = this.myResolvedEnvironment.getTargetPortBindings();
        ConfigTunnelPortMapping mapping = remotePort -> portsMap.entrySet().stream().filter(entry -> ((TargetEnvironment.TargetPortBinding)entry.getKey()).getTarget() == remotePort).findAny().map(entry -> (Integer)entry.getValue()).orElse(remotePort);
        result2.getProcessHandler().putUserData(ConfigTunnelPortMapping.MAPPING_KEY, (Object)mapping);
        if (this.myServerPort <= 0) {
            ExecutionResult executionResult = result2;
            if (executionResult == null) {
                SpringBootCommandLineState.$$$reportNull$$$0(8);
            }
            return executionResult;
        }
        int resolvedServerPort = mapping.getLocalPort(this.myServerPort);
        if (resolvedServerPort == this.myServerPort) {
            ExecutionResult executionResult = result2;
            if (executionResult == null) {
                SpringBootCommandLineState.$$$reportNull$$$0(9);
            }
            return executionResult;
        }
        ExecutionConsole console = result2.getExecutionConsole();
        if (!(console instanceof ConsoleViewImpl)) {
            ExecutionResult executionResult = result2;
            if (executionResult == null) {
                SpringBootCommandLineState.$$$reportNull$$$0(10);
            }
            return executionResult;
        }
        this.addPortBindingPanel((ConsoleViewImpl)console, result2.getProcessHandler(), this.myServerPort, resolvedServerPort);
        ExecutionResult executionResult = result2;
        if (executionResult == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(11);
        }
        return executionResult;
    }

    private void addPortBindingPanel(ConsoleViewImpl console, final ProcessHandler handler, int applicationPort, int resolvedPort) {
        ApplicationManager.getApplication().invokeLater(() -> {
            final PortBindingNotificationPanel notificationPanel = new PortBindingNotificationPanel(((SpringBootApplicationRunConfiguration)this.myConfiguration).getProject(), null, ((SpringBootApplicationRunConfiguration)this.myConfiguration).getName(), applicationPort, resolvedPort);
            notificationPanel.registerProcessListener(handler, (Disposable)console);
            NonOpaquePanel wrapper = new NonOpaquePanel((JComponent)notificationPanel);
            wrapper.setBorder(IdeBorderFactory.createBorder((int)8));
            console.addNotificationComponent((JComponent)wrapper);
            SpringBootApplicationLifecycleManager.getInstance(((SpringBootApplicationRunConfiguration)this.myConfiguration).getProject()).addInfoListener(new SpringBootApplicationLifecycleManager.InfoListener(){

                @Override
                public void infoAdded(@NotNull ProcessHandler processHandler, final @NotNull SpringBootApplicationInfo info) {
                    if (processHandler == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (info == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (processHandler.equals(handler)) {
                        info.getApplicationUrl().addPropertyListener(new LiveProperty.LivePropertyListener(){

                            @Override
                            public void propertyChanged() {
                                String applicationUrl = info.getApplicationUrl().getValue();
                                if (applicationUrl != null) {
                                    SpringBootApplicationUrlUtil urlUtil = SpringBootApplicationUrlUtil.getInstance();
                                    String mappingPath = ((SpringBootApplicationRunConfiguration)SpringBootCommandLineState.this.myConfiguration).getUrlPath();
                                    String servletPath = urlUtil.getServletPath(info, mappingPath);
                                    String requestUrl = urlUtil.getMappingUrl(applicationUrl, servletPath, mappingPath);
                                    NavigatorHttpRequest request = new NavigatorHttpRequest(requestUrl, "GET", Collections.emptyList(), Collections.emptyList());
                                    AppUIUtil.invokeOnEdt(() -> notificationPanel.setRequest(request));
                                }
                            }
                        });
                    }
                }

                @Override
                public void infoRemoved(@NotNull ProcessHandler processHandler, @NotNull SpringBootApplicationInfo info) {
                    if (processHandler == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (info == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (processHandler.equals(handler)) {
                        SpringBootApplicationLifecycleManager.getInstance(((SpringBootApplicationRunConfiguration)SpringBootCommandLineState.this.myConfiguration).getProject()).removeInfoListener(this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "processHandler";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "info";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/spring/boot/run/SpringBootCommandLineState$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "infoAdded";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "infoRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }, o -> Disposer.isDisposed((Disposable)console));
    }

    protected AnAction @NotNull [] createActions(ConsoleView console, ProcessHandler processHandler, Executor executor) {
        AnAction action;
        Object[] actions = super.createActions(console, processHandler, executor);
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).getUpdateActionUpdatePolicy() != null && (action = ActionManager.getInstance().getAction("UpdateRunningApplication")) != null) {
            AnAction[] anActionArray = (AnAction[])ArrayUtil.append((Object[])actions, (Object)action);
            if (anActionArray == null) {
                SpringBootCommandLineState.$$$reportNull$$$0(12);
            }
            return anActionArray;
        }
        if (actions == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(13);
        }
        return actions;
    }

    private void exposeServerHttpPort(@NotNull JavaParameters javaParams, @NotNull TargetEnvironmentRequest request) {
        if (javaParams == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(14);
        }
        if (request == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(15);
        }
        if (request instanceof LocalTargetEnvironmentRequest || !SpringBootLibraryUtil.hasRequestMappings(((SpringBootApplicationRunConfiguration)this.myConfiguration).getModule())) {
            return;
        }
        try {
            String serverPortString = Optional.ofNullable(this.findServerPort(javaParams)).orElse(String.valueOf(8080));
            this.myServerPort = Integer.parseInt(serverPortString);
        }
        catch (NumberFormatException e) {
            this.myServerPort = 8080;
        }
        request.getTargetPortBindings().add(new TargetEnvironment.TargetPortBinding(null, this.myServerPort));
    }

    @Nullable
    private String findServerPort(@NotNull JavaParameters javaParams) {
        SpringBootApplicationRunConfiguration runConfig;
        SpringBootAdditionalParameter additionalParameter;
        if (javaParams == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(16);
        }
        if ((additionalParameter = (SpringBootAdditionalParameter)ContainerUtil.find((runConfig = (SpringBootApplicationRunConfiguration)this.getConfiguration()).getAdditionalParameters(), next -> next.isEnabled() && SERVER_PORT_PROPERTY.equals(next.getName()))) != null) {
            return additionalParameter.getValue();
        }
        String fromVmOptions = javaParams.getVMParametersList().getPropertyValue(SERVER_PORT_PROPERTY);
        if (fromVmOptions != null && !fromVmOptions.isBlank()) {
            return fromVmOptions;
        }
        return (String)ReadAction.compute(() -> this.findServerPortInConfigs());
    }

    private String findServerPortInConfigs() {
        SpringBootApplicationRunConfiguration runConfig = (SpringBootApplicationRunConfiguration)this.getConfiguration();
        Set profiles = SpringProfileUtils.profilesFromString((String)runConfig.getActiveProfiles());
        Ref result2 = new Ref();
        SpringBootConfigValueSearcher.productionForProfiles(runConfig.getModule(), SERVER_PORT_PROPERTY, profiles).process((Processor<ConfigurationValueResult>)((Processor)nextResult -> {
            String value = nextResult.getValueText();
            if (value != null && !value.isEmpty() && !value.isBlank()) {
                result2.set((Object)value);
            }
            return result2.isNull();
        }));
        return (String)result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProgressIndicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/SpringBootCommandLineState";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/SpringBootCommandLineState";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepareTargetEnvironmentRequest";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleCreatedTargetEnvironment";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "exposeServerHttpPort";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findServerPort";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

