/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

final class SpringBootApplicationRunConfigurationProducer
extends JavaRunConfigurationProducerBase<SpringBootApplicationRunConfiguration> {
    SpringBootApplicationRunConfigurationProducer() {
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = SpringBootApplicationConfigurationTypeBase.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            SpringBootApplicationRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull SpringBootApplicationRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Module module;
        if (configuration == null) {
            SpringBootApplicationRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            SpringBootApplicationRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            SpringBootApplicationRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(module = context.getModule())) {
            return false;
        }
        Pair<PsiClass, PsiElement> classWithAnchor = SpringBootApplicationRunConfigurationProducer.findSpringBootApplication((PsiElement)sourceElement.get());
        if (classWithAnchor == null) {
            return false;
        }
        if (classWithAnchor.second != null) {
            sourceElement.set((Object)((PsiElement)classWithAnchor.second));
        }
        configuration.setSpringBootMainClass(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)classWithAnchor.first)));
        configuration.setGeneratedName();
        this.setupConfigurationModule(context, configuration);
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull SpringBootApplicationRunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            SpringBootApplicationRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SpringBootApplicationRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        Module configurationModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        if (!Comparing.equal((Object)context.getModule(), (Object)configurationModule)) {
            return false;
        }
        Pair<PsiClass, PsiElement> contextClassWithAnchor = SpringBootApplicationRunConfigurationProducer.findSpringBootApplication(context.getPsiLocation());
        if (contextClassWithAnchor == null) {
            return false;
        }
        String configFqn = configuration.getSpringBootMainClass();
        return Comparing.strEqual((String)configFqn, (String)((PsiClass)contextClassWithAnchor.first).getQualifiedName());
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        RunConfigurationModule runConfigurationModule;
        RunConfiguration configuration;
        if (self == null) {
            SpringBootApplicationRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (other == null) {
            SpringBootApplicationRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        return (configuration = other.getConfiguration()) instanceof ModuleBasedConfiguration && configuration instanceof CommonJavaRunConfigurationParameters && (runConfigurationModule = ((ModuleBasedConfiguration)configuration).getConfigurationModule()) instanceof JavaRunConfigurationModule;
    }

    @Nullable
    private static Pair<PsiClass, PsiElement> findSpringBootApplication(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return null;
        }
        UMethod uMethod = (UMethod)UastContextKt.getUastParentOfType((PsiElement)psiElement, UMethod.class);
        if (uMethod != null) {
            PsiClass mainClass = UastUtils.getMainMethodClass((UMethod)uMethod);
            if (mainClass == null) {
                return null;
            }
            UFile file = (UFile)UastContextKt.getUastParentOfType((PsiElement)psiElement, UFile.class);
            if (file == null) {
                return null;
            }
            PsiClass psiClass = SpringBootApplicationRunConfigurationProducer.findSpringBootApplication(mainClass, file);
            if (psiClass == null) {
                return null;
            }
            return Pair.create((Object)psiClass, null);
        }
        UFile file = (UFile)UastContextKt.toUElement((PsiElement)psiElement, UFile.class);
        if (file != null) {
            for (UClass uClass : file.getClasses()) {
                if (UastUtils.findMainInClass((UClass)uClass) == null) continue;
                PsiClass psiClass = SpringBootApplicationRunConfigurationProducer.findSpringBootApplication(uClass.getJavaPsi(), file);
                if (psiClass == null) {
                    return null;
                }
                return Pair.create((Object)psiClass, (Object)UElementKt.getSourcePsiElement((UElement)uClass));
            }
            return null;
        }
        PsiClass mainClass = ApplicationConfigurationType.getMainClass((PsiElement)psiElement);
        if (mainClass == null) {
            return null;
        }
        file = (UFile)UastContextKt.getUastParentOfType((PsiElement)psiElement, UFile.class);
        if (file == null) {
            return null;
        }
        PsiClass psiClass = SpringBootApplicationRunConfigurationProducer.findSpringBootApplication(mainClass, file);
        if (psiClass == null) {
            return null;
        }
        return Pair.pair((Object)psiClass, (Object)mainClass);
    }

    @Nullable
    private static PsiClass findSpringBootApplication(@NotNull PsiClass mainClass, @NotNull UFile file) {
        if (mainClass == null) {
            SpringBootApplicationRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (file == null) {
            SpringBootApplicationRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        if (SpringBootApplicationService.getInstance().isSpringApplication(mainClass)) {
            return mainClass;
        }
        if (mainClass.getContainingClass() != null) {
            return null;
        }
        for (UClass uClass : file.getClasses()) {
            PsiClass psiClass = SpringBootApplicationRunConfigurationProducer.findSpringBootApplication(mainClass, uClass);
            if (psiClass == null) continue;
            return psiClass;
        }
        return null;
    }

    @Nullable
    private static PsiClass findSpringBootApplication(@NotNull PsiClass mainClass, @NotNull UClass uClass) {
        if (mainClass == null) {
            SpringBootApplicationRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        if (uClass == null) {
            SpringBootApplicationRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        PsiClass psiClass = uClass.getJavaPsi();
        if (SpringBootApplicationService.getInstance().isSpringApplication(psiClass) && mainClass.equals(SpringBootApplicationService.getInstance().findMainClassCandidate(psiClass))) {
            return psiClass;
        }
        if (psiClass.getContainingClass() == null || psiClass.hasModifierProperty("static")) {
            for (UClass innerClass : uClass.getInnerClasses()) {
                psiClass = SpringBootApplicationRunConfigurationProducer.findSpringBootApplication(mainClass, innerClass);
                if (psiClass == null) continue;
                return psiClass;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/SpringBootApplicationRunConfigurationProducer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/SpringBootApplicationRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldReplace";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findSpringBootApplication";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

