/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.lifecycle.mappings.tab;

import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.mvc.SpringBootMvcBundle;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveRequestMapping;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveRequestMappingsModel;
import com.intellij.spring.boot.mvc.lifecycle.mappings.tab.RequestMappingsEndpointTabSettings;
import com.intellij.spring.boot.mvc.lifecycle.mappings.tab.RequestMappingsPanel;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.lifecycle.Endpoint;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationUrlUtil;
import com.intellij.spring.boot.run.lifecycle.tabs.EndpointTab;
import com.intellij.spring.boot.run.lifecycle.tabs.SpringBootEndpointsTabSettings;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestMappingsTab
extends EndpointTab<LiveRequestMappingsModel> {
    private static final String REQUEST_MAPPINGS = "REQUEST_MAPPINGS";
    private final List<LiveRequestMapping> myRequestMappings;
    private final JComponent myWrapper;
    private final RequestMappingsPanel myRequestMappingsPanel;
    private volatile boolean myMappingsEnabled;
    private final RequestMappingsEndpointTabSettings mySettings;

    public RequestMappingsTab(@NotNull Endpoint<LiveRequestMappingsModel> endpoint, @NotNull SpringBootApplicationRunConfigurationBase runConfiguration, @NotNull ProcessHandler processHandler) {
        if (endpoint == null) {
            RequestMappingsTab.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            RequestMappingsTab.$$$reportNull$$$0(1);
        }
        if (processHandler == null) {
            RequestMappingsTab.$$$reportNull$$$0(2);
        }
        super(endpoint, runConfiguration, processHandler);
        this.myRequestMappings = new ArrayList<LiveRequestMapping>();
        this.myMappingsEnabled = false;
        this.mySettings = RequestMappingsEndpointTabSettings.getInstance(this.getProject());
        this.myRequestMappingsPanel = new RequestMappingsPanel(this.getProject(), this.getRunConfiguration(), processHandler, ContainerUtil.newArrayList((Object[])new AnAction[]{new MarkAsDefaultAction(), new RestoreEmptyDefaultPathAction()}));
        this.myRequestMappingsPanel.setDefaultPath(runConfiguration.getUrlPath());
        Disposer.register((Disposable)this, (Disposable)this.myRequestMappingsPanel);
        this.myWrapper = DumbService.getInstance((Project)this.getProject()).wrapGently((JComponent)this.myRequestMappingsPanel, (Disposable)this);
        MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
        connection.subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                RunConfiguration changedConfiguration = settings.getConfiguration();
                if (RequestMappingsTab.this.getRunConfiguration().getName().equals(changedConfiguration.getName()) && changedConfiguration instanceof SpringBootApplicationRunConfigurationBase) {
                    String defaultPath = ((SpringBootApplicationRunConfigurationBase)changedConfiguration).getUrlPath();
                    RequestMappingsTab.this.getRunConfiguration().setUrlPath(defaultPath);
                    RequestMappingsTab.this.myRequestMappingsPanel.setDefaultPath(defaultPath);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/spring/boot/mvc/lifecycle/mappings/tab/RequestMappingsTab$1", "runConfigurationChanged"));
            }
        });
        connection.subscribe(SpringBootEndpointsTabSettings.TOPIC, (Object)new SpringBootEndpointsTabSettings.Listener(){

            @Override
            public void settingsChanged(@NotNull String changeType) {
                if (changeType == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (changeType.equals(RequestMappingsTab.REQUEST_MAPPINGS)) {
                    RequestMappingsTab.this.myRequestMappingsPanel.setItems(Collections.unmodifiableList(RequestMappingsTab.this.myRequestMappings));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeType", "com/intellij/spring/boot/mvc/lifecycle/mappings/tab/RequestMappingsTab$2", "settingsChanged"));
            }
        });
    }

    @Override
    public String getTitle() {
        return SpringBootMvcBundle.message("spring.boot.application.endpoints.mappings.tab.title", new Object[0]);
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = SpringApiIcons.RequestMapping;
        if (icon == null) {
            RequestMappingsTab.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @Override
    @NotNull
    protected List<AnAction> getToolbarActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add(new OpenInBrowserAction());
        actions.add((AnAction)new LiveRequestMethodActionGroup());
        actions.add((AnAction)Separator.getInstance());
        actions.add((AnAction)new EndpointTab.EndpointToggleAction(SpringBootMvcBundle.message("spring.boot.application.endpoints.mappings.show.library.mappings.action.name", new Object[0]), null, AllIcons.Nodes.PpLib){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                return RequestMappingsTab.this.mySettings.isShowLibraryMappings();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                RequestMappingsTab.this.mySettings.setShowLibraryMappings(state);
                SpringBootEndpointsTabSettings.getInstance(RequestMappingsTab.this.getProject()).fireSettingsChanged(RequestMappingsTab.REQUEST_MAPPINGS);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/tab/RequestMappingsTab$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList<AnAction> arrayList = actions;
        if (arrayList == null) {
            RequestMappingsTab.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected JComponent getEndpointComponent() {
        JComponent jComponent = this.myWrapper;
        if (jComponent == null) {
            RequestMappingsTab.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    @Override
    protected void doUpdateComponent(@Nullable LiveRequestMappingsModel model) {
        this.myRequestMappings.clear();
        if (model != null) {
            this.myRequestMappings.addAll(model.getRequestMappings());
        }
        this.myRequestMappingsPanel.setItems(Collections.unmodifiableList(this.myRequestMappings));
    }

    @Override
    public void checkAvailability() {
        super.checkAvailability();
        this.myMappingsEnabled = SpringBootLibraryUtil.hasRequestMappings(this.getRunConfiguration().getModule());
        if (this.isActuatorsEnabled() && !this.myMappingsEnabled) {
            this.showMessage(SpringBootMvcBundle.message("spring.boot.application.endpoints.mappings.disabled", new Object[0]));
        }
    }

    @Override
    public void updateRefreshAction(AnActionEvent e, @NotNull SpringBootApplicationInfo info) {
        if (info == null) {
            RequestMappingsTab.$$$reportNull$$$0(6);
        }
        super.updateRefreshAction(e, info);
        if (!this.myMappingsEnabled) {
            e.getPresentation().setEnabled(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/mvc/lifecycle/mappings/tab/RequestMappingsTab";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/tab/RequestMappingsTab";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateRefreshAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class OpenInBrowserAction
    extends AnAction {
        OpenInBrowserAction() {
            super(SpringBootMvcBundle.messagePointer("spring.boot.application.endpoints.mappings.open.in.browser.action.name", new Object[0]), AllIcons.Nodes.PpWeb);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenInBrowserAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = e.getPresentation();
            SpringBootApplicationInfo info = RequestMappingsTab.this.getInfo();
            String applicationUrl = info == null ? null : info.getApplicationUrl().getValue();
            presentation.setEnabled(applicationUrl != null);
            if (applicationUrl == null) {
                presentation.setDescription(SpringBootMvcBundle.messagePointer("spring.boot.application.endpoints.mappings.open.in.browser.action.description", new Object[0]));
            } else {
                presentation.setDescription(SpringBootMvcBundle.messagePointer("spring.boot.application.endpoints.mappings.open.url", applicationUrl));
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            SpringBootApplicationInfo info;
            if (e == null) {
                OpenInBrowserAction.$$$reportNull$$$0(1);
            }
            if ((info = RequestMappingsTab.this.getInfo()) == null) {
                return;
            }
            String applicationUrl = info.getApplicationUrl().getValue();
            if (applicationUrl != null) {
                SpringBootApplicationUrlUtil urlUtil = SpringBootApplicationUrlUtil.getInstance();
                String mappingPath = RequestMappingsTab.this.getRunConfiguration().getUrlPath();
                String servletPath = urlUtil.getServletPath(info, mappingPath);
                BrowserUtil.browse((String)urlUtil.getMappingUrl(applicationUrl, servletPath, mappingPath));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/tab/RequestMappingsTab$OpenInBrowserAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class LiveRequestMethodActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        LiveRequestMethodActionGroup() {
            this.setPopup(true);
            this.getTemplatePresentation().setText(SpringBootMvcBundle.messagePointer("spring.boot.application.endpoints.mappings.request.method.action.name", new Object[0]));
            this.getTemplatePresentation().setIcon(AllIcons.Nodes.Method);
            for (final RequestMethod method : RequestMethod.values()) {
                @NlsSafe String name = method.name();
                this.add((AnAction)new EndpointTab.EndpointToggleAction(name){

                    public boolean isSelected(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return !RequestMappingsTab.this.mySettings.getFilteredRequestMethods().contains(method);
                    }

                    public void setSelected(@NotNull AnActionEvent e, boolean state) {
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (state) {
                            RequestMappingsTab.this.mySettings.getFilteredRequestMethods().remove(method);
                        } else {
                            RequestMappingsTab.this.mySettings.getFilteredRequestMethods().add(method);
                        }
                        SpringBootEndpointsTabSettings.getInstance(RequestMappingsTab.this.getProject()).fireSettingsChanged(RequestMappingsTab.REQUEST_MAPPINGS);
                    }

                    @Override
                    public void update(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        super.update(e);
                        if (!e.getPresentation().isEnabled()) {
                            e.getPresentation().setVisible(false);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "e";
                        objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/tab/RequestMappingsTab$LiveRequestMethodActionGroup$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "isSelected";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "setSelected";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "update";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                LiveRequestMethodActionGroup.$$$reportNull$$$0(0);
            }
            RequestMappingsTab.this.updateActionPresentation(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/mvc/lifecycle/mappings/tab/RequestMappingsTab$LiveRequestMethodActionGroup", "update"));
        }
    }

    private class RestoreEmptyDefaultPathAction
    extends AnAction {
        RestoreEmptyDefaultPathAction() {
            super(SpringBootMvcBundle.messagePointer("spring.boot.application.endpoints.mappings.restore.empty.default.path.action.name", new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            LiveRequestMapping mapping;
            if (e == null) {
                RestoreEmptyDefaultPathAction.$$$reportNull$$$0(0);
            }
            String path = (mapping = RequestMappingsTab.this.myRequestMappingsPanel.getSelectedMapping()) != null ? mapping.getPath() : null;
            e.getPresentation().setEnabledAndVisible(path != null && path.equals(RequestMappingsTab.this.getRunConfiguration().getUrlPath()));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreEmptyDefaultPathAction.$$$reportNull$$$0(1);
            }
            SpringBootApplicationUrlUtil.getInstance().updatePath(RequestMappingsTab.this.getProject(), RequestMappingsTab.this.getRunConfiguration(), "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/tab/RequestMappingsTab$RestoreEmptyDefaultPathAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MarkAsDefaultAction
    extends AnAction {
        MarkAsDefaultAction() {
            super(SpringBootMvcBundle.messagePointer("spring.boot.application.endpoints.mappings.mark.default.action.name", new Object[0]), AllIcons.Actions.SetDefault);
        }

        public void update(@NotNull AnActionEvent e) {
            LiveRequestMapping mapping;
            if (e == null) {
                MarkAsDefaultAction.$$$reportNull$$$0(0);
            }
            String path = (mapping = RequestMappingsTab.this.myRequestMappingsPanel.getSelectedMapping()) != null ? mapping.getPath() : null;
            e.getPresentation().setEnabledAndVisible(path != null && !path.equals(RequestMappingsTab.this.getRunConfiguration().getUrlPath()) && mapping.canNavigate());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            LiveRequestMapping mapping;
            String path;
            if (e == null) {
                MarkAsDefaultAction.$$$reportNull$$$0(1);
            }
            String string = path = (mapping = RequestMappingsTab.this.myRequestMappingsPanel.getSelectedMapping()) != null ? mapping.getPath() : null;
            if (path == null) {
                return;
            }
            SpringBootApplicationUrlUtil.getInstance().updatePath(RequestMappingsTab.this.getProject(), RequestMappingsTab.this.getRunConfiguration(), path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/tab/RequestMappingsTab$MarkAsDefaultAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

