/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.mvc.SpringBootMvcBundle;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl.LiveRequestMappingPredicate;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl.LiveRequestMappingPredicateParser;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

class RouterPredicateParser
extends LiveRequestMappingPredicateParser {
    static LiveRequestMappingPredicateParser INSTANCE = new RouterPredicateParser();

    RouterPredicateParser() {
    }

    @Override
    @NotNull
    protected List<LiveRequestMappingPredicate> parseMapping(@NotNull String mapping) {
        List list;
        if (mapping == null) {
            RouterPredicateParser.$$$reportNull$$$0(0);
        }
        try {
            RouterPredicateExpression expression = RouterPredicateParser.parseExpression(mapping);
            List<RouterPredicateBuilder> builders = expression.eval(false);
            list = ContainerUtil.mapNotNull(builders, RouterPredicateBuilder::build);
        }
        catch (RouterPredicateParserException e) {
            RouterPredicateBuilder builder = new RouterPredicateBuilder();
            builder.path = mapping;
            return new SmartList((Object)builder.build());
        }
        if (list == null) {
            RouterPredicateParser.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static RouterPredicateExpression parseExpression(String mapping) {
        Queue<String> tokens = RouterPredicateParser.tokenize(mapping);
        return RouterPredicateParser.parseTokens(tokens, Context.NONE);
    }

    private static Queue<String> tokenize(String mapping) {
        ArrayDeque<String> result2 = new ArrayDeque<String>();
        int position = 0;
        int start = 0;
        while (position < mapping.length()) {
            char operator;
            char next = mapping.charAt(position);
            Object delimiter = null;
            if (next == '(' || next == ')' || next == '!') {
                delimiter = String.valueOf(next);
            } else if ((next == '&' || next == '|') && position + 1 < mapping.length() && (operator = mapping.charAt(position + 1)) == next) {
                delimiter = String.valueOf(next) + operator;
            }
            if (delimiter != null) {
                if (position > start) {
                    result2.add(mapping.substring(start, position));
                }
                result2.add((String)delimiter);
                start = position += ((String)delimiter).length();
                continue;
            }
            ++position;
        }
        return result2;
    }

    private static RouterPredicateExpression parseTokens(Queue<String> tokens, Context context) {
        ArrayList<RouterPredicateExpression> elements = new ArrayList<RouterPredicateExpression>();
        Operator operator = null;
        block14: while (!tokens.isEmpty()) {
            String token = tokens.poll().trim();
            if (token.isEmpty()) continue;
            switch (token) {
                case "(": {
                    RouterPredicateExpression contents = RouterPredicateParser.parseTokens(tokens, Context.BRACKET);
                    if (context == Context.INVERT) {
                        return contents;
                    }
                    elements.add(contents);
                    continue block14;
                }
                case "&&": {
                    RouterPredicateParser.assertWellFormed(operator == null);
                    operator = Operator.AND;
                    continue block14;
                }
                case "||": {
                    RouterPredicateParser.assertWellFormed(operator == null);
                    operator = Operator.OR;
                    continue block14;
                }
                case "!": {
                    elements.add(RouterPredicateParser.not(RouterPredicateParser.parseTokens(tokens, Context.INVERT)));
                    continue block14;
                }
                case ")": {
                    RouterPredicateExpression merged = RouterPredicateParser.merge(elements, operator);
                    if (context == Context.BRACKET) {
                        return merged;
                    }
                    elements.clear();
                    elements.add(merged);
                    operator = null;
                    continue block14;
                }
            }
            RouterPredicateExpression value = RouterPredicateParser.value(token);
            if (context == Context.INVERT) {
                return value;
            }
            elements.add(value);
        }
        return RouterPredicateParser.merge(elements, operator);
    }

    private static RouterPredicateExpression merge(List<RouterPredicateExpression> elements, Operator operator) {
        RouterPredicateParser.assertWellFormed(!elements.isEmpty() && elements.size() <= 2);
        if (elements.size() == 1) {
            return elements.get(0);
        }
        return operator == Operator.AND ? RouterPredicateParser.and(elements.get(0), elements.get(1)) : RouterPredicateParser.or(elements.get(0), elements.get(1));
    }

    private static void assertWellFormed(boolean wellFormed) {
        if (!wellFormed) {
            throw new RouterPredicateParserException(SpringBootMvcBundle.message("spring.boot.application.endpoints.mappings.malformed.router.predicate", new Object[0]));
        }
    }

    private static void assertMatchable(boolean matchable) {
        if (!matchable) {
            throw new RouterPredicateParserException(SpringBootMvcBundle.message("spring.boot.application.endpoints.mappings.unmatchable.router.predicate", new Object[0]));
        }
    }

    private static RouterPredicateExpression not(RouterPredicateExpression expression) {
        return negative -> expression.eval(!negative);
    }

    private static RouterPredicateExpression and(RouterPredicateExpression left, RouterPredicateExpression right) {
        return negative -> {
            List<RouterPredicateBuilder> leftBuilders = left.eval(negative);
            List<RouterPredicateBuilder> rightBuilders = right.eval(negative);
            if (leftBuilders.isEmpty()) {
                return rightBuilders;
            }
            if (rightBuilders.isEmpty()) {
                return leftBuilders;
            }
            SmartList result2 = new SmartList();
            if (!rightBuilders.isEmpty()) {
                for (RouterPredicateBuilder leftBuilder : leftBuilders) {
                    for (RouterPredicateBuilder rightBuilder : rightBuilders) {
                        result2.add(leftBuilder.append(rightBuilder));
                    }
                }
            }
            return result2;
        };
    }

    private static RouterPredicateExpression or(RouterPredicateExpression left, RouterPredicateExpression right) {
        return negative -> {
            List<RouterPredicateBuilder> leftBuilders = left.eval(negative);
            List<RouterPredicateBuilder> rightBuilders = right.eval(negative);
            if (leftBuilders.isEmpty()) {
                return rightBuilders;
            }
            if (rightBuilders.isEmpty()) {
                return leftBuilders;
            }
            LinkedHashSet<RouterPredicateBuilder> result2 = new LinkedHashSet<RouterPredicateBuilder>();
            for (RouterPredicateBuilder leftBuilder : leftBuilders) {
                for (RouterPredicateBuilder rightBuilder : rightBuilders) {
                    RouterPredicateBuilder combinedBuilder = leftBuilder.combine(rightBuilder);
                    if (combinedBuilder != null) {
                        result2.add(combinedBuilder);
                        continue;
                    }
                    result2.add(leftBuilder);
                    result2.add(rightBuilder);
                }
            }
            return new SmartList(result2);
        };
    }

    private static boolean isPath(String token) {
        return token.startsWith("/");
    }

    private static boolean isRequestMethod(String token) {
        try {
            RequestMethod.valueOf((String)token);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static RouterPredicateExpression value(String token) {
        if (RouterPredicateParser.isPath(token)) {
            return negative -> {
                RouterPredicateParser.assertMatchable(!negative);
                RouterPredicateBuilder builder = new RouterPredicateBuilder();
                builder.path = token;
                return new SmartList((Object)builder);
            };
        }
        if (RouterPredicateParser.isRequestMethod(token)) {
            return negative -> {
                RouterPredicateBuilder builder = new RouterPredicateBuilder();
                if (negative) {
                    builder.requestMethods = ContainerUtil.map((Object[])RequestMethod.values(), Objects::toString);
                    builder.requestMethods.remove(token);
                } else {
                    builder.requestMethods = new SmartList((Object)token);
                }
                return new SmartList((Object)builder);
            };
        }
        if (token.startsWith("Accept: ")) {
            String produces = token.substring("Accept: ".length()).trim();
            return negative -> {
                RouterPredicateBuilder builder = new RouterPredicateBuilder();
                builder.produces = new SmartList(negative ? "!" + produces : produces);
                return new SmartList((Object)builder);
            };
        }
        if (token.startsWith("Content-Type: ")) {
            String consumes = token.substring("Content-Type: ".length()).trim();
            return negative -> {
                RouterPredicateBuilder builder = new RouterPredicateBuilder();
                builder.consumes = new SmartList(negative ? "!" + consumes : consumes);
                return new SmartList((Object)builder);
            };
        }
        int headerSeparator = token.indexOf(58);
        if (headerSeparator > 0 && headerSeparator < token.length() - 1) {
            Pair header = Pair.create((Object)token.substring(0, headerSeparator).trim(), (Object)token.substring(headerSeparator + 1).trim());
            if (!StringUtil.isEmpty((String)((String)header.first)) && !StringUtil.isEmpty((String)((String)header.second))) {
                return negative -> {
                    RouterPredicateBuilder builder = new RouterPredicateBuilder();
                    builder.headers = new SmartList((Object)(negative ? Pair.create((Object)("!" + (String)header.first), (Object)((String)header.second)) : header));
                    return new SmartList((Object)builder);
                };
            }
        }
        int paramSeparator = token.indexOf(" ");
        if (token.startsWith("?") && paramSeparator > 1 && paramSeparator < token.length() - 1) {
            Pair param = Pair.create((Object)token.substring(1, paramSeparator).trim(), (Object)token.substring(paramSeparator + 1).trim());
            if (!StringUtil.isEmpty((String)((String)param.first)) && !StringUtil.isEmpty((String)((String)param.second))) {
                return negative -> {
                    RouterPredicateBuilder builder = new RouterPredicateBuilder();
                    builder.params = new SmartList((Object)(negative ? Pair.create((Object)("!" + (String)param.first), (Object)((String)param.second)) : param));
                    return new SmartList((Object)builder);
                };
            }
        }
        return negative -> new SmartList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/RouterPredicateParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/RouterPredicateParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseMapping";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RouterPredicateParserException
    extends RuntimeException {
        RouterPredicateParserException(String message) {
            super(message);
        }
    }

    private static interface RouterPredicateExpression {
        public List<RouterPredicateBuilder> eval(boolean var1);
    }

    private static class RouterPredicateBuilder {
        String path;
        List<String> requestMethods;
        List<Pair<String, String>> headers;
        List<String> produces;
        List<String> consumes;
        List<Pair<String, String>> params;

        RouterPredicateBuilder() {
        }

        RouterPredicateBuilder(RouterPredicateBuilder builder) {
            this.path = builder.path;
            this.requestMethods = builder.requestMethods;
            this.headers = builder.headers;
            this.produces = builder.produces;
            this.consumes = builder.consumes;
            this.params = builder.params;
        }

        LiveRequestMappingPredicate build() {
            if (this.path == null) {
                return null;
            }
            return new LiveRequestMappingPredicate(this.path, this.requestMethods == null ? Collections.emptyList() : this.requestMethods, this.headers == null ? Collections.emptyList() : this.headers, this.produces == null ? Collections.emptyList() : this.produces, this.consumes == null ? Collections.emptyList() : this.consumes, this.params == null ? Collections.emptyList() : this.params);
        }

        RouterPredicateBuilder append(RouterPredicateBuilder builder) {
            RouterPredicateBuilder commonBuilder = new RouterPredicateBuilder(this);
            if (commonBuilder.path == null) {
                commonBuilder.path = builder.path;
            } else {
                RouterPredicateBuilder.assertEqual(commonBuilder.path, builder.path);
            }
            if (commonBuilder.requestMethods == null) {
                commonBuilder.requestMethods = builder.requestMethods;
            } else {
                RouterPredicateBuilder.assertEqual(commonBuilder.requestMethods, builder.requestMethods);
            }
            if (commonBuilder.produces == null) {
                commonBuilder.produces = builder.produces;
            } else {
                RouterPredicateBuilder.assertEqual(commonBuilder.produces, builder.produces);
            }
            if (commonBuilder.consumes == null) {
                commonBuilder.consumes = builder.consumes;
            } else {
                RouterPredicateBuilder.assertEqual(commonBuilder.consumes, builder.consumes);
            }
            if (commonBuilder.headers == null) {
                commonBuilder.headers = builder.headers;
            } else if (builder.headers != null) {
                commonBuilder.headers.addAll(builder.headers);
            }
            if (commonBuilder.params == null) {
                commonBuilder.params = builder.params;
            } else if (builder.params != null) {
                commonBuilder.params.addAll(builder.params);
            }
            return commonBuilder;
        }

        RouterPredicateBuilder combine(RouterPredicateBuilder builder) {
            if (Objects.equals(this.path, builder.path) && Comparing.equal(this.headers, builder.headers) && Comparing.equal(this.params, builder.params)) {
                RouterPredicateBuilder commonBuilder = new RouterPredicateBuilder(this);
                if (commonBuilder.requestMethods == null) {
                    commonBuilder.requestMethods = builder.requestMethods;
                } else if (builder.requestMethods != null) {
                    commonBuilder.requestMethods.addAll(builder.requestMethods);
                }
                if (commonBuilder.produces == null) {
                    commonBuilder.produces = builder.produces;
                } else if (builder.produces != null) {
                    commonBuilder.produces.addAll(builder.produces);
                }
                if (commonBuilder.consumes == null) {
                    commonBuilder.consumes = builder.consumes;
                } else if (builder.consumes != null) {
                    commonBuilder.consumes.addAll(builder.consumes);
                }
                return commonBuilder;
            }
            return null;
        }

        private static void assertEqual(Object left, Object right) {
            RouterPredicateParser.assertMatchable(right == null || right.equals(left));
        }
    }

    private static enum Context {
        NONE,
        INVERT,
        BRACKET;

    }

    private static enum Operator {
        AND,
        OR;

    }
}

