/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config.viewresolver;

import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.boot.mvc.config.viewresolver.SpringBootAutoConfigurationViewResolverFactoryBase;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafWebMvcAutoConfigurationViewResolverFactory
extends SpringBootAutoConfigurationViewResolverFactoryBase {
    @NonNls
    static final String THYMELEAF_2_VIEW_RESOLVER = "org.thymeleaf.spring4.view.ThymeleafViewResolver";
    @NonNls
    static final String THYMELEAF_3_VIEW_RESOLVER = "org.thymeleaf.spring5.view.ThymeleafViewResolver";
    private static final Set<String> VIEW_RESOLVER_CLASSES = ContainerUtil.immutableSet((Object[])new String[]{"org.thymeleaf.spring4.view.ThymeleafViewResolver", "org.thymeleaf.spring5.view.ThymeleafViewResolver"});
    private static final Set<String> AUTOCONFIG_CLASSES = ContainerUtil.immutableSet((Object[])new String[]{"org.springframework.boot.autoconfigure.thymeleaf.ThymeleafAutoConfiguration.ThymeleafViewResolverConfiguration", "org.springframework.boot.autoconfigure.thymeleaf.AbstractThymeleafViewResolverConfiguration", "org.springframework.boot.autoconfigure.thymeleaf.ThymeleafAutoConfiguration.ThymeleafWebMvcConfiguration.ThymeleafViewResolverConfiguration"});
    @NonNls
    static final String SPRING_THYMELEAF_PREFIX = "spring.thymeleaf.prefix";
    @NonNls
    static final String SPRING_THYMELEAF_SUFFIX = "spring.thymeleaf.suffix";

    @Override
    @NotNull
    protected String getViewResolverBeanName() {
        return "thymeleafViewResolver";
    }

    @Override
    @NotNull
    protected Set<String> getViewResolverClassNames() {
        Set<String> set = VIEW_RESOLVER_CLASSES;
        if (set == null) {
            ThymeleafWebMvcAutoConfigurationViewResolverFactory.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    protected Set<String> getAutoConfigurationClassNames() {
        Set<String> set = AUTOCONFIG_CLASSES;
        if (set == null) {
            ThymeleafWebMvcAutoConfigurationViewResolverFactory.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    protected Set<ViewResolver> createViewResolvers(@Nullable CommonSpringBean bean, CommonSpringModel model) {
        String prefix = ThymeleafWebMvcAutoConfigurationViewResolverFactory.getConfigurationOrDefaultValue(model, SPRING_THYMELEAF_PREFIX);
        String suffix = ThymeleafWebMvcAutoConfigurationViewResolverFactory.getConfigurationOrDefaultValue(model, SPRING_THYMELEAF_SUFFIX);
        Set<ViewResolver> resolvers = super.createViewResolvers(bean, model);
        resolvers.add(this.createURLBasedViewResolver(model.getModule(), "", prefix, suffix));
        Set<ViewResolver> set = resolvers;
        if (set == null) {
            ThymeleafWebMvcAutoConfigurationViewResolverFactory.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/mvc/config/viewresolver/ThymeleafWebMvcAutoConfigurationViewResolverFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewResolverClassNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoConfigurationClassNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewResolvers";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

