/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config;

import com.intellij.javaee.web.WebUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.uast.UastMetaLanguage;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/spring/boot/mvc/config/SpringBootStaticWebFileReferenceHelper;", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper;", "()V", "SPRING_RESOURCES_STATIC_LOCATIONS", "", "pathsSeparator", "Lkotlin/text/Regex;", "resolveRecursionGuard", "Lcom/intellij/openapi/util/RecursionGuard;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getContexts", "", "Lcom/intellij/psi/PsiFileSystemItem;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLocationsFromConfig", "", "module", "Lcom/intellij/openapi/module/Module;", "getRoots", "getStaticLocationRoots", "getStaticResolvers", "", "Lcom/intellij/spring/mvc/views/ViewResolver;", "isMine", "", "resolveToFSItem", "path", "intellij.spring.boot.mvc"})
public final class SpringBootStaticWebFileReferenceHelper
extends FileReferenceHelper {
    @NonNls
    private static final String SPRING_RESOURCES_STATIC_LOCATIONS;
    private static final Regex pathsSeparator;
    private static final RecursionGuard<Object> resolveRecursionGuard;
    @NotNull
    public static final SpringBootStaticWebFileReferenceHelper INSTANCE;

    @NotNull
    public Collection<PsiFileSystemItem> getContexts(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026ct) ?: return emptyList()");
        Module module2 = module;
        return this.getStaticLocationRoots(module2);
    }

    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.getStaticLocationRoots(module);
    }

    public boolean isMine(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        DumbService dumbService = DumbService.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(project)");
        if (dumbService.isDumb()) {
            return false;
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(project)) {
            return false;
        }
        if (WebUtil.isInsideWebRoots((VirtualFile)file, (Project)project)) {
            return true;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(p\u2026ile(file) ?: return false");
        PsiFile psiFile2 = psiFile;
        if (((UastMetaLanguage)Language.findInstance(UastMetaLanguage.class)).matchesLanguage(psiFile2.getLanguage())) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiFileSystemItem> getStaticLocationRoots(Module module) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getLocationsFromConfig(module);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiFileSystemItem psiFileSystemItem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String path = (String)element$iv$iv;
            boolean bl2 = false;
            if ((PsiFileSystemItem)CollectionsKt.firstOrNull((Iterable)INSTANCE.resolveToFSItem(path, module)) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            PsiFileSystemItem it$iv$iv = psiFileSystemItem;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> getLocationsFromConfig(Module module) {
        Object object;
        block5: {
            block4: {
                Object object2 = new SmartList();
                boolean bl = false;
                int n = 0;
                SmartList collector = object2;
                boolean bl2 = false;
                SpringBootConfigValueSearcher.Companion.productionForProfiles(module, SPRING_RESOURCES_STATIC_LOCATIONS, null).process((Processor<ConfigurationValueResult>)new Processor(collector){
                    final /* synthetic */ SmartList $collector;

                    public final boolean process(ConfigurationValueResult it) {
                        block1: {
                            Object object = it.getValueText();
                            if (object == null) break block1;
                            Object object2 = (CharSequence)object;
                            Regex regex = SpringBootStaticWebFileReferenceHelper.access$getPathsSeparator$p(SpringBootStaticWebFileReferenceHelper.INSTANCE);
                            int n = 0;
                            boolean bl = false;
                            object = regex.split((CharSequence)object2, n);
                            if (object != null) {
                                object2 = object;
                                regex = this.$collector;
                                n = 0;
                                bl = false;
                                Collection p1 = (Collection)object2;
                                boolean bl2 = false;
                                regex.addAll(p1);
                            }
                        }
                        return true;
                    }
                    {
                        this.$collector = smartList;
                    }
                });
                SmartList explicitlyDefinedValues2 = object2;
                object2 = (Collection)explicitlyDefinedValues2;
                bl = false;
                if (!object2.isEmpty()) {
                    return (List)explicitlyDefinedValues2;
                }
                object = SpringBootApplicationMetaConfigKeyManager.getInstance().findApplicationMetaConfigKey(module, SPRING_RESOURCES_STATIC_LOCATIONS);
                if (object == null || (object = object.getDefaultValue()) == null) break block4;
                object2 = (CharSequence)object;
                Regex regex = pathsSeparator;
                n = 0;
                boolean bl3 = false;
                object = regex.split((CharSequence)object2, n);
                if (object != null) break block5;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<ViewResolver> getStaticResolvers(@NotNull Module module) {
        void var3_3;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Iterable iterable = this.getLocationsFromConfig(module);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void location;
            String string = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            UrlBasedViewResolver urlBasedViewResolver = new UrlBasedViewResolver((String)location, module, "SpringBootStaticWebFileViewResolver", (String)location, null, null, module){
                final /* synthetic */ String $location;
                final /* synthetic */ Module $module$inlined;
                {
                    this.$location = $captured_local_variable$1;
                    this.$module$inlined = module;
                    super($super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
                }

                @Nullable
                public Collection<PsiFileSystemItem> getRoots() {
                    String string = this.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
                    Module module = this.getModule();
                    Intrinsics.checkNotNullExpressionValue((Object)module, (String)"this.module");
                    return SpringBootStaticWebFileReferenceHelper.access$resolveToFSItem(SpringBootStaticWebFileReferenceHelper.INSTANCE, string, module);
                }

                public boolean isAbsolutePathRequired() {
                    return true;
                }
            };
            collection.add(urlBasedViewResolver);
        }
        return (Set)var3_3;
    }

    private final Collection<PsiFileSystemItem> resolveToFSItem(String path, Module module) {
        Collection collection = (Collection)resolveRecursionGuard.doPreventingRecursion((Object)path, false, new Computable(module, path){
            final /* synthetic */ Module $module;
            final /* synthetic */ String $path;

            public final Collection<PsiFileSystemItem> compute() {
                SpringResourcesBuilder builder = SpringResourcesBuilder.create((Module)this.$module, (String)this.$path, (int)0).fromRoot(StringsKt.startsWith$default((String)this.$path, (String)"/", (boolean)false, (int)2, null)).endingSlashNotAllowed(false);
                PsiReference[] references = SpringResourcesUtil.getInstance().getReferences(builder);
                return SpringResourcesUtil.getInstance().getResourceItems(references, Conditions.alwaysTrue());
            }
            {
                this.$module = module;
                this.$path = string;
            }
        });
        if (collection == null) {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    private SpringBootStaticWebFileReferenceHelper() {
    }

    static {
        SpringBootStaticWebFileReferenceHelper springBootStaticWebFileReferenceHelper;
        INSTANCE = springBootStaticWebFileReferenceHelper = new SpringBootStaticWebFileReferenceHelper();
        SPRING_RESOURCES_STATIC_LOCATIONS = "spring.resources.static-locations";
        String string = "\\s*,\\s*";
        boolean bl = false;
        pathsSeparator = new Regex(string);
        RecursionGuard recursionGuard = RecursionManager.createGuard((String)"SpringBootStaticWebFileReferenceHelperRecursionGuard");
        Intrinsics.checkNotNullExpressionValue((Object)recursionGuard, (String)"RecursionManager.createG\u2026nceHelperRecursionGuard\")");
        resolveRecursionGuard = recursionGuard;
    }

    public static final /* synthetic */ Regex access$getPathsSeparator$p(SpringBootStaticWebFileReferenceHelper $this) {
        SpringBootStaticWebFileReferenceHelper springBootStaticWebFileReferenceHelper = $this;
        return pathsSeparator;
    }

    public static final /* synthetic */ Collection access$resolveToFSItem(SpringBootStaticWebFileReferenceHelper $this, String path, Module module) {
        return $this.resolveToFSItem(path, module);
    }
}

