/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.properties;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.spring.boot.application.config.SpringBootConfigurationPropertyReferenceSearcher;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import org.jetbrains.annotations.NotNull;

public class ConfigurationPropertiesImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            ConfigurationPropertiesImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiMethod) {
            return ConfigurationPropertiesImplicitUsageProvider.isGetterOrSetterInConfigurationPropertiesClass((PsiMethod)element);
        }
        return false;
    }

    private static boolean isGetterOrSetterInConfigurationPropertiesClass(PsiMethod psiMethod) {
        Project project = psiMethod.getProject();
        if (!SpringCommonUtils.hasSpringFacets((Project)project) || !SpringBootLibraryUtil.hasSpringBootLibrary(project)) {
            return false;
        }
        if (!PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)psiMethod)) {
            return false;
        }
        return SpringBootConfigurationPropertyReferenceSearcher.getPrefixIfRelevantPropertyMethod(psiMethod, false) != null;
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            ConfigurationPropertiesImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        return false;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            ConfigurationPropertiesImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/spring/boot/model/properties/ConfigurationPropertiesImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

