/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.jam;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringLiteralPsiClassConverter
extends JamConverter<PsiClass> {
    private static final JavaClassReferenceProvider JAVA_CLASS_REFERENCE_PROVIDER = new JavaClassReferenceProvider();

    @Nullable
    public PsiClass fromString(@Nullable String s, JamStringAttributeElement<PsiClass> context) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return null;
        }
        PsiAnnotationMemberValue psiElement = context.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)psiElement.getProject()).findClass(s, psiElement.getResolveScope());
    }

    public PsiReference @NotNull [] createReferences(@NotNull JamStringAttributeElement<PsiClass> context, @NotNull PsiLanguageInjectionHost injectionHost) {
        String stringValue;
        if (context == null) {
            StringLiteralPsiClassConverter.$$$reportNull$$$0(0);
        }
        if (injectionHost == null) {
            StringLiteralPsiClassConverter.$$$reportNull$$$0(1);
        }
        if ((stringValue = context.getStringValue()) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                StringLiteralPsiClassConverter.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        JavaClassReferenceSet set = new JavaClassReferenceSet(stringValue, (PsiElement)injectionHost, ElementManipulators.getOffsetInElement((PsiElement)injectionHost), false, JAVA_CLASS_REFERENCE_PROVIDER){

            public boolean isAllowDollarInNames() {
                return true;
            }
        };
        JavaClassReference[] javaClassReferenceArray = set.getAllReferences();
        if (javaClassReferenceArray == null) {
            StringLiteralPsiClassConverter.$$$reportNull$$$0(3);
        }
        return javaClassReferenceArray;
    }

    static {
        JAVA_CLASS_REFERENCE_PROVIDER.setOption(JavaClassReferenceProvider.ALLOW_DOLLAR_NAMES, (Object)Boolean.TRUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHost";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/jam/StringLiteralPsiClassConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/jam/StringLiteralPsiClassConverter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

