/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions.jam;

import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamEnumAttributeElement;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.semantic.SemKey;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionMessage;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionOutcome;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnBeanBase;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnBeanUtils;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnJamElement;
import com.intellij.spring.boot.model.jam.StringLiteralPsiClassConverter;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConditionalOnSingleCandidate
implements ConditionalOnJamElement.NonStrict {
    private static final JamClassAttributeMeta.Single VALUE_ATTRIBUTE = JamAttributeMeta.singleClass((String)"value");
    private static final JamStringAttributeMeta.Single<PsiClass> TYPE_ATTRIBUTE = JamAttributeMeta.singleString((String)"type", (JamConverter)new StringLiteralPsiClassConverter());
    private static final JamEnumAttributeMeta.Single<ConditionalOnBeanBase.SearchStrategy> SEARCH_STRATEGY_ATTRIBUTE = JamAttributeMeta.singleEnum((String)"search", ConditionalOnBeanBase.SearchStrategy.class);
    private static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate").addAttribute((JamAttributeMeta)VALUE_ATTRIBUTE).addAttribute(TYPE_ATTRIBUTE).addAttribute(SEARCH_STRATEGY_ATTRIBUTE);
    private static final SemKey<ConditionalOnSingleCandidate> SEM_KEY = CONDITIONAL_JAM_ELEMENT_KEY.subKey("ConditionalOnSingleCandidate", new SemKey[0]);
    public static final JamClassMeta<ConditionalOnSingleCandidate> CLASS_META = new JamClassMeta(null, ConditionalOnSingleCandidate.class, SEM_KEY).addAnnotation(ANNOTATION_META);
    public static final JamMethodMeta<ConditionalOnSingleCandidate> METHOD_META = new JamMethodMeta(null, ConditionalOnSingleCandidate.class, SEM_KEY).addAnnotation(ANNOTATION_META);

    @JamPsiConnector
    @NotNull
    public abstract PsiModifierListOwner getPsiElement();

    @Nullable
    public PsiClass getValue() {
        return ((JamClassAttributeElement)ANNOTATION_META.getAttribute(this.getPsiElement(), (JamAttributeMeta)VALUE_ATTRIBUTE)).getValue();
    }

    @Nullable
    public PsiClass getType() {
        return (PsiClass)((JamStringAttributeElement)ANNOTATION_META.getAttribute(this.getPsiElement(), TYPE_ATTRIBUTE)).getValue();
    }

    public ConditionalOnBeanBase.SearchStrategy getSearch() {
        ConditionalOnBeanBase.SearchStrategy searchStrategy = (ConditionalOnBeanBase.SearchStrategy)((JamEnumAttributeElement)ANNOTATION_META.getAttribute(this.getPsiElement(), SEARCH_STRATEGY_ATTRIBUTE)).getValue();
        return searchStrategy != null ? searchStrategy : ConditionalOnBeanBase.SearchStrategy.ALL;
    }

    @Override
    public ConditionOutcome matches(ConditionalOnEvaluationContext context) {
        CommonSpringModel springModel = (CommonSpringModel)context.getUserData(ConditionalOnEvaluationContext.MODEL_KEY);
        if (springModel == null) {
            return ConditionalOnBeanUtils.getMissingModelOutcome();
        }
        List<PsiType> psiTypes = this.getTypesToMatch();
        if (psiTypes.size() != 1) {
            return ConditionOutcome.noMatch(ConditionMessage.didNotFind("bean", new String[0]));
        }
        PsiType psiType = psiTypes.get(0);
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byType((PsiType)psiType).withInheritors().effectiveBeanTypes();
        List beans = ContainerUtil.map((Collection)SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)searchParameters), (Function)SpringBeanPointer.TO_BEAN);
        CommonSpringBean selfBean = ConditionalOnBeanUtils.getSpringBean((PsiElement)this.getPsiElement());
        if (selfBean != null) {
            beans.remove(selfBean);
        }
        if (beans.size() == 1 || ContainerUtil.filter((Collection)beans, CommonSpringBean::isPrimary).size() == 1) {
            return ConditionOutcome.match(ConditionMessage.found("bean", new String[0]));
        }
        return ConditionOutcome.noMatch(ConditionMessage.didNotFind("bean", new String[0]));
    }

    private List<PsiType> getTypesToMatch() {
        SmartList result2 = new SmartList();
        PsiClass psiClass = this.getValue();
        if (ConditionalOnSingleCandidate.isClassToSearch(psiClass)) {
            result2.add(PsiTypesUtil.getClassType((PsiClass)psiClass));
        }
        if (ConditionalOnSingleCandidate.isClassToSearch(psiClass = this.getType())) {
            result2.add(PsiTypesUtil.getClassType((PsiClass)psiClass));
        }
        if (!result2.isEmpty()) {
            return result2;
        }
        PsiModifierListOwner element = this.getPsiElement();
        if (element instanceof PsiMethod) {
            ContainerUtil.addIfNotNull((Collection)result2, (Object)ConditionalOnBeanUtils.getBeanType((PsiMethod)element));
        }
        return result2;
    }

    private static boolean isClassToSearch(PsiClass candidate) {
        return candidate != null && candidate.getQualifiedName() != "java.lang.Object";
    }
}

