/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionMessage;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionOutcome;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalContributor;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.model.utils.SpringCommonUtils;
import org.jetbrains.annotations.NotNull;

class PooledDataSourceCondition
extends ConditionalContributor {
    private static final String SPRING_DATASOURCE_TYPE = "spring.datasource.type";
    private static final String[] DATA_SOURCE_TYPE_NAMES = new String[]{"com.zaxxer.hikari.HikariDataSource", "org.apache.tomcat.jdbc.pool.DataSource", "org.apache.commons.dbcp2.BasicDataSource"};
    private static final Key<ConditionOutcome> OUR_KEY = Key.create((String)"PooledDataSourceCondition");

    PooledDataSourceCondition() {
    }

    @Override
    public ConditionOutcome matches(ConditionalOnEvaluationContext context) {
        ConditionOutcome conditionOutcome = (ConditionOutcome)context.getUserData(OUR_KEY);
        if (conditionOutcome == null) {
            conditionOutcome = (ConditionOutcome)context.putUserDataIfAbsent(OUR_KEY, this.calcConditionOutcome(context));
        }
        return conditionOutcome;
    }

    @NotNull
    private ConditionOutcome calcConditionOutcome(ConditionalOnEvaluationContext context) {
        if (this.hasConfigKey(context, SPRING_DATASOURCE_TYPE)) {
            ConditionOutcome conditionOutcome = ConditionOutcome.match(ConditionMessage.foundConfigKey(SPRING_DATASOURCE_TYPE));
            if (conditionOutcome == null) {
                PooledDataSourceCondition.$$$reportNull$$$0(0);
            }
            return conditionOutcome;
        }
        for (String dataSourceTypeName : DATA_SOURCE_TYPE_NAMES) {
            if (SpringCommonUtils.findLibraryClass((Module)context.getModule(), (String)dataSourceTypeName) == null) continue;
            ConditionOutcome conditionOutcome = ConditionOutcome.match(ConditionMessage.found("supported DataSource", dataSourceTypeName));
            if (conditionOutcome == null) {
                PooledDataSourceCondition.$$$reportNull$$$0(1);
            }
            return conditionOutcome;
        }
        ConditionOutcome conditionOutcome = ConditionOutcome.noMatch(ConditionMessage.didNotFind("supported DataSource", new String[0]));
        if (conditionOutcome == null) {
            PooledDataSourceCondition.$$$reportNull$$$0(2);
        }
        return conditionOutcome;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/conditions/PooledDataSourceCondition", "calcConditionOutcome"));
    }
}

