/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions;

import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.ConfigurationValueSearchParams;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionalOnEvaluationContextBase
extends UserDataHolderBase
implements ConditionalOnEvaluationContext {
    @NotNull
    private final PsiClass myAutoConfigClass;
    @NotNull
    private final Module myModule;
    @Nullable
    private final Set<String> myActiveProfiles;
    private final Map<SpringBootModelConfigFileContributor, List<VirtualFile>> myContributors;

    public ConditionalOnEvaluationContextBase(@NotNull PsiClass autoConfigClass, @NotNull Module module, @Nullable Set<String> activeProfiles, @NotNull Map<SpringBootModelConfigFileContributor, List<VirtualFile>> contributors, @Nullable ConditionalOnEvaluationContextBase sharedContext) {
        if (autoConfigClass == null) {
            ConditionalOnEvaluationContextBase.$$$reportNull$$$0(0);
        }
        if (module == null) {
            ConditionalOnEvaluationContextBase.$$$reportNull$$$0(1);
        }
        if (contributors == null) {
            ConditionalOnEvaluationContextBase.$$$reportNull$$$0(2);
        }
        this.myAutoConfigClass = autoConfigClass;
        this.myModule = module;
        this.myActiveProfiles = activeProfiles;
        this.myContributors = contributors;
        if (sharedContext != null) {
            sharedContext.copyUserDataTo(this);
        }
    }

    @Override
    @NotNull
    public PsiClass getAutoConfigClass() {
        PsiClass psiClass = this.myAutoConfigClass;
        if (psiClass == null) {
            ConditionalOnEvaluationContextBase.$$$reportNull$$$0(3);
        }
        return psiClass;
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            ConditionalOnEvaluationContextBase.$$$reportNull$$$0(4);
        }
        return module;
    }

    @Override
    @Nullable
    public Set<String> getActiveProfiles() {
        return this.myActiveProfiles;
    }

    @Override
    public boolean processConfigurationFiles(PairProcessor<SpringBootModelConfigFileContributor, List<VirtualFile>> processor2) {
        for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            if (processor2.process((Object)contributor, this.myContributors.get(contributor))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean processConfigurationValues(Processor<List<ConfigurationValueResult>> processor2, boolean checkRelaxedNames, MetaConfigKey ... configKeys) {
        if (configKeys == null) {
            ConditionalOnEvaluationContextBase.$$$reportNull$$$0(5);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.getModule().getProject());
        return this.processConfigurationFiles((PairProcessor<SpringBootModelConfigFileContributor, List<VirtualFile>>)((PairProcessor)(contributor, files) -> {
            Set<String> activeProfiles = SpringBootConfigValueSearcher.clearDefaultTestProfile(this.getActiveProfiles());
            for (VirtualFile file : files) {
                PsiFile psiFile = psiManager.findFile(file);
                if (psiFile == null) continue;
                for (MetaConfigKey key : configKeys) {
                    ConfigurationValueSearchParams params = new ConfigurationValueSearchParams(this.getModule(), psiFile, checkRelaxedNames, activeProfiles, key);
                    List<ConfigurationValueResult> values = contributor.findConfigurationValues(params);
                    if (processor2.process(values)) continue;
                    return false;
                }
                if (!ContainerUtil.isEmpty(this.getActiveProfiles())) continue;
                break;
            }
            return true;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoConfigClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributors";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/autoconfigure/conditions/ConditionalOnEvaluationContextBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/autoconfigure/conditions/ConditionalOnEvaluationContextBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoConfigClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processConfigurationValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

