/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemService;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.Conditional;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnJamElement;
import com.intellij.spring.model.jam.SpringOrder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConditionalCollector {
    private static final SemKey<JamMemberMeta> MEMBER_META_KEY = JamService.getMetaKey(ConditionalOnJamElement.CONDITIONAL_JAM_ELEMENT_KEY);
    private static final Integer DEFAULT_ORDER = SpringOrder.LOWEST_PRECEDENCE;
    private final PsiModifierListOwner myOwner;

    private ConditionalCollector(PsiModifierListOwner owner) {
        this.myOwner = owner;
    }

    static ConditionalCollector forClass(PsiClass psiClass) {
        return new ConditionalCollector((PsiModifierListOwner)psiClass);
    }

    static ConditionalCollector forMethod(PsiMethod psiMethod) {
        return new ConditionalCollector((PsiModifierListOwner)psiMethod);
    }

    @NotNull
    Collection<ConditionalOnJamElement> getConditionals() {
        List allConditionalMeta = SemService.getSemService((Project)this.myOwner.getProject()).getSemElements(MEMBER_META_KEY, (PsiElement)this.myOwner);
        if (allConditionalMeta.isEmpty()) {
            List<ConditionalOnJamElement> list = Collections.emptyList();
            if (list == null) {
                ConditionalCollector.$$$reportNull$$$0(0);
            }
            return list;
        }
        if (allConditionalMeta.size() == 1) {
            JamElement element = ((JamMemberMeta)allConditionalMeta.get(0)).getJamElement(this.myOwner);
            List<ConditionalOnJamElement> list = Collections.singletonList((ConditionalOnJamElement)element);
            if (list == null) {
                ConditionalCollector.$$$reportNull$$$0(1);
            }
            return list;
        }
        MultiMap sorted = new MultiMap(new TreeMap(Integer::compareTo));
        for (JamMemberMeta meta : allConditionalMeta) {
            ConditionalOnJamElement jamElement = (ConditionalOnJamElement)meta.getJamElement(this.myOwner);
            int order = this.calcOrder((JamMemberMeta<PsiModifierListOwner, ConditionalOnJamElement>)meta, jamElement);
            sorted.putValue((Object)order, (Object)jamElement);
        }
        Collection collection = sorted.values();
        if (collection == null) {
            ConditionalCollector.$$$reportNull$$$0(2);
        }
        return collection;
    }

    private int calcOrder(JamMemberMeta<PsiModifierListOwner, ConditionalOnJamElement> meta, ConditionalOnJamElement jamElement) {
        if (jamElement instanceof Conditional) {
            return ConditionalCollector.getOrderValue((Conditional)jamElement);
        }
        Conditional conditional = this.findConditionalForJam(meta);
        return ConditionalCollector.getOrderValue(conditional);
    }

    @Nullable
    private Conditional findConditionalForJam(JamMemberMeta<?, ?> meta) {
        JamAnnotationMeta annotationMeta = (JamAnnotationMeta)ContainerUtil.getFirstItem((List)meta.getAnnotations());
        if (annotationMeta == null) {
            throw new IllegalStateException("no annotation registered for JAM: " + meta);
        }
        String annotationFqn = annotationMeta.getAnnoName();
        PsiClass annotationPsiClass = JavaPsiFacade.getInstance((Project)this.myOwner.getProject()).findClass(annotationFqn, this.myOwner.getResolveScope());
        if (annotationPsiClass == null) {
            return null;
        }
        return (Conditional)Conditional.CLASS_META.getJamElement((PsiModifierListOwner)annotationPsiClass);
    }

    private static int getOrderValue(@Nullable Conditional conditional) {
        if (conditional == null) {
            return DEFAULT_ORDER;
        }
        PsiClass conditionClass = (PsiClass)ContainerUtil.getFirstItem(conditional.getValue());
        if (conditionClass == null) {
            return DEFAULT_ORDER;
        }
        SpringOrder order = (SpringOrder)SpringOrder.CLASS_META.getJamElement((PsiModifierListOwner)conditionClass);
        if (order == null) {
            return DEFAULT_ORDER;
        }
        return (Integer)ObjectUtils.notNull((Object)order.getValue(), (Object)DEFAULT_ORDER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/ConditionalCollector", "getConditionals"));
    }
}

