/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigureMetadataIndex;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spring/boot/model/autoconfigure/AutoConfigureMetadataIndex;", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "", "Lcom/intellij/spring/boot/model/autoconfigure/AutoConfigureMetadataIndex$AutoConfigureMetadata;", "()V", "dependsOnFileContent", "", "getIndexer", "Lcom/intellij/util/indexing/DataIndexer;", "Lcom/intellij/util/indexing/FileContent;", "getInputFilter", "Lcom/intellij/util/indexing/FileBasedIndex$InputFilter;", "getKeyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "getName", "Lcom/intellij/util/indexing/ID;", "getValueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "getVersion", "", "AutoConfigureMetadata", "Companion", "intellij.spring.boot.core"})
public final class AutoConfigureMetadataIndex
extends FileBasedIndexExtension<String, AutoConfigureMetadata> {
    private static final ID<String, AutoConfigureMetadata> NAME;
    @NonNls
    @NotNull
    public static final String SPRING_AUTOCONFIGURE_METADATA_PROPERTIES_FILENAME = "spring-autoconfigure-metadata.properties";
    @NotNull
    public static final Companion Companion;

    @NotNull
    public ID<String, AutoConfigureMetadata> getName() {
        return NAME;
    }

    @NotNull
    public DataIndexer<String, AutoConfigureMetadata, FileContent> getIndexer() {
        return (DataIndexer)new DataIndexer<String, AutoConfigureMetadata, FileContent>(){

            @NotNull
            public Map<String, AutoConfigureMetadata> map(@NotNull FileContent inputData) {
                Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
                PsiFile psiFile = inputData.getPsiFile();
                if (!(psiFile instanceof PropertiesFile)) {
                    psiFile = null;
                }
                PropertiesFile propertiesFile = (PropertiesFile)psiFile;
                if (propertiesFile == null) {
                    return MapsKt.emptyMap();
                }
                PropertiesFile file = propertiesFile;
                Map map2 = FactoryMap.create((Function)getIndexer.map.result.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"FactoryMap.create<String\u2026AutoConfigureMetadata() }");
                Map result2 = map2;
                Iterator<E> iterator = file.getProperties().iterator();
                while (iterator.hasNext()) {
                    IProperty property;
                    IProperty iProperty = property = (IProperty)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)iProperty, (String)"property");
                    String key = iProperty.getKey();
                    if (key == null) continue;
                    String configClassFqn = StringsKt.substringBeforeLast$default((String)key, (char)'.', null, (int)2, null);
                    CharSequence charSequence = configClassFqn;
                    boolean bl = false;
                    if (charSequence.length() == 0) continue;
                    V v = result2.get(configClassFqn);
                    Intrinsics.checkNotNull(v);
                    AutoConfigureMetadata metadata = (AutoConfigureMetadata)v;
                    if (StringsKt.endsWith$default((String)key, (String)".ConditionalOnClass", (boolean)false, (int)2, null)) {
                        metadata.getConditionalOnClass().addAll((Collection<String>)this.getValues(property));
                        continue;
                    }
                    if (StringsKt.endsWith$default((String)key, (String)".AutoConfigureAfter", (boolean)false, (int)2, null)) {
                        metadata.getAutoConfigureAfter().addAll((Collection<String>)this.getValues(property));
                        continue;
                    }
                    if (StringsKt.endsWith$default((String)key, (String)".AutoConfigureBefore", (boolean)false, (int)2, null)) {
                        metadata.getAutoConfigureBefore().addAll((Collection<String>)this.getValues(property));
                        continue;
                    }
                    if (!StringsKt.endsWith$default((String)key, (String)".AutoConfigureOrder", (boolean)false, (int)2, null)) continue;
                    String string = property.getValue();
                    metadata.setAutoConfigureOrder(string != null ? StringsKt.toIntOrNull((String)string) : null);
                }
                return result2;
            }

            private final List<String> getValues(IProperty property) {
                String string = property.getValue();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                return StringsKt.split$default((CharSequence)string2, (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null);
            }
        };
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)enumeratorStringDescriptor, (String)"EnumeratorStringDescriptor.INSTANCE");
        return (KeyDescriptor)enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<AutoConfigureMetadata> getValueExternalizer() {
        return (DataExternalizer)new DataExternalizer<AutoConfigureMetadata>(){

            public void save(@NotNull DataOutput out, @NotNull AutoConfigureMetadata value) throws IOException {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                DataInputOutputUtil.writeNullable((DataOutput)out, (Object)value.getAutoConfigureOrder(), (ThrowableConsumer)new ThrowableConsumer(out){
                    final /* synthetic */ DataOutput $out;

                    public final void consume(Integer integer) {
                        Integer n = integer;
                        Intrinsics.checkNotNull((Object)n);
                        DataInputOutputUtil.writeINT((DataOutput)this.$out, (int)n);
                    }
                    {
                        this.$out = dataOutput;
                    }
                });
                IOUtil.writeStringList((DataOutput)out, (Collection)value.getConditionalOnClass());
                IOUtil.writeStringList((DataOutput)out, (Collection)value.getAutoConfigureBefore());
                IOUtil.writeStringList((DataOutput)out, (Collection)value.getAutoConfigureAfter());
            }

            @NotNull
            public AutoConfigureMetadata read(@NotNull DataInput dataInput) throws IOException {
                Intrinsics.checkNotNullParameter((Object)dataInput, (String)"dataInput");
                AutoConfigureMetadata metadata = new AutoConfigureMetadata(null, null, null, null, 15, null);
                metadata.setAutoConfigureOrder((Integer)DataInputOutputUtil.readNullable((DataInput)dataInput, (ThrowableComputable)new ThrowableComputable(dataInput){
                    final /* synthetic */ DataInput $dataInput;

                    public final Integer compute() {
                        return DataInputOutputUtil.readINT((DataInput)this.$dataInput);
                    }
                    {
                        this.$dataInput = dataInput;
                    }
                }));
                List<String> list = metadata.getConditionalOnClass();
                List list2 = IOUtil.readStringList((DataInput)dataInput);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"IOUtil.readStringList(dataInput)");
                list.addAll(list2);
                List<String> list3 = metadata.getAutoConfigureBefore();
                List list4 = IOUtil.readStringList((DataInput)dataInput);
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"IOUtil.readStringList(dataInput)");
                list3.addAll(list4);
                List<String> list5 = metadata.getAutoConfigureAfter();
                List list6 = IOUtil.readStringList((DataInput)dataInput);
                Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"IOUtil.readStringList(dataInput)");
                list5.addAll(list6);
                return metadata;
            }
        };
    }

    public int getVersion() {
        return 2;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return getInputFilter.1.INSTANCE;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    static {
        Companion = new Companion(null);
        ID iD = ID.create((String)"spring.autoConfigureMetadataIndex");
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"ID.create<String, AutoCo\u2026oConfigureMetadataIndex\")");
        NAME = iD;
    }

    @JvmStatic
    @Nullable
    public static final AutoConfigureMetadata findMetadata(@NotNull PsiClass autoConfigClass) {
        return Companion.findMetadata(autoConfigClass);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0080\b\u0018\u00002\u00020\u0001BA\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003JJ\u0010\u0017\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001e\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/spring/boot/model/autoconfigure/AutoConfigureMetadataIndex$AutoConfigureMetadata;", "", "autoConfigureOrder", "", "conditionalOnClass", "", "", "autoConfigureAfter", "autoConfigureBefore", "(Ljava/lang/Integer;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAutoConfigureAfter", "()Ljava/util/List;", "getAutoConfigureBefore", "getAutoConfigureOrder", "()Ljava/lang/Integer;", "setAutoConfigureOrder", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getConditionalOnClass", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Integer;Ljava/util/List;Ljava/util/List;Ljava/util/List;)Lcom/intellij/spring/boot/model/autoconfigure/AutoConfigureMetadataIndex$AutoConfigureMetadata;", "equals", "", "other", "hashCode", "toString", "intellij.spring.boot.core"})
    public static final class AutoConfigureMetadata {
        @Nullable
        private Integer autoConfigureOrder;
        @NotNull
        private final List<String> conditionalOnClass;
        @NotNull
        private final List<String> autoConfigureAfter;
        @NotNull
        private final List<String> autoConfigureBefore;

        @Nullable
        public final Integer getAutoConfigureOrder() {
            return this.autoConfigureOrder;
        }

        public final void setAutoConfigureOrder(@Nullable Integer n) {
            this.autoConfigureOrder = n;
        }

        @NotNull
        public final List<String> getConditionalOnClass() {
            return this.conditionalOnClass;
        }

        @NotNull
        public final List<String> getAutoConfigureAfter() {
            return this.autoConfigureAfter;
        }

        @NotNull
        public final List<String> getAutoConfigureBefore() {
            return this.autoConfigureBefore;
        }

        public AutoConfigureMetadata(@Nullable Integer autoConfigureOrder, @NotNull List<String> conditionalOnClass, @NotNull List<String> autoConfigureAfter, @NotNull List<String> autoConfigureBefore) {
            Intrinsics.checkNotNullParameter(conditionalOnClass, (String)"conditionalOnClass");
            Intrinsics.checkNotNullParameter(autoConfigureAfter, (String)"autoConfigureAfter");
            Intrinsics.checkNotNullParameter(autoConfigureBefore, (String)"autoConfigureBefore");
            this.autoConfigureOrder = autoConfigureOrder;
            this.conditionalOnClass = conditionalOnClass;
            this.autoConfigureAfter = autoConfigureAfter;
            this.autoConfigureBefore = autoConfigureBefore;
        }

        public /* synthetic */ AutoConfigureMetadata(Integer n, List list, List list2, List list3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = null;
            }
            if ((n2 & 2) != 0) {
                list = (List)new SmartList();
            }
            if ((n2 & 4) != 0) {
                list2 = (List)new SmartList();
            }
            if ((n2 & 8) != 0) {
                list3 = (List)new SmartList();
            }
            this(n, list, list2, list3);
        }

        public AutoConfigureMetadata() {
            this(null, null, null, null, 15, null);
        }

        @Nullable
        public final Integer component1() {
            return this.autoConfigureOrder;
        }

        @NotNull
        public final List<String> component2() {
            return this.conditionalOnClass;
        }

        @NotNull
        public final List<String> component3() {
            return this.autoConfigureAfter;
        }

        @NotNull
        public final List<String> component4() {
            return this.autoConfigureBefore;
        }

        @NotNull
        public final AutoConfigureMetadata copy(@Nullable Integer autoConfigureOrder, @NotNull List<String> conditionalOnClass, @NotNull List<String> autoConfigureAfter, @NotNull List<String> autoConfigureBefore) {
            Intrinsics.checkNotNullParameter(conditionalOnClass, (String)"conditionalOnClass");
            Intrinsics.checkNotNullParameter(autoConfigureAfter, (String)"autoConfigureAfter");
            Intrinsics.checkNotNullParameter(autoConfigureBefore, (String)"autoConfigureBefore");
            return new AutoConfigureMetadata(autoConfigureOrder, conditionalOnClass, autoConfigureAfter, autoConfigureBefore);
        }

        public static /* synthetic */ AutoConfigureMetadata copy$default(AutoConfigureMetadata autoConfigureMetadata, Integer n, List list, List list2, List list3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = autoConfigureMetadata.autoConfigureOrder;
            }
            if ((n2 & 2) != 0) {
                list = autoConfigureMetadata.conditionalOnClass;
            }
            if ((n2 & 4) != 0) {
                list2 = autoConfigureMetadata.autoConfigureAfter;
            }
            if ((n2 & 8) != 0) {
                list3 = autoConfigureMetadata.autoConfigureBefore;
            }
            return autoConfigureMetadata.copy(n, list, list2, list3);
        }

        @NotNull
        public String toString() {
            return "AutoConfigureMetadata(autoConfigureOrder=" + this.autoConfigureOrder + ", conditionalOnClass=" + this.conditionalOnClass + ", autoConfigureAfter=" + this.autoConfigureAfter + ", autoConfigureBefore=" + this.autoConfigureBefore + ")";
        }

        public int hashCode() {
            Integer n = this.autoConfigureOrder;
            List<String> list = this.conditionalOnClass;
            List<String> list2 = this.autoConfigureAfter;
            List<String> list3 = this.autoConfigureBefore;
            return (((n != null ? ((Object)n).hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AutoConfigureMetadata)) break block3;
                    AutoConfigureMetadata autoConfigureMetadata = (AutoConfigureMetadata)object;
                    if (!Intrinsics.areEqual((Object)this.autoConfigureOrder, (Object)autoConfigureMetadata.autoConfigureOrder) || !Intrinsics.areEqual(this.conditionalOnClass, autoConfigureMetadata.conditionalOnClass) || !Intrinsics.areEqual(this.autoConfigureAfter, autoConfigureMetadata.autoConfigureAfter) || !Intrinsics.areEqual(this.autoConfigureBefore, autoConfigureMetadata.autoConfigureBefore)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007R/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0000X\u0081T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/boot/model/autoconfigure/AutoConfigureMetadataIndex$Companion;", "", "()V", "NAME", "Lcom/intellij/util/indexing/ID;", "", "kotlin.jvm.PlatformType", "Lcom/intellij/spring/boot/model/autoconfigure/AutoConfigureMetadataIndex$AutoConfigureMetadata;", "Lorg/jetbrains/annotations/NotNull;", "SPRING_AUTOCONFIGURE_METADATA_PROPERTIES_FILENAME", "findMetadata", "autoConfigClass", "Lcom/intellij/psi/PsiClass;", "intellij.spring.boot.core"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final AutoConfigureMetadata findMetadata(@NotNull PsiClass autoConfigClass) {
            Intrinsics.checkNotNullParameter((Object)autoConfigClass, (String)"autoConfigClass");
            String string = autoConfigClass.getQualifiedName();
            if (string == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"autoConfigClass.qualifiedName ?: return null");
            String fqn = string;
            List list = FileBasedIndex.getInstance().getValues(NAME, (Object)fqn, autoConfigClass.getResolveScope());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"FileBasedIndex.getInstan\u2026ConfigClass.resolveScope)");
            List values = list;
            return (AutoConfigureMetadata)CollectionsKt.firstOrNull((List)values);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

