/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.spring.boot.model.autoconfigure.ConditionalCollector;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionOutcome;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnJamElement;
import java.util.Collection;

abstract class AutoConfigConditionEvaluatorBase {
    private final boolean myNonStrictEvaluation;
    private final ConditionalOnEvaluationContext myConditionalOnEvaluationContext;

    AutoConfigConditionEvaluatorBase(boolean nonStrictEvaluation, ConditionalOnEvaluationContext conditionalOnEvaluationContext) {
        this.myNonStrictEvaluation = nonStrictEvaluation;
        this.myConditionalOnEvaluationContext = conditionalOnEvaluationContext;
    }

    protected abstract ConditionalCollector getConditionalCollector();

    boolean isActive() {
        Collection<ConditionalOnJamElement> allConditions = this.getConditionalCollector().getConditionals();
        if (allConditions.isEmpty()) {
            return true;
        }
        for (ConditionalOnJamElement condition : allConditions) {
            ConditionOutcome outcome;
            if (this.myNonStrictEvaluation && condition instanceof ConditionalOnJamElement.NonStrict || (outcome = condition.matches(this.myConditionalOnEvaluationContext)).isMatch()) continue;
            return false;
        }
        return true;
    }
}

