/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassSorter;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class AutoConfigClassCollector {
    @NonNls
    private static final String SPRING_AUTOCONFIGURE_EXCLUDE = "spring.autoconfigure.exclude";
    private final EnableAutoConfiguration myEnableAutoConfiguration;
    private final ConditionalOnEvaluationContext myConditionalOnEvaluationContext;

    AutoConfigClassCollector(EnableAutoConfiguration enableAutoConfiguration, ConditionalOnEvaluationContext sharedContext) {
        this.myEnableAutoConfiguration = enableAutoConfiguration;
        this.myConditionalOnEvaluationContext = sharedContext;
    }

    List<PsiClass> getAllAutoConfigurationClasses() {
        Module module = this.myConditionalOnEvaluationContext.getModule();
        List<PsiClass> allAutoConfigurationClasses = AutoConfigClassCollector.getAllRegisteredAutoConfigurationClasses(module);
        List<PsiClass> excludedViaAnnotation = this.myEnableAutoConfiguration.getExcludes();
        allAutoConfigurationClasses.removeAll(excludedViaAnnotation);
        Processor autoConfigExcludedProcessor = results -> {
            ConfigurationValueResult item = (ConfigurationValueResult)ContainerUtil.getFirstItem((List)results);
            if (item != null && item.getValueElement() != null) {
                for (PsiReference reference : item.getValueElement().getReferences()) {
                    PsiElement resolve = reference.resolve();
                    if (!(resolve instanceof PsiClass)) continue;
                    allAutoConfigurationClasses.remove((PsiClass)resolve);
                }
            }
            return false;
        };
        this.myConditionalOnEvaluationContext.processConfigurationValues((Processor<List<ConfigurationValueResult>>)autoConfigExcludedProcessor, true, SPRING_AUTOCONFIGURE_EXCLUDE);
        AutoConfigClassSorter sorter = new AutoConfigClassSorter(module, allAutoConfigurationClasses);
        return sorter.getSortedConfigs();
    }

    private static List<PsiClass> getAllRegisteredAutoConfigurationClasses(@NotNull Module module) {
        if (module == null) {
            AutoConfigClassCollector.$$$reportNull$$$0(0);
        }
        if (module.isDisposed()) {
            return Collections.emptyList();
        }
        List allFromConfig = SpringSpiManager.getInstance((Module)module).getClassesListValue(false, "org.springframework.boot.autoconfigure.EnableAutoConfiguration");
        ContainerUtil.removeDuplicates((Collection)allFromConfig);
        return allFromConfig;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/model/autoconfigure/AutoConfigClassCollector", "getAllRegisteredAutoConfigurationClasses"));
    }
}

