/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.SpringModelProvider;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootApplicationFileSet;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.SpringBootModelConfigFileNameContributor;
import com.intellij.spring.boot.model.SpringBootModelExtender;
import com.intellij.spring.facet.SpringAutodetectedFileSet;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootModelProvider
implements SpringModelProvider {
    private static final ExtensionPointName<SpringBootModelExtender> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.boot.modelExtender");

    public SpringBootModelProvider() {
        EP_NAME.addChangeListener(SpringAutodetectedFileSet::refreshAutodetectedFileSets, null);
        SpringBootModelConfigFileContributor.EP_NAME.addChangeListener(SpringAutodetectedFileSet::refreshAutodetectedFileSets, null);
        SpringBootModelConfigFileNameContributor.EP_NAME.addChangeListener(SpringAutodetectedFileSet::refreshAutodetectedFileSets, null);
    }

    @NotNull
    public List<? extends SpringAutodetectedFileSet> getFilesets(@NotNull SpringFacet facet) {
        Module currentFacetModule;
        if (facet == null) {
            SpringBootModelProvider.$$$reportNull$$$0(0);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(currentFacetModule = facet.getModule())) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringBootModelProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        Project project = currentFacetModule.getProject();
        List list = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)facet, () -> {
            Module module = facet.getModule();
            PsiClass applicationClass = SpringBootModelProvider.findSingleSpringBootApplication(module);
            if (applicationClass == null || applicationClass.getQualifiedName() == null) {
                return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            SpringBootApplicationFileSet bootFileSet = new SpringBootApplicationFileSet(applicationClass, facet);
            for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
                for (VirtualFile file : contributor.getConfigurationFiles(module, (SpringFileSet)bootFileSet, false)) {
                    bootFileSet.addFile(file);
                }
            }
            SpringFacetConfiguration configuration = (SpringFacetConfiguration)facet.getConfiguration();
            configuration.registerAutodetectedFileSet((SpringFileSet)bootFileSet);
            SmartList fileSets = new SmartList((Object)bootFileSet);
            for (SpringBootModelExtender extender : (SpringBootModelExtender[])EP_NAME.getExtensions()) {
                fileSets.addAll(extender.getAdditionalFileSets((SpringFileSet)bootFileSet));
            }
            Object[] springOuterModelsTracker = SpringModificationTrackersManager.getInstance((Project)module.getProject()).getOuterModelsDependencies();
            return CachedValueProvider.Result.create((Object)fileSets, (Object[])ArrayUtil.append((Object[])springOuterModelsTracker, (Object)configuration.getSettingsModificationTracker()));
        });
        if (list == null) {
            SpringBootModelProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    public String getName() {
        return "Spring Boot";
    }

    @Nullable
    private static PsiClass findSingleSpringBootApplication(Module module) {
        List<PsiClass> results = SpringBootApplicationService.getInstance().getSpringApplications(module);
        return results.size() == 1 ? (PsiClass)ContainerUtil.getFirstItem(results) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/SpringBootModelProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/SpringBootModelProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesets";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

