/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.beans.CustomSetting;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBootModelConfigFileNameContributor {
    public static final ExtensionPointName<SpringBootModelConfigFileNameContributor> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.boot.modelConfigFileNameContributor");
    private final CustomSettingDescriptor myCustomNameSettingDescriptor;
    private final CustomSettingDescriptor myCustomFilesSettingDescriptor;
    private final CustomizationPresentation myCustomizationPresentation;
    private final Icon myFileIcon;

    protected SpringBootModelConfigFileNameContributor(@NotNull CustomSettingDescriptor customNameSettingDescriptor, @NotNull CustomSettingDescriptor customFilesSettingDescriptor, @NotNull CustomizationPresentation presentation, @NotNull Icon fileIcon) {
        if (customNameSettingDescriptor == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(0);
        }
        if (customFilesSettingDescriptor == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(1);
        }
        if (presentation == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(2);
        }
        if (fileIcon == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(3);
        }
        this.myCustomNameSettingDescriptor = customNameSettingDescriptor;
        this.myCustomFilesSettingDescriptor = customFilesSettingDescriptor;
        this.myCustomizationPresentation = presentation;
        this.myFileIcon = fileIcon;
    }

    @NotNull
    public final CustomSettingDescriptor getCustomNameSettingDescriptor() {
        CustomSettingDescriptor customSettingDescriptor = this.myCustomNameSettingDescriptor;
        if (customSettingDescriptor == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(4);
        }
        return customSettingDescriptor;
    }

    @NotNull
    public final CustomSettingDescriptor getCustomFilesSettingDescriptor() {
        CustomSettingDescriptor customSettingDescriptor = this.myCustomFilesSettingDescriptor;
        if (customSettingDescriptor == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(5);
        }
        return customSettingDescriptor;
    }

    @NotNull
    public CustomizationPresentation getCustomizationPresentation() {
        CustomizationPresentation customizationPresentation = this.myCustomizationPresentation;
        if (customizationPresentation == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(6);
        }
        return customizationPresentation;
    }

    @NotNull
    public Icon getFileIcon() {
        Icon icon = this.myFileIcon;
        if (icon == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(7);
        }
        return icon;
    }

    public abstract boolean accept(SpringFileSet var1);

    public abstract boolean accept(Module var1);

    @NotNull
    public String getSpringConfigName(@NotNull Module module) {
        SpringFacet springFacet;
        if (module == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(8);
        }
        if ((springFacet = SpringBootModelConfigFileNameContributor.getRelevantFacet(module)) == null) {
            String string = this.getCustomNameSettingDescriptor().defaultValue;
            if (string == null) {
                SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(9);
            }
            return string;
        }
        CustomSetting.STRING setting = (CustomSetting.STRING)springFacet.findSetting(this.getCustomNameSettingDescriptor().key);
        assert (setting != null);
        String string = StringUtil.notNullize((String)setting.getStringValue(), (String)setting.getDefaultValue());
        if (string == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public List<String> getCustomConfigFileUrls(@NotNull Module module) {
        SpringFacet springFacet;
        if (module == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(11);
        }
        if ((springFacet = SpringBootModelConfigFileNameContributor.getRelevantFacet(module)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(12);
            }
            return list;
        }
        CustomSetting.STRING setting = (CustomSetting.STRING)springFacet.findSetting(this.getCustomFilesSettingDescriptor().key);
        assert (setting != null);
        String value = setting.getStringValue();
        if (value == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(13);
            }
            return list;
        }
        List list = StringUtil.split((String)value, (String)";");
        if (list == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    private static SpringFacet getRelevantFacet(Module module) {
        SpringFacet facet = SpringBootModelConfigFileNameContributor.findSpringBootApplicationFacet(module);
        if (facet != null) {
            return facet;
        }
        if (module.isDisposed()) {
            return null;
        }
        for (Module dependentModule : ModuleRootManager.getInstance((Module)module).getDependencies()) {
            SpringFacet dependentFacet = SpringBootModelConfigFileNameContributor.findSpringBootApplicationFacet(dependentModule);
            if (dependentFacet == null) continue;
            return dependentFacet;
        }
        return null;
    }

    @Nullable
    private static SpringFacet findSpringBootApplicationFacet(Module module) {
        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
        if (springFacet == null) {
            return null;
        }
        List<PsiClass> applications = SpringBootApplicationService.getInstance().getSpringApplications(module);
        return applications.isEmpty() ? null : springFacet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customNameSettingDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customFilesSettingDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIcon";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/SpringBootModelConfigFileNameContributor";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/SpringBootModelConfigFileNameContributor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomNameSettingDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomFilesSettingDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomizationPresentation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileIcon";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringConfigName";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomConfigFileUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSpringConfigName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCustomConfigFileUrls";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CustomizationPresentation {
        @NlsSafe
        public final String configFileKey;
        public final @NlsContexts.BorderTitle String customizationPanelTitle;

        public CustomizationPresentation(@NlsSafe String configFileKey, @NlsContexts.BorderTitle String customizationPanelTitle) {
            this.configFileKey = configFileKey;
            this.customizationPanelTitle = customizationPanelTitle;
        }
    }

    public static class CustomSettingDescriptor {
        public final Key<CustomSetting.STRING> key;
        @Nls
        public final String description;
        public final String defaultValue;

        public CustomSettingDescriptor(Key<CustomSetting.STRING> key, @Nls String description, String defaultValue) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
        }

        public CustomSetting.STRING createCustomSetting() {
            return new CustomSetting.STRING(this.key, this.description, this.defaultValue);
        }
    }
}

