/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.ConfigurationValueSearchParams;
import com.intellij.spring.boot.model.SpringBootModelConfigFileNameContributor;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class SpringBootModelConfigFileContributor {
    public static final ExtensionPointName<SpringBootModelConfigFileContributor> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.boot.modelConfigFileContributor");
    private static final Comparator<VirtualFile> VF_BY_NAME_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
    private static final boolean OUR_TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
    private final FileType myFileType;
    private static boolean USE_RESOURCE_ROOTS_FOR_TESTS = false;

    protected SpringBootModelConfigFileContributor(FileType fileType) {
        this.myFileType = fileType;
    }

    public FileType getFileType() {
        return this.myFileType;
    }

    public List<VirtualFile> getConfigurationFiles(Module module, boolean includeTestScope) {
        SmartList files = new SmartList();
        for (SpringBootModelConfigFileNameContributor fileNameContributor : (SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()) {
            if (!fileNameContributor.accept(module)) continue;
            files.addAll(this.getConfigurationFiles(module, fileNameContributor, includeTestScope));
        }
        return files;
    }

    public List<VirtualFile> getConfigurationFiles(Module module, SpringFileSet fileSet, boolean includeTestScope) {
        SmartList files = new SmartList();
        for (SpringBootModelConfigFileNameContributor fileNameContributor : (SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()) {
            if (!fileNameContributor.accept(fileSet)) continue;
            files.addAll(this.getConfigurationFiles(module, fileNameContributor, includeTestScope));
            break;
        }
        return files;
    }

    public List<VirtualFile> getConfigurationFiles(Module module, SpringBootModelConfigFileNameContributor fileNameContributor, boolean includeTestScope) {
        String springConfigName = fileNameContributor.getSpringConfigName(module);
        List<VirtualFile> userConfigurationFiles = this.findApplicationConfigFiles(module, includeTestScope, springConfigName);
        return ContainerUtil.concat(userConfigurationFiles, SpringBootModelConfigFileContributor.findCustomConfigFiles(module, fileNameContributor));
    }

    private static List<VirtualFile> findCustomConfigFiles(Module module, SpringBootModelConfigFileNameContributor fileNameContributor) {
        List<String> urls = fileNameContributor.getCustomConfigFileUrls(module);
        if (urls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(urls.size());
        for (String url : urls) {
            VirtualFile configFile = VirtualFileManager.getInstance().findFileByUrl(url);
            ContainerUtil.addIfNotNull(files, (Object)configFile);
        }
        return files;
    }

    public List<VirtualFile> findApplicationConfigFiles(Module module, boolean includeTestScope, @NotNull String baseName) {
        if (baseName == null) {
            SpringBootModelConfigFileContributor.$$$reportNull$$$0(0);
        }
        List<VirtualFile> productionConfigFiles = this.findConfigFilesInScope(module, false, baseName);
        if (!includeTestScope) {
            return productionConfigFiles;
        }
        List<VirtualFile> testConfigFiles = this.findConfigFilesInScope(module, true, baseName);
        return ContainerUtil.concat(productionConfigFiles, testConfigFiles);
    }

    private List<VirtualFile> findConfigFilesInScope(Module module, boolean testScope, @NotNull String baseName) {
        List<Object> matchingProfileConfigFiles;
        GlobalSearchScope configFileSearchScope;
        if (baseName == null) {
            SpringBootModelConfigFileContributor.$$$reportNull$$$0(1);
        }
        if ((configFileSearchScope = this.getConfigFileSearchScope(module, testScope)) == null) {
            return Collections.emptyList();
        }
        String fileNamePrefix = baseName + "-";
        SmartList baseNameConfigFiles = new SmartList();
        SmartList profileConfigFiles = new SmartList();
        FileTypeIndex.processFiles((FileType)this.myFileType, arg_0 -> SpringBootModelConfigFileContributor.lambda$findConfigFilesInScope$1(baseName, (Collection)baseNameConfigFiles, fileNamePrefix, (Collection)profileConfigFiles, arg_0), (GlobalSearchScope)configFileSearchScope);
        if (baseNameConfigFiles.isEmpty() && profileConfigFiles.isEmpty()) {
            return Collections.emptyList();
        }
        if (baseNameConfigFiles.size() > 1) {
            return Collections.emptyList();
        }
        @Nullable VirtualFile baseNameConfigFile = (VirtualFile)ContainerUtil.getFirstItem((Collection)baseNameConfigFiles);
        SmartList result2 = new SmartList();
        ContainerUtil.addIfNotNull((Collection)result2, (Object)baseNameConfigFile);
        if (profileConfigFiles.isEmpty()) {
            return result2;
        }
        if (baseNameConfigFile != null) {
            VirtualFile parentDirectory = baseNameConfigFile.getParent();
            if (parentDirectory == null) {
                return result2;
            }
            GlobalSearchScope containingDirectoryScope = GlobalSearchScopesCore.directoryScope((Project)module.getProject(), (VirtualFile)parentDirectory, (boolean)false);
            matchingProfileConfigFiles = ContainerUtil.filter((Collection)profileConfigFiles, file -> containingDirectoryScope.contains(file));
        } else {
            matchingProfileConfigFiles = new ArrayList<VirtualFile>((Collection<VirtualFile>)profileConfigFiles);
        }
        matchingProfileConfigFiles.sort(VF_BY_NAME_COMPARATOR);
        result2.addAll(matchingProfileConfigFiles);
        return result2;
    }

    @Nullable
    public GlobalSearchScope getConfigFileSearchScope(Module module, boolean testScope) {
        if (OUR_TEST_MODE && !USE_RESOURCE_ROOTS_FOR_TESTS) {
            return module.getModuleScope(testScope);
        }
        if (module.isDisposed()) {
            return null;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        List resourceRoots = moduleRootManager.getSourceRoots((JpsModuleSourceRootType)(testScope ? JavaResourceRootType.TEST_RESOURCE : JavaResourceRootType.RESOURCE));
        if (resourceRoots.isEmpty()) {
            return null;
        }
        return GlobalSearchScopesCore.directoriesScope((Project)module.getProject(), (boolean)true, (VirtualFile[])resourceRoots.toArray(VirtualFile.EMPTY_ARRAY));
    }

    @NotNull
    public abstract List<ConfigurationValueResult> findConfigurationValues(ConfigurationValueSearchParams var1);

    protected static boolean isProfileRelevant(@NotNull ConfigurationValueSearchParams params, @Nullable String fileNameSuffix) {
        if (params == null) {
            SpringBootModelConfigFileContributor.$$$reportNull$$$0(2);
        }
        Set<String> activeProfiles = params.getActiveProfiles();
        return fileNameSuffix == null || ContainerUtil.isEmpty(activeProfiles) || params.isProcessAllProfiles() || activeProfiles.contains(fileNameSuffix);
    }

    @TestOnly
    public static void setUseResourceRootsForTests(boolean useResourceRootsForTests) {
        USE_RESOURCE_ROOTS_FOR_TESTS = useResourceRootsForTests;
    }

    private static /* synthetic */ boolean lambda$findConfigFilesInScope$1(String baseName, Collection baseNameConfigFiles, String fileNamePrefix, Collection profileConfigFiles, VirtualFile file) {
        String fileName = file.getNameWithoutExtension();
        if (fileName.equals(baseName)) {
            baseNameConfigFiles.add(file);
        } else if (StringUtil.startsWith((CharSequence)fileName, (CharSequence)fileNamePrefix)) {
            profileConfigFiles.add(file);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/model/SpringBootModelConfigFileContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findApplicationConfigFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findConfigFilesInScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isProfileRelevant";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

