/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.ConfigurationValueSearchParams;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007J\u0014\u0010\u000f\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/spring/boot/model/SpringBootConfigValueSearcher;", "", "myModule", "Lcom/intellij/openapi/module/Module;", "myIncludeTests", "", "myConfigKey", "", "myCheckRelaxedNames", "myActiveProfiles", "", "myKeyIndex", "myKeyProperty", "(Lcom/intellij/openapi/module/Module;ZLjava/lang/String;ZLjava/util/Set;Ljava/lang/String;Ljava/lang/String;)V", "findValueText", "process", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/spring/boot/model/ConfigurationValueResult;", "Companion", "intellij.spring.boot"})
public final class SpringBootConfigValueSearcher {
    private final Module myModule;
    private final boolean myIncludeTests;
    private final String myConfigKey;
    private final boolean myCheckRelaxedNames;
    private final Set<String> myActiveProfiles;
    private final String myKeyIndex;
    private final String myKeyProperty;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String findValueText() {
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"Ref.create<String>()");
        Ref valueText = ref;
        Processor findValueTextProcessor2 = new Processor(valueText){
            final /* synthetic */ Ref $valueText;

            public final boolean process(ConfigurationValueResult result2) {
                String string = result2.getValueText();
                if (string == null) {
                    return true;
                }
                String text = string;
                this.$valueText.set((Object)text);
                return false;
            }
            {
                this.$valueText = ref;
            }
        };
        this.process((Processor<ConfigurationValueResult>)findValueTextProcessor2);
        return (String)valueText.get();
    }

    public final boolean process(@NotNull Processor<ConfigurationValueResult> processor2) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        MetaConfigKey metaConfigKey = SpringBootApplicationMetaConfigKeyManager.getInstance().findApplicationMetaConfigKey(this.myModule, this.myConfigKey);
        if (metaConfigKey == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)metaConfigKey, (String)"SpringBootApplicationMet\u2026ConfigKey) ?: return true");
        MetaConfigKey metaConfigKey2 = metaConfigKey;
        MetaConfigKey.Deprecation deprecation = metaConfigKey2.getDeprecation();
        Intrinsics.checkNotNullExpressionValue((Object)deprecation, (String)"metaConfigKey.deprecation");
        if (deprecation.getLevel() == MetaConfigKey.Deprecation.DeprecationLevel.ERROR) {
            return true;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myModule.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(myModule.project)");
        PsiManager psiManager2 = psiManager;
        Set<String> activeProfiles = Companion.clearDefaultTestProfile(this.myActiveProfiles);
        ExtensionPointName<SpringBootModelConfigFileContributor> extensionPointName = SpringBootModelConfigFileContributor.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"SpringBootModelConfigFileContributor.EP_NAME");
        for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])extensionPointName.getExtensions()) {
            for (VirtualFile virtualFile : contributor.getConfigurationFiles(this.myModule, this.myIncludeTests)) {
                List<ConfigurationValueResult> result2;
                PsiFile configPsiFile;
                if (psiManager2.findFile(virtualFile) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)configPsiFile, (String)"psiManager.findFile(virtualFile) ?: continue");
                ConfigurationValueSearchParams params = new ConfigurationValueSearchParams(this.myModule, configPsiFile, this.myCheckRelaxedNames, activeProfiles, metaConfigKey2, this.myKeyIndex, this.myKeyProperty);
                Intrinsics.checkNotNullExpressionValue(contributor.findConfigurationValues(params), (String)"contributor.findConfigurationValues(params)");
                if (ContainerUtil.process(result2, processor2)) continue;
                return false;
            }
        }
        return true;
    }

    public SpringBootConfigValueSearcher(@NotNull Module myModule, boolean myIncludeTests, @NotNull String myConfigKey, boolean myCheckRelaxedNames, @Nullable Set<String> myActiveProfiles, @Nullable String myKeyIndex, @Nullable String myKeyProperty) {
        Intrinsics.checkNotNullParameter((Object)myModule, (String)"myModule");
        Intrinsics.checkNotNullParameter((Object)myConfigKey, (String)"myConfigKey");
        this.myModule = myModule;
        this.myIncludeTests = myIncludeTests;
        this.myConfigKey = myConfigKey;
        this.myCheckRelaxedNames = myCheckRelaxedNames;
        this.myActiveProfiles = myActiveProfiles;
        this.myKeyIndex = myKeyIndex;
        this.myKeyProperty = myKeyProperty;
    }

    public /* synthetic */ SpringBootConfigValueSearcher(Module module, boolean bl, String string, boolean bl2, Set set, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            set = null;
        }
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        if ((n & 0x40) != 0) {
            string3 = null;
        }
        this(module, bl, string, bl2, set, string2, string3);
    }

    @JvmStatic
    @NotNull
    public static final SpringBootConfigValueSearcher productionForProfiles(@NotNull Module module, @NotNull String configKey, @Nullable Set<String> activeProfiles) {
        return Companion.productionForProfiles(module, configKey, activeProfiles);
    }

    @JvmStatic
    @NotNull
    public static final SpringBootConfigValueSearcher productionForProfiles(@NotNull Module module, @NotNull String configKey, @Nullable Set<String> activeProfiles, @Nullable String keyIndex, @Nullable String keyProperty) {
        return Companion.productionForProfiles(module, configKey, activeProfiles, keyIndex, keyProperty);
    }

    @JvmStatic
    @Nullable
    public static final Set<String> clearDefaultTestProfile(@Nullable Set<String> activeProfiles) {
        return Companion.clearDefaultTestProfile(activeProfiles);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0007J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0007J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/spring/boot/model/SpringBootConfigValueSearcher$Companion;", "", "()V", "clearDefaultTestProfile", "", "", "activeProfiles", "productionForProfiles", "Lcom/intellij/spring/boot/model/SpringBootConfigValueSearcher;", "module", "Lcom/intellij/openapi/module/Module;", "configKey", "keyIndex", "keyProperty", "intellij.spring.boot"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final SpringBootConfigValueSearcher productionForProfiles(@NotNull Module module, @NotNull String configKey, @Nullable Set<String> activeProfiles) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
            return new SpringBootConfigValueSearcher(module, false, configKey, false, activeProfiles, null, null, 106, null);
        }

        @JvmStatic
        @NotNull
        public final SpringBootConfigValueSearcher productionForProfiles(@NotNull Module module, @NotNull String configKey, @Nullable Set<String> activeProfiles, @Nullable String keyIndex, @Nullable String keyProperty) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
            return new SpringBootConfigValueSearcher(module, false, configKey, false, activeProfiles, keyIndex, keyProperty, 10, null);
        }

        @JvmStatic
        @Nullable
        public final Set<String> clearDefaultTestProfile(@Nullable Set<String> activeProfiles) {
            if (activeProfiles == null) {
                return null;
            }
            if (activeProfiles.contains("_DEFAULT_TEST_PROFILE_NAME_")) {
                LinkedHashSet result2 = new LinkedHashSet(activeProfiles);
                result2.remove("_DEFAULT_TEST_PROFILE_NAME_");
                return result2;
            }
            return activeProfiles;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

